/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview.admin;

import dexlogic.NetView;
import dexlogic.devlog.WDeviceLogFrame;
import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.ESATarget;
import dexlogic.netview.NetViewDeviceNode;
import dexlogic.netview.WNetViewFrame;
import dexlogic.netview.layout.L05WFirmwareDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class A04NetViewDeviceNode
extends NetViewDeviceNode {
    private void escapeHTML(StringBuilder stringBuilder, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                stringBuilder.append("&#");
                stringBuilder.append((int)c);
                stringBuilder.append(';');
                continue;
            }
            stringBuilder.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserObject() {
        Object object;
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        ESATarget eSATarget = new ESATarget();
        try {
            object = this.getHost();
            if (((ESAHost)object).isReachable()) {
                ESARoute eSARoute = ((ESAHost)object).getDefaultRoute();
                eSATarget.openConnection(eSARoute.getRemoteAddress(), eSARoute.getLocalAddress());
                string2 = eSATarget.retrieveLabel();
                string = eSATarget.retrieveName();
                byArray = eSATarget.retrieveIconBytes();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                eSATarget.closeConnection();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("<html>");
        if (string != null) {
            this.escapeHTML((StringBuilder)object, string);
            ((StringBuilder)object).append("<br>");
        }
        if (string2 != null) {
            this.escapeHTML((StringBuilder)object, string2);
            ((StringBuilder)object).append("<br>");
        }
        ((StringBuilder)object).append(this.getHostAddressField());
        ((StringBuilder)object).append("</html>");
        this.setUserObject(((StringBuilder)object).toString());
        if (byArray != null) {
            this.setIcon(new ImageIcon(byArray));
        }
    }

    private void addExpertMenu(JTree jTree, JPopupMenu jPopupMenu) {
        ESAHost eSAHost = this.getHost();
        boolean bl = eSAHost.isReachable();
        jPopupMenu.add(new JPopupMenu.Separator());
        JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Device Log"));
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(new AbstractAction(){
            JTree tree;

            public AbstractAction init(JTree jTree) {
                this.tree = jTree;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESAHost eSAHost = A04NetViewDeviceNode.this.getHost();
                try {
                    boolean bl = NetView.verboseMode;
                    WDeviceLogFrame wDeviceLogFrame = new WDeviceLogFrame(eSAHost, bl);
                    wDeviceLogFrame.pack();
                    wDeviceLogFrame.setVisible(true);
                }
                catch (IOException iOException) {
                    String string = "Can't open dialog";
                    WNetViewFrame.showIOError(this.tree, string, iOException);
                }
            }
        }.init(jTree));
    }

    @Override
    protected void updateDisplay() {
        this.updateUserObject();
    }

    @Override
    protected void hostChanged() {
        this.updateUserObject();
    }

    public A04NetViewDeviceNode(ESAHost eSAHost) {
        super(eSAHost);
        this.updateUserObject();
    }

    @Override
    public void showPopup(JTree jTree, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ESAHost eSAHost = this.getHost();
        boolean bl = eSAHost.isReachable();
        JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Unit Setup..."));
        jMenuItem.setEnabled(false);
        jMenuItem = jPopupMenu.add(new JMenuItem("Service Setup..."));
        jMenuItem.setEnabled(false);
        jMenuItem = jPopupMenu.add(new JMenuItem("Coupler Setup..."));
        jMenuItem.setEnabled(false);
        jPopupMenu.add(new JPopupMenu.Separator());
        jMenuItem = jPopupMenu.add(new JMenuItem("Firmware"));
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        jMenuItem.addActionListener(new AbstractAction(){
            JTree tree;

            public AbstractAction init(JTree jTree) {
                this.tree = jTree;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ESAHost eSAHost = A04NetViewDeviceNode.this.getHost();
                try {
                    Window window = SwingUtilities.getWindowAncestor(this.tree);
                    if (eSAHost.getLayoutDialogID() != 5) {
                        throw new IOException("Unknown memory layout");
                    }
                    L05WFirmwareDialog l05WFirmwareDialog = new L05WFirmwareDialog(window, eSAHost);
                    l05WFirmwareDialog.setVisible(true);
                }
                catch (IOException iOException) {
                    String string = "Can't open dialog";
                    WNetViewFrame.showIOError(this.tree, string, iOException);
                }
            }
        }.init(jTree));
        if (NetView.expertMode) {
            this.addExpertMenu(jTree, jPopupMenu);
        }
        jPopupMenu.show(jTree, n, n2);
    }
}

