/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.netview;

import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESARoute;
import dexlogic.netview.NetViewTreeNode;

public class NetViewDeviceNode
extends NetViewTreeNode {
    ESAHost esaHost;

    private void updateUserObject() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.getHostAddressField());
        stringBuilder.append("</html>");
        this.setUserObject(stringBuilder.toString());
    }

    protected String getHostAddressField() {
        StringBuilder stringBuilder = new StringBuilder();
        ESARoute[] eSARouteArray = this.esaHost.getRoutes();
        for (int i = 0; i < eSARouteArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(eSARouteArray[i].getRemoteAddress().getHostAddress());
            if (eSARouteArray[i].isReachable()) continue;
            stringBuilder.append(" (unreachable)");
        }
        return stringBuilder.toString();
    }

    protected void updateDisplay() {
        this.updateUserObject();
    }

    protected void hostChanged() {
        this.updateUserObject();
    }

    public NetViewDeviceNode(ESAHost eSAHost) {
        this.esaHost = eSAHost;
        this.updateUserObject();
    }

    public ESAHost getHost() {
        return this.esaHost;
    }
}

