/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa.chunks;

import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.chunks.ESAChunk;
import java.nio.ByteBuffer;

public class ESAIdentRspChunk
extends ESAChunk {
    private byte[] unitID;
    private int firmwareMode;
    private int protocolVersion;
    private int adminDialogID;
    private int adminParam;
    private int layoutDialogID;
    private int layoutParam;

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws ESAException {
        super.readBytes(byteBuffer);
        int n = byteBuffer.get() & 0xFF;
        if (n != 12) {
            throw new ESAException(-1, "Ident response header size " + n);
        }
        this.firmwareMode = byteBuffer.get() & 0xFF;
        this.protocolVersion = byteBuffer.getShort() & 0xFFFF;
        this.adminDialogID = byteBuffer.getShort() & 0xFFFF;
        this.adminParam = byteBuffer.getShort() & 0xFFFF;
        this.layoutDialogID = byteBuffer.getShort() & 0xFFFF;
        this.layoutParam = byteBuffer.getShort() & 0xFFFF;
        if (byteBuffer.remaining() == 0) {
            return;
        }
        int n2 = byteBuffer.get() & 0xFF;
        if (byteBuffer.remaining() != n2) {
            throw new ESAException(-1, "Ident response unitID size");
        }
        this.unitID = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.unitID[i] = byteBuffer.get();
        }
    }

    public ESAIdentRspChunk(ByteBuffer byteBuffer) throws ESAException {
        super(256, byteBuffer);
    }

    public int getFirmwareMode() {
        return this.firmwareMode;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getAdminDialogID() {
        return this.adminDialogID;
    }

    public int getAdminParam() {
        return this.adminParam;
    }

    public int getLayoutDialogID() {
        return this.layoutDialogID;
    }

    public int getLayoutParam() {
        return this.layoutParam;
    }

    public byte[] getUnitID() {
        return this.unitID;
    }
}

