/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa.chunks;

import dexlogic.io.esa.ESAConstants;
import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESATools;
import java.nio.ByteBuffer;

public class ESAChunk
implements ESAConstants {
    protected int msgID;

    protected void writeBytes(ByteBuffer byteBuffer) throws ESAException {
        byteBuffer.putShort((short)this.msgID);
        byteBuffer.putShort((short)0);
    }

    protected void readBytes(ByteBuffer byteBuffer) throws ESAException {
        int n = byteBuffer.getShort(0) & 0xFFFF;
        if (this.msgID != n) {
            throw new ESAException(-1, "Message ID mismatch");
        }
        byteBuffer.position(4);
    }

    public ESAChunk(int n) {
        this.msgID = n;
    }

    public ESAChunk(int n, ByteBuffer byteBuffer) throws ESAException {
        this.msgID = n;
        this.readBytes(byteBuffer);
    }

    public int getMsgID() {
        return this.msgID;
    }

    public String getHexMsgID() {
        return ESATools.toShortHexString(this.msgID);
    }

    public void writeTo(ByteBuffer byteBuffer) throws ESAException {
        byteBuffer.clear();
        this.writeBytes(byteBuffer);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.putShort(2, (short)byteBuffer.position());
    }

    public String getDecodedID() {
        if (this.msgID == 16) {
            return "Error response";
        }
        if (this.msgID == 32) {
            return "Ping response";
        }
        if (this.msgID == 33) {
            return "Ping request";
        }
        return "0x" + ESATools.toShortHexString(this.msgID);
    }
}

