/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESAIdent;
import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.ESATracker;
import dexlogic.io.esa.ESAUnitID;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

public class ESANetwork {
    private Hashtable<ESAUnitID, ESAHost> hosts = new Hashtable();

    private ESAHost[] sieve(ESAIdent[] eSAIdentArray) {
        Object object;
        Object object2;
        ESAHost[] eSAHostArray;
        Hashtable<ESARoute, ESAHost> hashtable = new Hashtable<ESARoute, ESAHost>();
        Object object3 = this.hosts.elements();
        while (object3.hasMoreElements()) {
            ESAHost eSAHost = object3.nextElement();
            for (int i = 0; i < eSAHost.routes.length; ++i) {
                if (hashtable.get(eSAHost.routes[i]) != null) {
                    throw new Error("[ESANetwork] Duplicate route");
                }
                hashtable.put(eSAHost.routes[i], eSAHost);
            }
        }
        object3 = new Hashtable();
        for (int i = 0; i < eSAIdentArray.length; ++i) {
            ESAIdent eSAIdent = eSAIdentArray[i];
            eSAHostArray = eSAIdent.unitID;
            object2 = eSAIdent.localAddress;
            object = eSAIdent.remoteAddress;
            boolean bl = eSAIdent.reachable;
            ESAHost eSAHost = this.hosts.get(eSAHostArray);
            if (eSAHost == null) {
                eSAHost = new ESAHost((ESAUnitID)eSAHostArray);
                eSAHost.adminDialogID = eSAIdent.adminDialogID;
                eSAHost.adminParam = eSAIdent.adminParam;
                eSAHost.layoutDialogID = eSAIdent.layoutDialogID;
                eSAHost.layoutParam = eSAIdent.layoutParam;
                this.hosts.put(eSAHost.unitID, eSAHost);
            }
            boolean bl2 = true;
            for (int j = 0; j < eSAHost.routes.length; ++j) {
                if (!eSAHost.routes[j].remoteAddress.equals(object)) continue;
                ESAHost eSAHost2 = (ESAHost)hashtable.get(eSAHost.routes[j]);
                if (eSAHost2 == null) {
                    bl2 = false;
                    continue;
                }
                if (!eSAHost.unitID.equals(eSAHost2.unitID)) {
                    throw new Error("[ESANetwork] Routes: Mismatch");
                }
                hashtable.remove(eSAHost.routes[j]);
                bl2 = false;
                if (eSAHost.routes[j].reachable != bl) {
                    ((Hashtable)object3).put(eSAHost.unitID, eSAHost);
                }
                eSAHost.routes[j].reachable = bl;
            }
            if (!bl2) continue;
            eSAHost.addRoute((InetAddress)object, (InetAddress)object2, bl);
            ((Hashtable)object3).put(eSAHost.unitID, eSAHost);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ESARoute eSARoute = (ESARoute)enumeration.nextElement();
            eSAHostArray = (ESAHost)hashtable.get(eSARoute);
            object2 = ESATracker.retrieveIdent(eSARoute.remoteAddress);
            Object object4 = object = object2 == null ? null : ((ESAIdent)object2).unitID;
            if (object != null && eSAHostArray.unitID.equals(object)) continue;
            eSAHostArray.removeRoute(eSARoute);
            ((Hashtable)object3).put(eSAHostArray.unitID, eSAHostArray);
        }
        int n = 0;
        int n2 = ((Hashtable)object3).size();
        if (n2 == 0) {
            return null;
        }
        eSAHostArray = new ESAHost[n2];
        object2 = ((Hashtable)object3).elements();
        while (object2.hasMoreElements()) {
            eSAHostArray[n++] = (ESAHost)object2.nextElement();
        }
        return eSAHostArray;
    }

    public void addHost(ESAHost eSAHost) {
        this.hosts.put(eSAHost.unitID, eSAHost);
    }

    public ESAHost[] removeHosts(ESAHost[] eSAHostArray) {
        int n;
        if (eSAHostArray != null) {
            for (n = 0; n < eSAHostArray.length; ++n) {
                this.hosts.remove(eSAHostArray[n].unitID);
            }
        }
        n = this.hosts.size();
        int n2 = 0;
        if (n == 0) {
            return null;
        }
        ESAHost[] eSAHostArray2 = new ESAHost[n];
        Enumeration<ESAHost> enumeration = this.hosts.elements();
        while (enumeration.hasMoreElements()) {
            eSAHostArray2[n2++] = enumeration.nextElement();
        }
        return eSAHostArray2;
    }

    public ESAHost[] scanNetwork() {
        ESAIdent[] eSAIdentArray = ESATracker.enumHosts();
        if (eSAIdentArray == null) {
            eSAIdentArray = new ESAIdent[]{};
        }
        return this.sieve(eSAIdentArray);
    }

    public ESAHost[] scanAddress(String string) {
        ESAIdent[] eSAIdentArray = ESATracker.enumHosts(string);
        if (eSAIdentArray == null) {
            eSAIdentArray = new ESAIdent[]{};
        }
        return this.sieve(eSAIdentArray);
    }
}

