/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.esa;

import dexlogic.io.esa.ESAConstants;
import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESAFactory;
import dexlogic.io.esa.ESALoadListener;
import dexlogic.io.esa.ESATools;
import dexlogic.io.esa.chunks.ESAChunk;
import dexlogic.io.esa.chunks.ESAIconRspChunk;
import dexlogic.io.esa.chunks.ESAIdentRspChunk;
import dexlogic.io.esa.chunks.ESALabelRspChunk;
import dexlogic.io.esa.chunks.ESANameRspChunk;
import dexlogic.io.esa.chunks.ESAPingReqChunk;
import dexlogic.io.esa.chunks.ESAPingRspChunk;
import dexlogic.io.esa.chunks.ESAPropertiesRspChunk;
import dexlogic.io.esa.chunks.IPLAddressChunk;
import dexlogic.io.esa.chunks.IPLDumpReqChunk;
import dexlogic.io.esa.chunks.IPLDumpRspChunk;
import dexlogic.io.esa.chunks.IPLRebootReqChunk;
import dexlogic.io.esa.chunks.IPLVerifyDataReqChunk;
import dexlogic.io.esa.chunks.IPLVerifyFileReqChunk;
import dexlogic.io.esa.chunks.IPLWriteBlockReqChunk;
import dexlogic.io.esa.chunks.IPLWriteSetupReqChunk;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;

public class ESAConnection
implements ESAConstants {
    private ByteBuffer datagramBuffer = ByteBuffer.allocate(1500);
    private DatagramChannel datagramChannel;
    private Selector nioSelector;
    private SelectionKey nioSelectionKey;

    private ESAChunk exchange(ESAChunk eSAChunk, int n) throws IOException, ESAException {
        SelectableChannel selectableChannel;
        SelectionKey selectionKey;
        Iterator<SelectionKey> iterator;
        if (this.nioSelector.selectNow() != 0) {
            iterator = this.nioSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                selectionKey = iterator.next();
                iterator.remove();
                selectableChannel = selectionKey.channel();
                if (selectableChannel != this.datagramChannel) continue;
                this.datagramBuffer.clear();
                this.datagramChannel.receive(this.datagramBuffer);
            }
        }
        ESAFactory.writeDatagram(this.datagramBuffer, eSAChunk);
        this.datagramBuffer.rewind();
        this.datagramChannel.write(this.datagramBuffer);
        if (this.nioSelector.select(n) != 0) {
            iterator = this.nioSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                selectionKey = iterator.next();
                iterator.remove();
                selectableChannel = selectionKey.channel();
                if (selectableChannel != this.datagramChannel) continue;
                this.datagramBuffer.clear();
                this.datagramChannel.receive(this.datagramBuffer);
                this.datagramBuffer.flip();
                return ESAFactory.readDatagram(this.datagramBuffer);
            }
        }
        throw new ESAException(-1, "Receive timeout (" + eSAChunk.getDecodedID() + ", timeout=" + n + ")");
    }

    private void dump(int n, int n2, int n3) throws IOException, ESAException {
        IPLDumpReqChunk iPLDumpReqChunk = new IPLDumpReqChunk(n, n2, n3);
        ESAChunk eSAChunk = this.exchange(iPLDumpReqChunk, 1000);
        if (!(eSAChunk instanceof IPLDumpRspChunk)) {
            String string = eSAChunk.getHexMsgID();
            throw new ESAException(-1, "[dump] Unexpected response 0x" + string);
        }
        IPLDumpRspChunk iPLDumpRspChunk = (IPLDumpRspChunk)eSAChunk;
        byte[] byArray = iPLDumpRspChunk.getDumpBytes();
        ESATools.dump(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(byte[] byArray, int n, int n2, ESALoadListener eSALoadListener) throws IOException {
        Object object;
        int n3 = byArray.length;
        int n4 = 0;
        try {
            object = new IPLWriteSetupReqChunk();
            ((IPLAddressChunk)object).setSelector(n);
            ((IPLAddressChunk)object).setStartAddress(n2);
            ESAChunk eSAChunk = this.exchange((ESAChunk)object, 1000);
            if (eSAChunk.getMsgID() != 4608) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[writeImage] Unexpected response 0x" + string);
            }
            IPLWriteBlockReqChunk iPLWriteBlockReqChunk = new IPLWriteBlockReqChunk();
            iPLWriteBlockReqChunk.setSelector(n);
            iPLWriteBlockReqChunk.setStartAddress(n2);
            iPLWriteBlockReqChunk.setImageBytes(byArray);
            iPLWriteBlockReqChunk.setBlockOffset(0);
            iPLWriteBlockReqChunk.setByteCount(0);
            int n5 = n3;
            eSALoadListener.loadCopyStarted(0, n3);
            eSALoadListener.loadCopyProgress(0);
            try {
                while (n5 != 0) {
                    iPLWriteBlockReqChunk.setBlockOffset(iPLWriteBlockReqChunk.getBlockOffset() + iPLWriteBlockReqChunk.getByteCount());
                    iPLWriteBlockReqChunk.setStartAddress(iPLWriteBlockReqChunk.getStartAddress() + iPLWriteBlockReqChunk.getByteCount());
                    iPLWriteBlockReqChunk.setByteCount(n5 > 1024 ? 1024 : n5);
                    if ((n5 -= iPLWriteBlockReqChunk.getByteCount()) == 0) {
                        iPLWriteBlockReqChunk.setLastBlockFlag(true);
                    }
                    if ((eSAChunk = this.exchange(iPLWriteBlockReqChunk, 1000)).getMsgID() != 4624) {
                        String string = eSAChunk.getHexMsgID();
                        throw new ESAException(-1, "[writeImage] Unexpected response 0x" + string);
                    }
                    eSALoadListener.loadCopyProgress(n3 - n5);
                    ++n4;
                }
            }
            finally {
                eSALoadListener.loadCopyEnded();
            }
        }
        catch (ESAException eSAException) {
            throw new IOException(eSAException.getMessage());
        }
        object = "" + n3 + "(0x" + ESATools.toIntHexString(n3) + ") bytes";
        eSALoadListener.loadLog("Load finished, footprint " + (String)object + ", " + n4 + " packets.");
    }

    public boolean isOpen() {
        return this.datagramChannel != null && this.datagramChannel.isOpen();
    }

    public void open(InetAddress inetAddress, InetAddress inetAddress2) throws IOException {
        this.datagramChannel = DatagramChannel.open();
        if (inetAddress2 != null) {
            this.datagramChannel.bind(new InetSocketAddress(inetAddress2, 0));
        }
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.connect(new InetSocketAddress(inetAddress, 62018));
        this.nioSelector = Selector.open();
        this.nioSelectionKey = this.datagramChannel.register(this.nioSelector, 1);
    }

    public void open(InetAddress inetAddress) throws IOException {
        this.open(inetAddress, null);
    }

    public void close() throws IOException {
        try {
            if (this.nioSelector != null && this.nioSelector.isOpen()) {
                this.nioSelector.close();
            }
        }
        finally {
            this.nioSelector = null;
            try {
                if (this.datagramChannel != null && this.datagramChannel.isOpen()) {
                    this.datagramChannel.close();
                }
            }
            finally {
                this.datagramChannel = null;
            }
        }
    }

    public IPLDumpRspChunk retrieveDump(int n, int n2, int n3) throws IOException {
        try {
            IPLDumpReqChunk iPLDumpReqChunk = new IPLDumpReqChunk(n, n2, n3);
            ESAChunk eSAChunk = this.exchange(iPLDumpReqChunk, 1000);
            if (!(eSAChunk instanceof IPLDumpRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveDump] Unexpected response 0x" + string);
            }
            return (IPLDumpRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveDump] Exchange error " + eSAException.getMessage());
        }
    }

    public ESAIdentRspChunk retrieveIdent() throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAChunk(257), 1000);
            if (!(eSAChunk instanceof ESAIdentRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveIdent] Unexpected response 0x" + string);
            }
            return (ESAIdentRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveIdent] Exchange error " + eSAException.getMessage());
        }
    }

    public ESAPropertiesRspChunk retrieveProperties() throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAChunk(273), 1000);
            if (!(eSAChunk instanceof ESAPropertiesRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveProperties] Unexpected response 0x" + string);
            }
            return (ESAPropertiesRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveProperties] Exchange error " + eSAException.getMessage());
        }
    }

    public ESALabelRspChunk retrieveLabel() throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAChunk(289), 1000);
            if (!(eSAChunk instanceof ESALabelRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveLabel] Unexpected response 0x" + string);
            }
            return (ESALabelRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveLabel] Exchange error " + eSAException.getMessage());
        }
    }

    public ESANameRspChunk retrieveName() throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAChunk(293), 1000);
            if (!(eSAChunk instanceof ESANameRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveName] Unexpected response 0x" + string);
            }
            return (ESANameRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveName] Exchange error " + eSAException.getMessage());
        }
    }

    public ESAIconRspChunk retrieveIcon() throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAChunk(297), 1000);
            if (!(eSAChunk instanceof ESAIconRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[retrieveIcon] Unexpected response 0x" + string);
            }
            return (ESAIconRspChunk)eSAChunk;
        }
        catch (ESAException eSAException) {
            throw new IOException("[retrieveIcon] Exchange error " + eSAException.getMessage());
        }
    }

    public boolean execPing(int n) throws IOException {
        try {
            ESAChunk eSAChunk = this.exchange(new ESAPingReqChunk(), n);
            if (!(eSAChunk instanceof ESAPingRspChunk)) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[ping] Unexpected response 0x" + string);
            }
            return true;
        }
        catch (ESAException eSAException) {
            return false;
        }
    }

    public void execReboot(int n, int n2, ESALoadListener eSALoadListener) throws IOException {
        String string = null;
        if (n != 0) {
            throw new IOException("[rebootTarget] Invalid area " + n);
        }
        string = "default";
        String string2 = null;
        if (n2 == 0) {
            string2 = "regular boot";
        } else if (n2 == 1) {
            string2 = "update mode";
        } else {
            throw new IOException("[rebootTarget] Invalid mode " + n2);
        }
        eSALoadListener.loadLog("Reboot from area '" + string + "' (" + string2 + ").");
        try {
            IPLRebootReqChunk iPLRebootReqChunk = new IPLRebootReqChunk(n, n2);
            ESAChunk eSAChunk = this.exchange(iPLRebootReqChunk, 1000);
            if (eSAChunk.getMsgID() != 4096) {
                String string3 = eSAChunk.getHexMsgID();
                throw new IOException("[rebootTarget] Unexpected response 0x" + string3);
            }
        }
        catch (ESAException eSAException) {
            throw new IOException(eSAException.getMessage());
        }
    }

    public void loadFileImage(byte[] byArray, int n, int n2, ESALoadListener eSALoadListener) throws IOException {
        try {
            int n3 = ESATools.readInt(byArray, 4);
            String string = ESATools.readStringField(byArray, 16, 32);
            eSALoadListener.loadLog("Loading file image, " + string + ", " + n3 + " bytes.");
            this.writeImage(byArray, n, n2, eSALoadListener);
            eSALoadListener.loadLog("Verifying memory region.");
            IPLVerifyFileReqChunk iPLVerifyFileReqChunk = new IPLVerifyFileReqChunk();
            iPLVerifyFileReqChunk.setSelector(n);
            iPLVerifyFileReqChunk.setStartAddress(n2);
            ESAChunk eSAChunk = this.exchange(iPLVerifyFileReqChunk, 1000 + byArray.length / 20);
            if (eSAChunk.getMsgID() != 4648) {
                String string2 = eSAChunk.getHexMsgID();
                throw new IOException("[verifyFile] Unexpected response 0x" + string2);
            }
        }
        catch (ESAException eSAException) {
            throw new IOException(eSAException.getMessage());
        }
        String string = "" + n + ":" + ESATools.toIntHexString(n2);
        eSALoadListener.loadLog("File image copy to " + string + " successful.");
    }

    public void loadDataImage(byte[] byArray, int n, int n2, ESALoadListener eSALoadListener) throws IOException {
        try {
            int n3 = byArray.length;
            eSALoadListener.loadLog("Loading data image, " + n3 + " bytes.");
            this.writeImage(byArray, n, n2, eSALoadListener);
            eSALoadListener.loadLog("Verifying memory region.");
            IPLVerifyDataReqChunk iPLVerifyDataReqChunk = new IPLVerifyDataReqChunk();
            iPLVerifyDataReqChunk.setSelector(n);
            iPLVerifyDataReqChunk.setStartAddress(n2);
            iPLVerifyDataReqChunk.setImageLength(n3);
            iPLVerifyDataReqChunk.setImageCRC(ESATools.crc32(byArray, 0, n3));
            ESAChunk eSAChunk = this.exchange(iPLVerifyDataReqChunk, 1000 + byArray.length / 20);
            if (eSAChunk.getMsgID() != 4640) {
                String string = eSAChunk.getHexMsgID();
                throw new IOException("[verifyData] Unexpected response 0x" + string);
            }
        }
        catch (ESAException eSAException) {
            throw new IOException(eSAException.getMessage());
        }
        String string = "" + n + ":" + ESATools.toIntHexString(n2);
        eSALoadListener.loadLog("Data image copy to " + string + " successful.");
    }
}

