/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.devlog;

import dexlogic.devlog.DeviceLogFileFilter;
import dexlogic.devlog.WLogArea;
import dexlogic.io.esa.ESAConcurrentLink;
import dexlogic.io.esa.ESAException;
import dexlogic.io.esa.ESAHost;
import dexlogic.io.esa.ESARoute;
import dexlogic.io.esa.chunks.ESAChunk;
import dexlogic.io.esa.chunks.ESANameRspChunk;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class WDeviceLogFrame
extends JFrame
implements Runnable {
    private final int LINKSTATE_DOWN = 0;
    private final int LINKSTATE_UNKNOWN = 1;
    private final int LINKSTATE_UP = 2;
    private ESAHost esaHost;
    private ESAConcurrentLink esaLink;
    private int logLinkState = 0;
    private boolean verboseMode = false;
    private Thread cmdThread;
    private Thread recvThread;
    private boolean cmdThreadStopRequest = false;
    private boolean recvThreadStopRequest = false;
    private LinkedList<Object> logList = new LinkedList();
    private int logSessionID = -1;
    private int logSequenceNum = -1;
    private boolean logLineValid = false;
    private int logLineNum = -1;
    private String logLineText = null;
    private JScrollPane scrollPaneWin;
    private WLogArea logAreaWin;
    private JPanel linkStatusWin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postLog(Object object) {
        LinkedList<Object> linkedList = this.logList;
        synchronized (linkedList) {
            this.logList.add(object);
        }
        SwingUtilities.invokeLater(this);
    }

    private void updateStatusWin() {
        Color color = Color.GRAY;
        if (this.logLinkState == 0) {
            color = Color.RED;
        } else if (this.logLinkState == 1) {
            color = Color.YELLOW;
        } else if (this.logLinkState == 2) {
            color = Color.GREEN;
        }
        this.linkStatusWin.setBackground(color);
    }

    private void abortSession() {
        this.logSessionID = -1;
        this.logSequenceNum = -1;
        this.logLineValid = false;
        this.cmdThread.interrupt();
    }

    private void readLogChunk(ArrayList<WLogArea.LogLine> arrayList, ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort() & 0xFFFF;
        int n2 = byteBuffer.getShort() & 0xFFFF;
        if (n != this.logSessionID) {
            return;
        }
        if (this.logSequenceNum < 0) {
            this.logLineValid = false;
            if (this.verboseMode) {
                String string = "[Viewer] Start, sessionID=" + this.logSessionID;
                WLogArea wLogArea = this.logAreaWin;
                wLogArea.getClass();
                arrayList.add(new WLogArea.LogLine(wLogArea, 0, string));
            }
        } else if (n2 != (this.logSequenceNum + 1 & 0xFFFF)) {
            int n3 = this.logSequenceNum + 1 & 0xFFFF;
            String string = "[Viewer] Read: Sequence error, expected " + n3 + ", got " + n2;
            WLogArea wLogArea = this.logAreaWin;
            wLogArea.getClass();
            arrayList.add(new WLogArea.LogLine(wLogArea, 0, string));
            this.abortSession();
            return;
        }
        this.logSequenceNum = n2;
        while (byteBuffer.hasRemaining()) {
            int n4 = byteBuffer.getShort() & 0xFFFF;
            int n5 = byteBuffer.get() & 0xFF;
            int n6 = byteBuffer.get() & 0xFF;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n6; ++i) {
                stringBuilder.append((char)byteBuffer.get());
            }
            String string = stringBuilder.toString();
            if (!this.logLineValid) {
                this.logLineValid = true;
                if (this.logLineNum >= 0) {
                    CharSequence charSequence;
                    if (n4 == this.logLineNum && string.equals(this.logLineText)) {
                        charSequence = "[Viewer] Read: Resume (successful position recovery)";
                        WLogArea wLogArea = this.logAreaWin;
                        wLogArea.getClass();
                        arrayList.add(new WLogArea.LogLine(wLogArea, 0, (String)charSequence));
                        continue;
                    }
                    charSequence = new StringBuilder();
                    for (int i = 80; i > 0; --i) {
                        ((StringBuilder)charSequence).append("-");
                    }
                    WLogArea wLogArea = this.logAreaWin;
                    wLogArea.getClass();
                    arrayList.add(new WLogArea.LogLine(wLogArea, 0, ((StringBuilder)charSequence).toString()));
                }
            } else if (n4 != (this.logLineNum + 1 & 0xFFFF)) {
                int n7 = this.logLineNum + 1 & 0xFFFF;
                String string2 = "[Viewer] Read: Line error, expected " + n7 + ", got " + n4;
                WLogArea wLogArea = this.logAreaWin;
                wLogArea.getClass();
                arrayList.add(new WLogArea.LogLine(wLogArea, 0, string2));
                this.abortSession();
                return;
            }
            this.logLineNum = n4;
            this.logLineText = string;
            WLogArea wLogArea = this.logAreaWin;
            wLogArea.getClass();
            arrayList.add(new WLogArea.LogLine(wLogArea, n5, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLog() {
        ArrayList<WLogArea.LogLine> arrayList = new ArrayList<WLogArea.LogLine>();
        while (!this.logList.isEmpty()) {
            Object object = null;
            Object object2 = this.logList;
            synchronized (object2) {
                object = this.logList.removeFirst();
            }
            if (object instanceof String) {
                WLogArea wLogArea = this.logAreaWin;
                wLogArea.getClass();
                arrayList.add(new WLogArea.LogLine(wLogArea, 0, (String)object));
                continue;
            }
            if (object instanceof LinkMessage) {
                object2 = (LinkMessage)object;
                this.logLinkState = ((LinkMessage)object2).linkStatus;
                this.updateStatusWin();
                continue;
            }
            if (object instanceof SyncMessage) {
                object2 = (SyncMessage)object;
                this.logSessionID = ((SyncMessage)object2).sessionID;
                this.logSequenceNum = -1;
                continue;
            }
            if (!(object instanceof LogChunk)) continue;
            object2 = (LogChunk)object;
            this.readLogChunk(arrayList, ((LogChunk)object2).byteBuffer);
        }
        this.logAreaWin.appendLines(arrayList);
    }

    private void loadLog(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.logAreaWin.load(fileInputStream);
        fileInputStream.close();
    }

    private void saveLog(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.logAreaWin.dump(fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            WDeviceLogFrame.showIOError(this, iOException);
        }
    }

    private JComponent buildDisplayUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.logAreaWin = new WLogArea();
        this.logAreaWin.setFont(new Font("Monospaced", 0, 12));
        this.logAreaWin.setBackground(Color.white);
        this.logAreaWin.setForeground(new Color(50, 50, 50));
        this.logAreaWin.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.logLinkState = 0;
        this.linkStatusWin = new JPanel();
        this.updateStatusWin();
        this.scrollPaneWin = new JScrollPane(this.logAreaWin);
        this.scrollPaneWin.setVerticalScrollBarPolicy(22);
        this.scrollPaneWin.setCorner("UPPER_RIGHT_CORNER", this.linkStatusWin);
        if (this.esaHost != null) {
            this.scrollPaneWin.setLayout(new ScrollPaneLayout(){

                @Override
                public void layoutContainer(Container container) {
                    super.layoutContainer(container);
                    if (this.upperRight != null) {
                        Rectangle rectangle = this.vsb.getBounds();
                        this.upperRight.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.width);
                        rectangle.height -= rectangle.width;
                        rectangle.y += rectangle.width;
                        this.vsb.setBounds(rectangle);
                    }
                }
            });
        }
        this.scrollPaneWin.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Save..."));
                    jMenuItem.addActionListener(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JFileChooser jFileChooser = new JFileChooser(".");
                            jFileChooser.setAcceptAllFileFilterUsed(false);
                            jFileChooser.addChoosableFileFilter(new DeviceLogFileFilter());
                            int n = jFileChooser.showSaveDialog(WDeviceLogFrame.this.scrollPaneWin);
                            if (n == 0) {
                                File file = jFileChooser.getSelectedFile();
                                if (!file.getAbsolutePath().endsWith(".log")) {
                                    file = new File(file + ".log");
                                }
                                WDeviceLogFrame.this.saveLog(file);
                            }
                        }
                    });
                    jPopupMenu.show(WDeviceLogFrame.this.scrollPaneWin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.scrollPaneWin, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 2, 2, 2));
        jPanel.add((Component)this.buildDisplayUI(), "Center");
        return jPanel;
    }

    public WDeviceLogFrame(ESAHost eSAHost, boolean bl) throws IOException {
        Object object;
        this.esaHost = eSAHost;
        this.verboseMode = bl;
        this.esaLink = new ESAConcurrentLink();
        ESARoute eSARoute = eSAHost.getDefaultRoute();
        InetAddress inetAddress = eSARoute.getRemoteAddress();
        this.esaLink.open(inetAddress);
        this.recvThread = new ReceiveThread();
        this.recvThread.start();
        String string = null;
        try {
            object = new ESAChunk(293);
            ESAChunk eSAChunk = this.esaLink.exchange((ESAChunk)object, 1000);
            if (eSAChunk instanceof ESANameRspChunk) {
                ESANameRspChunk eSANameRspChunk = (ESANameRspChunk)eSAChunk;
                string = eSANameRspChunk.getName();
                if (string != null) {
                    string = string.trim();
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
            }
        }
        catch (ESAException eSAException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new StringBuilder();
        if (string != null) {
            ((StringBuilder)object).append(string).append(" - ");
        }
        ((StringBuilder)object).append(inetAddress.getHostAddress()).append(" - ");
        ((StringBuilder)object).append("Device Log");
        this.setTitle(((StringBuilder)object).toString());
        this.cmdThread = new CommandThread();
        this.cmdThread.start();
        this.enableEvents(8L);
        this.setContentPane(this.buildUI());
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Thread thread = WDeviceLogFrame.this.cmdThread;
                synchronized (thread) {
                    WDeviceLogFrame.this.cmdThreadStopRequest = true;
                }
                WDeviceLogFrame.this.cmdThread.interrupt();
                try {
                    WDeviceLogFrame.this.cmdThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                thread = WDeviceLogFrame.this.recvThread;
                synchronized (thread) {
                    WDeviceLogFrame.this.recvThreadStopRequest = true;
                }
                WDeviceLogFrame.this.recvThread.interrupt();
                try {
                    WDeviceLogFrame.this.recvThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                try {
                    WDeviceLogFrame.this.esaLink.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public WDeviceLogFrame(File file) throws IOException {
        super(file.getName() + " - Device Log");
        this.enableEvents(8L);
        this.setContentPane(this.buildUI());
        this.loadLog(file);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            JScrollBar jScrollBar = this.scrollPaneWin.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
        super.processKeyEvent(keyEvent);
    }

    @Override
    public void run() {
        this.flushLog();
    }

    public static void showIOError(Component component, String string, IOException iOException) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        String string2 = "I/O error";
        string = string == null ? iOException.getMessage() : string + "\n" + iOException.getMessage();
        JOptionPane.showMessageDialog(window, string, string2, 0);
    }

    public static void showIOError(Component component, IOException iOException) {
        WDeviceLogFrame.showIOError(component, null, iOException);
    }

    private class ReceiveThread
    extends Thread {
        private ReceiveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean bl;
                Object object = WDeviceLogFrame.this.recvThread;
                synchronized (object) {
                    bl = WDeviceLogFrame.this.recvThreadStopRequest;
                }
                if (bl) break;
                try {
                    object = ByteBuffer.allocate(1500);
                    int n = WDeviceLogFrame.this.esaLink.receive((ByteBuffer)object);
                    if (n != 8192) continue;
                    WDeviceLogFrame.this.postLog(new LogChunk(n, (ByteBuffer)object));
                }
                catch (ESAException eSAException) {
                    WDeviceLogFrame.this.postLog("[RX/ESA] " + eSAException.getMessage());
                }
                catch (IOException iOException) {
                    WDeviceLogFrame.this.postLog("[RX/IO] " + iOException.getMessage());
                }
            }
        }
    }

    private class CommandThread
    extends Thread {
        int sessionID;

        private CommandThread() {
        }

        private void sendCommand(int n) throws IOException, ESAException {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (n == 1 || n == 2) {
                ++this.sessionID;
                n3 = this.sessionID;
                WDeviceLogFrame.this.postLog(new SyncMessage(this.sessionID));
                int n5 = WDeviceLogFrame.this.logLineNum;
                if (n5 < 0) {
                    n2 = 2;
                } else {
                    n4 = n5;
                }
            }
            if (WDeviceLogFrame.this.verboseMode) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[CMD] Send cmd=").append(n);
                if (n == 1) {
                    stringBuilder.append("(start)");
                } else if (n == 2) {
                    stringBuilder.append("(position)");
                } else if (n == 8) {
                    stringBuilder.append("(keepAlive)");
                } else if (n == 9) {
                    stringBuilder.append("(stop)");
                }
                if (n == 1 || n == 2) {
                    stringBuilder.append(", sessionID=").append(n3);
                    if (n2 == 0) {
                        stringBuilder.append(", lineNum=").append(n4);
                    } else if (n2 == 1) {
                        stringBuilder.append(", jumpin");
                    } else if (n2 == 2) {
                        stringBuilder.append(", history");
                    } else {
                        stringBuilder.append(", opt=").append(n2);
                    }
                }
                WDeviceLogFrame.this.postLog(stringBuilder.toString());
            }
            ESAChunk eSAChunk = new ESAChunk(1025){
                private int cmd;
                private int opt;
                private int param1;
                private int param2;

                @Override
                protected void writeBytes(ByteBuffer byteBuffer) throws ESAException {
                    super.writeBytes(byteBuffer);
                    byteBuffer.put((byte)this.cmd);
                    byteBuffer.put((byte)this.opt);
                    byteBuffer.putShort((short)0);
                    byteBuffer.putShort((short)this.param1);
                    byteBuffer.putShort((short)this.param2);
                }

                public ESAChunk init(int n, int n2, int n3, int n4) {
                    this.cmd = n;
                    this.opt = n2;
                    this.param1 = n3;
                    this.param2 = n4;
                    return this;
                }
            }.init(n, n2, n3, n4);
            ESAChunk eSAChunk2 = WDeviceLogFrame.this.esaLink.exchange(eSAChunk, 1000);
            if (eSAChunk2.getMsgID() != 1024) {
                String string = eSAChunk2.getHexMsgID();
                throw new ESAException(-1, "Unexpected response 0x" + string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.sessionID = (int)System.currentTimeMillis() & 0xFF;
            int n = 0;
            while (true) {
                block21: {
                    boolean bl;
                    Thread thread = WDeviceLogFrame.this.cmdThread;
                    synchronized (thread) {
                        bl = WDeviceLogFrame.this.cmdThreadStopRequest;
                    }
                    if (bl) break;
                    int n2 = 8;
                    if (n == 0) {
                        n2 = 1;
                    } else if (WDeviceLogFrame.this.logSessionID < 0) {
                        n2 = 2;
                    }
                    try {
                        this.sendCommand(n2);
                        if (n != 2) {
                            n = 2;
                            WDeviceLogFrame.this.postLog(new LinkMessage(2));
                        }
                    }
                    catch (ESAException eSAException) {
                        if (WDeviceLogFrame.this.logSessionID >= 0 && WDeviceLogFrame.this.logSequenceNum >= 0 || WDeviceLogFrame.this.verboseMode) {
                            WDeviceLogFrame.this.postLog("[CMD/ESA] " + eSAException.getMessage());
                        }
                        WDeviceLogFrame.this.postLog(new SyncMessage(-1));
                        if (n != 0) {
                            n = 0;
                            WDeviceLogFrame.this.postLog(new LinkMessage(0));
                        }
                    }
                    catch (IOException iOException) {
                        if (WDeviceLogFrame.this.logSessionID >= 0 && WDeviceLogFrame.this.logSequenceNum >= 0 || WDeviceLogFrame.this.verboseMode) {
                            WDeviceLogFrame.this.postLog("[CMD/IO] " + iOException.getMessage());
                        }
                        WDeviceLogFrame.this.postLog(new SyncMessage(-1));
                        if (n != 2) break block21;
                        n = 1;
                        WDeviceLogFrame.this.postLog(new LinkMessage(1));
                    }
                }
                try {
                    Thread.sleep(n == 2 ? 5000L : 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (n == 2) {
                try {
                    this.sendCommand(9);
                }
                catch (IOException iOException) {
                }
                catch (ESAException eSAException) {
                    // empty catch block
                }
            }
            if (n != 0) {
                n = 0;
                WDeviceLogFrame.this.postLog(new LinkMessage(0));
            }
        }
    }

    private class LogChunk {
        public int msgID;
        public ByteBuffer byteBuffer;

        public LogChunk(int n, ByteBuffer byteBuffer) {
            this.msgID = n;
            this.byteBuffer = byteBuffer;
        }
    }

    private class SyncMessage {
        public int sessionID;

        public SyncMessage(int n) {
            this.sessionID = n;
        }
    }

    private class LinkMessage {
        public int linkStatus;

        public LinkMessage(int n) {
            this.linkStatus = n;
        }
    }
}

