/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class JNILoader {
    private static final String TEMP_FOLDER_PREFIX = "DexLogic-JNILoader-";
    private static final String TEMP_LOCK_NAME = "templock";
    static File loaderDir;
    private static String jniResourcePath;

    private static Processor getProcessor() {
        Processor processor = Processor.UNKNOWN;
        String string = System.getProperty("os.arch").toLowerCase();
        if (string.contains("arm")) {
            processor = Processor.ARM;
        } else if (string.contains("aarch64")) {
            processor = Processor.AARCH_64;
        } else if (string.contains("ppc")) {
            processor = string.contains("64") ? Processor.PPC_64 : Processor.PPC;
        } else if (string.contains("86") || string.contains("amd")) {
            processor = string.contains("64") ? Processor.INTEL_64 : Processor.INTEL_32;
        }
        return processor;
    }

    private static Architecture getArchitecture() {
        Architecture architecture = Architecture.UNKNOWN;
        String string = System.getProperty("os.name").toLowerCase();
        Processor processor = JNILoader.getProcessor();
        if (processor != Processor.UNKNOWN) {
            if (string.contains("nix") || string.contains("nux")) {
                if (processor == Processor.INTEL_32) {
                    architecture = Architecture.LINUX_32;
                } else if (processor == Processor.INTEL_64) {
                    architecture = Architecture.LINUX_64;
                } else if (processor == Processor.ARM) {
                    architecture = Architecture.LINUX_ARM;
                } else if (processor == Processor.AARCH_64) {
                    architecture = Architecture.LINUX_ARM64;
                }
            } else if (string.contains("aix")) {
                if (processor == Processor.PPC) {
                    architecture = Architecture.AIX_32;
                } else if (processor == Processor.PPC_64) {
                    architecture = Architecture.AIX_64;
                }
            } else if (string.contains("win")) {
                if (processor == Processor.INTEL_32) {
                    architecture = Architecture.WINDOWS_32;
                } else if (processor == Processor.INTEL_64) {
                    architecture = Architecture.WINDOWS_64;
                }
            } else if (string.contains("mac")) {
                if (processor == Processor.INTEL_32) {
                    architecture = Architecture.OSX_32;
                } else if (processor == Processor.INTEL_64) {
                    architecture = Architecture.OSX_64;
                } else if (processor == Processor.PPC) {
                    architecture = Architecture.OSX_PPC;
                }
            }
        }
        return architecture;
    }

    private static File extractResource(URL uRL, File file, String string) throws IOException {
        int n;
        InputStream inputStream = uRL.openStream();
        File file2 = new File(file, string);
        File file3 = File.createTempFile(string, null, file);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        inputStream.close();
        file3.renameTo(file2);
        file2.deleteOnExit();
        return file2;
    }

    private static void deleteRecursively(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                file2.delete();
                continue;
            }
            if (!file2.isDirectory()) continue;
            JNILoader.deleteRecursively(file2);
        }
        file.delete();
    }

    private static void deleteLeftovers() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(JNILoader.TEMP_FOLDER_PREFIX);
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            File file3 = new File(file2, TEMP_LOCK_NAME);
            if (file3.exists()) continue;
            JNILoader.deleteRecursively(file2);
        }
    }

    public static void loadLibrary(String string) throws IOException {
        String string2 = System.mapLibraryName(string);
        URL uRL = JNILoader.class.getClassLoader().getResource(jniResourcePath + "/" + string2);
        if (uRL == null) {
            throw new IOException("Couldn't find jni library " + string2);
        }
        File file = JNILoader.extractResource(uRL, loaderDir, string2);
        if (file == null) {
            throw new IOException("Couldn't extract jni library " + string2);
        }
        try {
            System.load(file.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new IOException("Couldn't load jni library " + string2, unsatisfiedLinkError);
        }
    }

    static {
        Architecture architecture = JNILoader.getArchitecture();
        if (architecture == Architecture.UNKNOWN) {
            throw new RuntimeException("Unknown architecture");
        }
        jniResourcePath = "natives/" + architecture.name().toLowerCase();
        JNILoader.deleteLeftovers();
        try {
            loaderDir = Files.createTempDirectory(TEMP_FOLDER_PREFIX, new FileAttribute[0]).toFile();
            loaderDir.deleteOnExit();
            File file = new File(loaderDir, TEMP_LOCK_NAME);
            file.deleteOnExit();
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot create temporary directory", iOException);
        }
    }

    private static enum Processor {
        UNKNOWN,
        INTEL_32,
        INTEL_64,
        PPC,
        PPC_64,
        ARM,
        AARCH_64;

    }

    private static enum Architecture {
        UNKNOWN,
        LINUX_32,
        LINUX_64,
        LINUX_ARM,
        LINUX_ARM64,
        WINDOWS_32,
        WINDOWS_64,
        OSX_32,
        OSX_64,
        OSX_PPC,
        AIX_32,
        AIX_64;

    }
}

