/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.xml;

import dexlogic.dxc.DXCException;
import dexlogic.dxc.DXCManager;
import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.xml.WXMLContentPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class WXMLRootPane
extends WParsecRootPane {
    private File filePath;
    private JTextArea textArea;
    private DXCManager streamManager;

    private void createStreamManager() {
        if (this.streamManager != null) {
            throw new RuntimeException("Invalid method call, streamer exists");
        }
        try (DXCManager dXCManager = null;){
            dXCManager = new DXCManager(0x10000FF);
            dXCManager.buildFromXML(this.textArea.getText());
            this.streamManager = dXCManager;
            dXCManager = null;
        }
    }

    private void play() {
        if (this.streamManager == null) {
            this.createStreamManager();
        }
        if (this.streamManager != null) {
            try {
                this.streamManager.play(null);
            }
            catch (DXCException dXCException) {
                System.out.println();
                dXCException.printStackTrace();
            }
        }
    }

    private void pause() {
        if (this.streamManager == null) {
            this.createStreamManager();
        }
        if (this.streamManager != null) {
            try {
                this.streamManager.pause(null);
            }
            catch (DXCException dXCException) {
                System.out.println();
                dXCException.printStackTrace();
            }
        }
    }

    private void stop() {
        if (this.streamManager == null) {
            return;
        }
        try {
            this.streamManager.idle(null);
            this.streamManager.reset();
            this.streamManager.close();
        }
        finally {
            this.streamManager = null;
        }
    }

    private void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.buildFileMenu();
        jMenu.add(this.buildFileNewMenu());
        jMenu.add(this.buildFileOpenItem());
        jMenu.add(this.buildFileCloseItem());
        jMenu.addSeparator();
        jMenu.add(this.buildSinkSetupItem());
        jMenu.add(this.buildServiceParamItem());
        jMenu.addSeparator();
        jMenu.add(this.buildQuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("System");
        jMenu.setMnemonic(84);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Play", 80));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WXMLRootPane.this.play();
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Pause"));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WXMLRootPane.this.pause();
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Stop", 83));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WXMLRootPane.this.stop();
            }
        });
        jMenuBar.add(jMenu);
        jMenuBar.add(this.buildWindowMenu());
        this.setJMenuBar(jMenuBar);
    }

    private void buildUI() {
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    @Override
    protected Container createContentPane() {
        WXMLContentPane wXMLContentPane = new WXMLContentPane(this);
        wXMLContentPane.setName(this.getName() + ".contentPane");
        return wXMLContentPane;
    }

    public WXMLRootPane(File file) throws ParsecException {
        if (file == null) {
            String string = "Parsec (XML-File), invalid constructor invocation";
            throw new InternalParsecException(string);
        }
        if (!file.getName().endsWith(".xml")) {
            String string = "Parsec (XML-File) can't handle extension of " + file.getName();
            InternalParsecException internalParsecException = new InternalParsecException(string);
            internalParsecException.setDetails("Absolute path: \n" + file.getAbsolutePath());
            throw internalParsecException;
        }
        this.filePath = file;
        this.setTitle("Parsec XML - " + file.getName());
        this.buildMenu();
        this.buildUI();
        if (file.exists()) {
            try {
                byte[] byArray = Files.readAllBytes(file.toPath());
                this.textArea.setText(new String(byArray, StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                String string = "File load error: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string);
                genericParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
                throw genericParsecException;
            }
        }
    }

    @Override
    public void dispose() {
        this.stop();
    }
}

