/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.wav;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WAVSource {
    private static int readLE16(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[2];
        randomAccessFile.readFully(byArray);
        int n = byArray[0] & 0xFF;
        return n |= (byArray[1] & 0xFF) << 8;
    }

    private static int readLE32(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray);
        int n = byArray[0] & 0xFF;
        n |= (byArray[1] & 0xFF) << 8;
        n |= (byArray[2] & 0xFF) << 16;
        return n |= (byArray[3] & 0xFF) << 24;
    }

    private static HeaderCookie readHeader(RandomAccessFile randomAccessFile) throws IOException, ParsecException {
        HeaderCookie headerCookie = new HeaderCookie();
        byte[] byArray = new byte[4];
        randomAccessFile.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 73 || byArray[2] != 70 || byArray[3] != 70) {
            throw new GenericParsecException("Not a RIFF file");
        }
        int n = WAVSource.readLE32(randomAccessFile);
        randomAccessFile.readFully(byArray);
        if (byArray[0] != 87 || byArray[1] != 65 || byArray[2] != 86 || byArray[3] != 69) {
            throw new GenericParsecException("Not a WAVE-RIFF file");
        }
        long l = randomAccessFile.length();
        while (randomAccessFile.getFilePointer() < l) {
            long l2;
            randomAccessFile.readFully(byArray);
            n = WAVSource.readLE32(randomAccessFile);
            if (byArray[0] == 102 && byArray[1] == 109 && byArray[2] == 116 && byArray[3] == 32) {
                int n2;
                if (n < 16) {
                    GenericParsecException genericParsecException = new GenericParsecException("Format error");
                    genericParsecException.setHints("Invalid format sub chunk, size=" + n);
                    throw genericParsecException;
                }
                l2 = randomAccessFile.getFilePointer();
                int n3 = WAVSource.readLE16(randomAccessFile);
                if (n3 != 1 && n3 != 65534) {
                    GenericParsecException genericParsecException = new GenericParsecException("Data format error");
                    genericParsecException.setHints(String.format("formatTag=%d", n3));
                    throw genericParsecException;
                }
                int n4 = headerCookie.numChannels = WAVSource.readLE16(randomAccessFile);
                int n5 = WAVSource.readLE32(randomAccessFile);
                int n6 = headerCookie.avgBytesPerSec = WAVSource.readLE32(randomAccessFile);
                int n7 = WAVSource.readLE16(randomAccessFile);
                int n8 = WAVSource.readLE16(randomAccessFile);
                if (n5 != 48000 || n8 != 16) {
                    GenericParsecException genericParsecException = new GenericParsecException("Data format error");
                    genericParsecException.setHints(String.format("samplesPerSec=%d, bitsPerSample=%d", n5, n8));
                    throw genericParsecException;
                }
                if (n7 != n4 * (n8 / 8)) {
                    GenericParsecException genericParsecException = new GenericParsecException("Block alignment mismatch");
                    genericParsecException.setHints(String.format("blockAlignment=%d, numChannels=%d, bitsPerSample=%d", n7, n4, n8));
                    throw genericParsecException;
                }
                if (n6 != n5 * n4 * (n8 / 8)) {
                    GenericParsecException genericParsecException = new GenericParsecException("Average bytes per second mismatch");
                    genericParsecException.setHints(String.format("avgBytesPerSec=%d, samplesPerSec=%d, numChannels=%d, bitsPerSample=%d", n6, n5, n4, n8));
                    throw genericParsecException;
                }
                int n9 = n2 = n3 == 65534 ? WAVSource.readLE16(randomAccessFile) : 0;
                if (n2 >= 22) {
                    int n10 = WAVSource.readLE16(randomAccessFile);
                    int n11 = WAVSource.readLE32(randomAccessFile);
                    int n12 = WAVSource.readLE32(randomAccessFile);
                    int n13 = WAVSource.readLE16(randomAccessFile);
                    int n14 = WAVSource.readLE16(randomAccessFile);
                    byte[] byArray2 = new byte[8];
                    randomAccessFile.readFully(byArray2);
                    if (n12 != 1 || n13 != 0 || n14 != 16 || byArray2[0] != -128 || byArray2[1] != 0 || byArray2[2] != 0 || byArray2[3] != -86 || byArray2[4] != 0 || byArray2[5] != 56 || byArray2[6] != -101 || byArray2[7] != 113) {
                        GenericParsecException genericParsecException = new GenericParsecException("Extensible GUID mismatch");
                        genericParsecException.setHints(String.format("%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x", n12, n13, n14, byArray2[0], byArray2[1], byArray2[2], byArray2[3], byArray2[4], byArray2[5], byArray2[6], byArray2[7]));
                        throw genericParsecException;
                    }
                    if (n10 != 16) {
                        GenericParsecException genericParsecException = new GenericParsecException("Extensible data format error");
                        genericParsecException.setHints(String.format("validBitsPerSample=", n10));
                        throw genericParsecException;
                    }
                } else if (n2 != 0) {
                    GenericParsecException genericParsecException = new GenericParsecException("Extensible cbSize mismatch");
                    genericParsecException.setHints(String.format("cbSize=%d", n2));
                    throw genericParsecException;
                }
                randomAccessFile.seek(l2 + (long)n);
                continue;
            }
            if (byArray[0] == 100 && byArray[1] == 97 && byArray[2] == 116 && byArray[3] == 97) {
                if (headerCookie.avgBytesPerSec == 0) {
                    throw new GenericParsecException("Unexpected data chunk (missing fmt chunk)");
                }
                l2 = (long)n * 1000L;
                headerCookie.durationMS = l2 / (long)headerCookie.avgBytesPerSec;
                if (l2 % (long)headerCookie.avgBytesPerSec == 0L) break;
                ++headerCookie.durationMS;
                break;
            }
            l2 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l2 + (long)n);
        }
        return headerCookie;
    }

    private static MediaSource.Jack fetchJack(MediaSource.Jack[] jackArray, String string, String string2, boolean bl) {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < jackArray.length; ++i) {
            MediaSource.Jack jack = jackArray[i];
            if (jack == null) continue;
            String string3 = ParsecTools.trimString(jack.getSetupArg("mapping"));
            String string4 = ParsecTools.trimString(jack.jackName);
            if (n < 0 && n2 < 10 && string3 != null && string3.equals(string)) {
                n = i;
                n2 = 10;
                break;
            }
            if (n < 0 && n2 < 5 && string3 == null && string4 != null && string4.equals(string2)) {
                n = i;
                n2 = 5;
                continue;
            }
            if (n >= 0 || n2 >= 1 || !bl || string3 != null || string4 != null) continue;
            n = i;
            n2 = 1;
        }
        if (n >= 0) {
            MediaSource.Jack jack = jackArray[n];
            jackArray[n] = null;
            return jack;
        }
        return null;
    }

    private static MediaSource.Jack getJack(MediaSource.Trunk trunk, MediaSource.Jack[] jackArray, String string, String string2, boolean bl, boolean bl2) {
        MediaSource.Jack jack = WAVSource.fetchJack(jackArray, string, string2, bl);
        if (jack == null) {
            jack = trunk.addJack(string2);
            jack.routing.enabled = bl2;
        } else {
            jack.jackName = string2;
        }
        jack.putSetupArg("mapping", string);
        return jack;
    }

    private static void prepareAudioTrunk(MediaSource.Trunk trunk, MediaSource.Jack[] jackArray, String string) throws ParsecException {
        MediaSource.Jack jack = WAVSource.getJack(trunk, jackArray, string, "stdSound", true, true);
        jack.comment = null;
        jack.serviceType = 132;
    }

    private static void prepareISPTrunk(MediaSource.Trunk trunk, MediaSource.Jack[] jackArray) throws ParsecException {
        MediaSource.Jack jack = WAVSource.getJack(trunk, jackArray, "ISPT-head", "stdLaser", false, true);
        jack.comment = "Track 1-5";
        jack.serviceType = 128;
        MediaSource.Jack jack2 = WAVSource.getJack(trunk, jackArray, "ISPT-efx", "stdEFX", false, false);
        jack2.comment = "Track 6";
        jack2.serviceType = 128;
        MediaSource.Jack jack3 = WAVSource.getJack(trunk, jackArray, "ISPT-audio", "stdSound", false, true);
        jack3.comment = "Track 7,8";
        jack3.serviceType = 132;
    }

    static void checkTrunkProfile(MediaSource.Trunk trunk, String string) throws ParsecException {
        String string2 = trunk.getSetupArg("profile");
        if (string2 == null) {
            trunk.putSetupArg("profile", string);
        } else if (!string2.equals(string)) {
            String string3 = "Trunk layout (" + trunk.layout + ") playback profile mismatch (" + string2 + ")";
            throw new GenericParsecException(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void prepareTrunk(MediaSource.Trunk trunk, HeaderCookie headerCookie) throws ParsecException {
        MediaSource.Jack jack;
        MediaSource.Jack[] jackArray;
        block13: {
            block14: {
                String string = trunk.trunkName;
                if (string != null && (string = string.trim()).length() == 0) {
                    string = null;
                }
                trunk.label = "Stream";
                if (string != null) {
                    trunk.label = trunk.label + ": " + string;
                }
                trunk.durationMS = headerCookie.durationMS;
                jackArray = new MediaSource.Jack[trunk.jacks.size()];
                trunk.jacks.toArray(jackArray);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                bl = trunk.layout.equalsIgnoreCase("Stereo");
                if (!bl && !(bl2 = trunk.layout.equalsIgnoreCase("Surround")) && !(bl3 = trunk.layout.equalsIgnoreCase("Multitrack"))) break block14;
                WAVSource.checkTrunkProfile(trunk, "audio");
                Object var7_7 = null;
                if (bl && headerCookie.numChannels == 2) {
                    WAVSource.prepareAudioTrunk(trunk, jackArray, "phonic");
                    break block13;
                } else if (bl2 && headerCookie.numChannels == 6) {
                    WAVSource.prepareAudioTrunk(trunk, jackArray, "surround");
                    break block13;
                } else {
                    if (!bl3) {
                        String string2 = "File channel count mismatch: " + headerCookie.numChannels;
                        throw new GenericParsecException(string2);
                    }
                    WAVSource.prepareAudioTrunk(trunk, jackArray, "multitrack");
                }
                break block13;
            }
            if (!trunk.layout.equalsIgnoreCase("ISP-TAPE")) {
                throw new GenericParsecException("Can't handle trunk layout");
            }
            WAVSource.checkTrunkProfile(trunk, "lasershow");
            if (headerCookie.numChannels != 8) {
                String string = "File channel count mismatch: " + headerCookie.numChannels;
                throw new GenericParsecException(string);
            }
            WAVSource.prepareISPTrunk(trunk, jackArray);
        }
        int n = 0;
        while (true) {
            if (n >= jackArray.length) {
                return;
            }
            jack = jackArray[n];
            if (jack != null) break;
            ++n;
        }
        String string = jack.getSetupArg("mapping");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Jack ").append(n + 1);
        if (jack.jackName != null) {
            stringBuilder.append(" (").append(jack.jackName).append(")");
        }
        if (string != null) {
            stringBuilder.append(", mapping ").append(string);
        }
        stringBuilder.append(" assignment error (unmatched)");
        throw new GenericParsecException(stringBuilder.toString());
    }

    private static void prepareSource(RandomAccessFile randomAccessFile, MediaSource mediaSource) throws ParsecException {
        MediaSource.Trunk trunk;
        HeaderCookie headerCookie = null;
        try {
            headerCookie = WAVSource.readHeader(randomAccessFile);
        }
        catch (IOException iOException) {
            GenericParsecException genericParsecException = new GenericParsecException("File I/O error");
            genericParsecException.setDetails(ParsecTools.getTraceDetails(iOException));
            throw genericParsecException;
        }
        if (headerCookie == null) {
            throw new InternalParsecException("No header cookie");
        }
        int n = mediaSource.getFeed().trunks.size();
        if (n == 0) {
            trunk = mediaSource.getFeed().addTrunk(null);
            trunk.enabled = true;
        } else if (n != 1) {
            String string = "Invalid trunk count " + n;
            throw new GenericParsecException(string);
        }
        trunk = mediaSource.getFeed().trunks.get(0);
        if (trunk.layout == null) {
            if (headerCookie.numChannels == 2) {
                trunk.layout = "Stereo";
            } else if (headerCookie.numChannels == 8) {
                trunk.layout = "ISP-TAPE";
            } else {
                String string = "Can't handle " + headerCookie.numChannels + " channel files";
                throw new GenericParsecException(string);
            }
        }
        try {
            WAVSource.prepareTrunk(trunk, headerCookie);
        }
        catch (ParsecException parsecException) {
            int n2 = 1;
            String string = ParsecTools.trimString(trunk.trunkName);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Trunk ").append(n2);
            if (string != null) {
                stringBuilder.append(" (").append(string).append(")");
            }
            stringBuilder.append(", layout: ").append(trunk.layout);
            parsecException.addHint(stringBuilder.toString());
            throw parsecException;
        }
    }

    public static MediaSource createSource(File file, RandomAccessFile randomAccessFile) throws ParsecException {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string = "File path error: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setDetails(ParsecTools.getTraceDetails(iOException));
            throw genericParsecException;
        }
        MediaSource mediaSource = new MediaSource("WAV", file2);
        try {
            WAVSource.prepareSource(randomAccessFile, mediaSource);
        }
        catch (ParsecException parsecException) {
            parsecException.addHint("Media file: " + file.getName());
            throw parsecException;
        }
        return mediaSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource createSource(File file) throws ParsecException {
        if (file == null) {
            throw new InternalParsecException("Invalid parameter");
        }
        if (!file.exists()) {
            String string = "Media file not found: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
            throw genericParsecException;
        }
        RandomAccessFile randomAccessFile = null;
        MediaSource mediaSource = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (Exception exception) {
                String string = "Media file open error: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string);
                genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
                genericParsecException.setDetails(ParsecTools.getTraceDetails(exception));
                throw genericParsecException;
            }
            mediaSource = WAVSource.createSource(file, randomAccessFile);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return mediaSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSource(MediaSource mediaSource) throws ParsecException {
        File file = new File(mediaSource.getFeed().absoluteURI.getPath());
        if (!file.exists()) {
            String string = "Media file not found: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
            throw genericParsecException;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (Exception exception) {
                String string = "Media file open error: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string);
                genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
                genericParsecException.setDetails(ParsecTools.getTraceDetails(exception));
                throw genericParsecException;
            }
            try {
                WAVSource.prepareSource(randomAccessFile, mediaSource);
            }
            catch (ParsecException parsecException) {
                parsecException.addHint("Media file: " + file.getName());
                throw parsecException;
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static class HeaderCookie {
        public int numChannels;
        public int avgBytesPerSec;
        public long durationMS;

        private HeaderCookie() {
        }
    }
}

