/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.setup;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.SetupArgIO;
import dexlogic.parsec.setup.SetupProvider;
import dexlogic.parsec.setup.SetupSchema;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class WSetupPanel
extends JComponent {
    private SetupProvider setupProvider;
    private SetupSchema.Element elementSchema;
    private Map<String, String> attribMap;
    private Map<String, SetupParam> setupMap;
    private JLabel paramLabel;
    private MenuButton menuButton;
    private JMenuItem discardItem;
    private JMenuItem moveUpItem;
    private JMenuItem moveDnItem;
    private JComponent childContainer;
    protected int childIndent = 0;
    static ImageIcon menuIcon;

    private void updateParamLabel() {
        if (this.paramLabel == null || this.setupMap == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, SetupParam> entry : this.setupMap.entrySet()) {
            SetupParam setupParam = entry.getValue();
            if (!setupParam.getParamSchema().isOutline()) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(setupParam.getName());
            stringBuilder.append(":");
            stringBuilder.append(setupParam.currentValue);
        }
        this.paramLabel.setText(stringBuilder.toString());
    }

    private void createChildContainer() {
        this.childContainer = Box.createVerticalBox();
        this.childContainer.setOpaque(true);
        this.add(this.childContainer);
    }

    protected void dumpAttribMap() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.attribMap != null) {
            for (Map.Entry<String, String> entry : this.attribMap.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("='");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("'");
            }
        }
        System.out.println(stringBuilder.toString());
    }

    protected JLabel getParameterLabel() {
        if (this.paramLabel == null) {
            this.paramLabel = WSetupPanel.createParameterLabel();
            this.paramLabel.setOpaque(false);
            this.updateParamLabel();
        }
        return this.paramLabel;
    }

    protected MenuButton getMenuButton() {
        if (this.menuButton == null) {
            this.menuButton = new MenuButton(this);
        }
        return this.menuButton;
    }

    protected void addPopupItemsNew(MenuButton menuButton) {
        SetupSchema.Element[] elementArray = this.elementSchema.getChildSchemas();
        if (elementArray != null) {
            for (SetupSchema.Element element : elementArray) {
                if (element == null) {
                    menuButton.addSeparator();
                    continue;
                }
                if (element.isConcealed() || element.isDesignated()) continue;
                menuButton.addCreateItem("New " + element.toString(), this, element);
            }
        }
    }

    protected void buildPopupMenu(MenuButton menuButton) {
        JMenuItem jMenuItem;
        this.addPopupItemsNew(menuButton);
        if (!this.elementSchema.isDesignated()) {
            if (menuButton.hasItems()) {
                menuButton.addSeparator();
            }
            jMenuItem = this.discardItem = menuButton.addItem(new JMenuItem("Discard"));
            this.discardItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WSetupPanel.this.discard();
                }
            });
        }
        if (menuButton.hasItems()) {
            menuButton.addSeparator();
        }
        jMenuItem = this.moveUpItem = menuButton.addItem(new JMenuItem("Move Up"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WSetupPanel wSetupPanel = WSetupPanel.this;
                Container container = wSetupPanel.getParent();
                int n = container.getComponentZOrder(wSetupPanel);
                container.remove(n);
                container.add((Component)wSetupPanel, n - 1);
                container.revalidate();
            }
        });
        jMenuItem = this.moveDnItem = menuButton.addItem(new JMenuItem("Move Down"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WSetupPanel wSetupPanel = WSetupPanel.this;
                Container container = wSetupPanel.getParent();
                int n = container.getComponentZOrder(wSetupPanel);
                container.remove(n);
                container.add((Component)wSetupPanel, n + 1);
                container.revalidate();
            }
        });
        if (this.setupMap != null) {
            boolean bl = true;
            for (Map.Entry<String, SetupParam> entry : this.setupMap.entrySet()) {
                SetupParam setupParam = entry.getValue();
                if (setupParam.getParamSchema().isConcealed()) continue;
                if (bl) {
                    menuButton.addSeparator();
                    menuButton.addSeparator();
                    bl = false;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(setupParam.getName());
                stringBuilder.append(":");
                stringBuilder.append(setupParam.currentValue);
                Object object = setupParam.getParamSchema().getDefaultValue();
                if (object != null && object == setupParam.currentValue) {
                    stringBuilder.append(" (default)");
                }
                jMenuItem = menuButton.addItem(new JMenuItem(stringBuilder.toString()));
                jMenuItem.setEnabled(setupParam.getParamSchema().isMutable());
            }
        }
    }

    protected void updatePopupItems() {
        Container container = this.getParent();
        int n = container.getComponentZOrder(this);
        if (this.moveUpItem != null) {
            this.moveUpItem.setEnabled(n > 0);
        }
        if (this.moveDnItem != null) {
            int n2 = container.getComponentCount() - 1;
            this.moveDnItem.setEnabled(n >= 0 && n < n2);
        }
    }

    protected void setControlPanel(JPanel jPanel) {
        this.add((Component)jPanel, 0);
        this.revalidate();
    }

    protected void discard() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof WSetupPanel)) continue;
            ((WSetupPanel)container).removeChildPanel(this);
            container.revalidate();
            return;
        }
    }

    protected void childContainerChanged() {
    }

    public WSetupPanel(SetupProvider setupProvider, SetupSchema.Element element) {
        if (setupProvider == null) {
            throw new IllegalArgumentException("Invalid setup provider parameter");
        }
        this.setupProvider = setupProvider;
        if (element == null) {
            throw new IllegalArgumentException("Invalid schema item parameter");
        }
        this.elementSchema = element;
        SetupSchema.Param[] paramArray = element.getParams();
        if (paramArray != null) {
            for (SetupSchema.Param param : paramArray) {
                if (this.setupMap == null) {
                    this.setupMap = new LinkedHashMap<String, SetupParam>();
                }
                this.setupMap.put(param.getName(), new SetupParam(param));
            }
        }
    }

    public SetupProvider getSetupProvider() {
        return this.setupProvider;
    }

    public SetupSchema.Element getElementSchema() {
        return this.elementSchema;
    }

    public void putSetupValue(String string, Object object) {
        SetupParam setupParam = null;
        if (this.setupMap != null) {
            setupParam = this.setupMap.get(string);
        }
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        setupParam.currentValue = object;
        if (setupParam.getParamSchema().isOutline()) {
            this.updateParamLabel();
        }
    }

    public Object getSetupValue(String string) {
        SetupParam setupParam = null;
        if (this.setupMap != null) {
            setupParam = this.setupMap.get(string);
        }
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        return setupParam.currentValue;
    }

    public void putAttrib(String string, String string2) throws ParsecException {
        if (string.equals("setup")) {
            SetupArgIO.readArg(string2, new SetupArgIO(){

                @Override
                public void processParam(String string, String string2) {
                    WSetupPanel.this.putSetupValue(string, string2);
                }
            });
        } else {
            if (this.attribMap == null) {
                this.attribMap = new HashMap<String, String>();
            }
            this.attribMap.put(string, string2);
        }
    }

    public String getAttrib(String string) {
        if (string.equals("setup")) {
            if (this.setupMap == null || this.setupMap.size() == 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, SetupParam> entry : this.setupMap.entrySet()) {
                SetupParam setupParam = entry.getValue();
                SetupSchema.Param param = setupParam.getParamSchema();
                Object object = param.getDefaultValue();
                if (object != null && object == setupParam.currentValue) continue;
                SetupArgIO.writeParam(stringBuilder, setupParam.getName(), setupParam.currentValue);
            }
            return stringBuilder.toString();
        }
        if (this.attribMap == null) {
            return null;
        }
        return this.attribMap.get(string);
    }

    public int getChildPanelCount() {
        if (this.childContainer == null) {
            return 0;
        }
        return this.childContainer.getComponentCount();
    }

    public Component[] getChildPanels() {
        if (this.childContainer == null) {
            return null;
        }
        return this.childContainer.getComponents();
    }

    public void addChildPanel(WSetupPanel wSetupPanel) {
        if (wSetupPanel == null) {
            return;
        }
        if (this.childContainer == null) {
            this.createChildContainer();
        }
        this.childContainer.add(wSetupPanel);
        this.childContainerChanged();
        this.childContainer.revalidate();
    }

    public void removeChildPanel(WSetupPanel wSetupPanel) {
        if (wSetupPanel == null || this.childContainer == null) {
            return;
        }
        this.childContainer.remove(wSetupPanel);
        this.childContainerChanged();
        this.childContainer.revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (i == 0) {
                n7 = 4;
                n6 = 4;
                n5 = 4;
                n4 = 4;
            } else {
                n5 = this.childIndent;
            }
            Dimension dimension = component.getPreferredSize();
            int n8 = n5 + dimension.width + n7;
            int n9 = n4 + dimension.height + n6;
            if (n8 > n) {
                n = n8;
            }
            n2 += n9;
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        return new Dimension(n, n2);
    }

    @Override
    public void doLayout() {
        Serializable serializable;
        int n;
        Insets insets = this.getInsets();
        int n2 = insets == null ? 0 : insets.left;
        int n3 = insets == null ? 0 : insets.top;
        int n4 = this.getSize().width;
        if (insets != null) {
            n4 -= insets.left + insets.right;
        }
        int n5 = this.getComponentCount();
        for (n = 0; n < n5; ++n) {
            serializable = this.getComponent(n);
            if (!((Component)serializable).isVisible()) continue;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (n == 0) {
                n9 = 4;
                n8 = 4;
                n7 = 4;
                n6 = 4;
            } else {
                n7 = this.childIndent;
            }
            Dimension dimension = ((Component)serializable).getPreferredSize();
            ((Component)serializable).setBounds(n2 + n7, n3 + n6, n4 - (n7 + n9), dimension.height);
            n3 += n6 + dimension.height + n8;
        }
        if (this.childContainer != null) {
            n = 0;
            serializable = this.getBackground();
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof WSetupPanel)) continue;
                ++n;
                serializable = container.getBackground();
            }
            if (serializable != null) {
                if (n == 0) {
                    this.childContainer.setBackground(WSetupPanel.brighter((Color)serializable, 0.95));
                } else if (n == 1) {
                    this.childContainer.setBackground((Color)serializable);
                } else if (n > 1) {
                    this.childContainer.setBackground(WSetupPanel.darker((Color)serializable, Math.pow(0.96, n - 1)));
                }
            }
        }
    }

    static JLabel createParameterLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 0, font.getSize() - 1));
        jLabel.setForeground(new Color(48, 96, 80));
        return jLabel;
    }

    public static JLabel createServiceTypeLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 2, font.getSize() - 1));
        jLabel.setForeground(new Color(128, 128, 192));
        return jLabel;
    }

    public static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), n4);
    }

    public static Color darker(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return new Color(Math.max((int)((double)n * d), 0), Math.max((int)((double)n2 * d), 0), Math.max((int)((double)n3 * d), 0), n4);
    }

    public static WSetupPanel createPanel(SetupProvider setupProvider, SetupSchema.Element element) throws ParsecException {
        try {
            Constructor<?> constructor = element.getPanelClass().getConstructor(SetupProvider.class, SetupSchema.Element.class);
            Object obj = constructor.newInstance(setupProvider, element);
            if (obj instanceof WSetupPanel) {
                return (WSetupPanel)obj;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalParsecException("No suitable constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            ParsecException parsecException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                throw new ParsecException("InvocationTargetException without cause");
            }
            if (throwable instanceof GenericParsecException) {
                parsecException = new GenericParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else if (throwable instanceof ParsecException) {
                parsecException = new ParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else {
                parsecException = new ParsecException(throwable.getMessage());
            }
            parsecException.initCause(invocationTargetException.getCause());
            throw parsecException;
        }
        catch (Throwable throwable) {
            InternalParsecException internalParsecException = new InternalParsecException("Instantiation exception");
            internalParsecException.initCause(throwable.getCause());
            throw internalParsecException;
        }
        return null;
    }

    class MenuButton
    extends JButton {
        private WSetupPanel setupPanel;
        private JPopupMenu popupMenu;
        private ArrayList<JMenuItem> onlyChildMenuItems;

        MenuButton(final WSetupPanel wSetupPanel2) {
            this.setupPanel = wSetupPanel2;
            if (menuIcon == null) {
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream("/icons/menu-button.png");
                    menuIcon = new ImageIcon(ImageIO.read(inputStream));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (menuIcon != null) {
                this.setIcon(menuIcon);
            } else {
                this.setText("M");
            }
            this.setOpaque(false);
            this.setMargin(new Insets(0, 2, 0, 2));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (MenuButton.this.popupMenu == null) {
                        wSetupPanel2.buildPopupMenu(MenuButton.this);
                        if (MenuButton.this.popupMenu == null) {
                            return;
                        }
                    }
                    wSetupPanel2.updatePopupItems();
                    if (MenuButton.this.onlyChildMenuItems != null) {
                        for (JMenuItem jMenuItem : MenuButton.this.onlyChildMenuItems) {
                            jMenuItem.setEnabled(wSetupPanel2.getChildPanelCount() <= 0);
                        }
                    }
                    MenuButton.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            });
        }

        boolean hasItems() {
            if (this.popupMenu == null) {
                return false;
            }
            return this.popupMenu.getComponentCount() != 0;
        }

        int getItemCount() {
            if (this.popupMenu == null) {
                return 0;
            }
            return this.popupMenu.getComponentCount();
        }

        JMenuItem addItem(JMenuItem jMenuItem) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu.add(jMenuItem);
        }

        JMenuItem addCreateItem(String string, WSetupPanel wSetupPanel, SetupSchema.Element element) {
            JMenuItem jMenuItem;
            if (element.isServiceType()) {
                JMenu jMenu = new JMenu(string);
                jMenuItem = jMenu.add(new JMenuItem("DMX512 (serviceType 0x05)"));
                jMenuItem = jMenu.add(new JMenuItem("lapro (serviceType 0x80)"));
                jMenuItem = jMenu.add(new JMenuItem("audio (serviceType 0x84)"));
                jMenuItem = jMenu;
            } else {
                jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new AbstractAction(){
                    private WSetupPanel parentPanel;
                    private SetupSchema.Element elementSchema;

                    public AbstractAction init(WSetupPanel wSetupPanel, SetupSchema.Element element) {
                        this.parentPanel = wSetupPanel;
                        this.elementSchema = element;
                        return this;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            WSetupPanel wSetupPanel = WSetupPanel.createPanel(this.parentPanel.getSetupProvider(), this.elementSchema);
                            this.parentPanel.addChildPanel(wSetupPanel);
                        }
                        catch (Throwable throwable) {
                            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.parentPanel);
                            ParsecTools.showExceptionDialog(frame, "Panel creation error", throwable);
                        }
                    }
                }.init(wSetupPanel, element));
            }
            if (element.isOnlyChild()) {
                if (this.onlyChildMenuItems == null) {
                    this.onlyChildMenuItems = new ArrayList();
                }
                this.onlyChildMenuItems.add(jMenuItem);
            }
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu.add(jMenuItem);
        }

        void addSeparator() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            this.popupMenu.addSeparator();
        }
    }

    public static class SetupParam {
        SetupSchema.Param paramSchema;
        Object currentValue;

        public SetupParam(SetupSchema.Param param) {
            this.paramSchema = param;
            this.currentValue = param.getDefaultValue();
        }

        public String getName() {
            return this.paramSchema.getName();
        }

        public SetupSchema.Param getParamSchema() {
            return this.paramSchema;
        }
    }
}

