/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.setup;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WFileChooser;
import dexlogic.parsec.setup.SetupProvider;
import dexlogic.parsec.setup.SetupSchema;
import dexlogic.parsec.setup.WSetupPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WDriverPanel
extends WSetupPanel {
    private int modFlags;
    private static final int MODFLAG_IDNCLIENT = 1;
    private static final int MODFLAG_WRITER = 2;
    private static final int MODFLAG_IDNSERVER = 16;
    private static final int MODFLAG_READER = 32;

    private void newIDNFileWriter() throws ParsecException {
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.setDialogType(1);
        wFileChooser.setAcceptAllFileFilterUsed(false);
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("IDN-File Format", ".idn"));
        int n = wFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = wFileChooser.getSelectedFile();
    }

    private void newIDNPullServer() throws ParsecException {
    }

    private void newFileReader() throws ParsecException {
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.setDialogType(0);
        wFileChooser.setAcceptAllFileFilterUsed(false);
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("IDN-File Format", ".idn"));
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("Waveform File Format", ".wav"));
        int n = wFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = wFileChooser.getSelectedFile();
        String string = file.getName().toLowerCase();
        if (!string.endsWith(".idn") && !string.endsWith(".wav")) {
            throw new ParsecException("Invalid file extension");
        }
    }

    private JPanel buildControlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel(this.getElementSchema().toString());
        jLabel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.getMenuButton(), gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void addPopupItemsNew(WSetupPanel.MenuButton menuButton) {
        JMenuItem jMenuItem;
        super.addPopupItemsNew(menuButton);
        if ((this.modFlags & 1) != 0) {
            jMenuItem = menuButton.addItem(new JMenuItem("Scan for IDN servers"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
        }
        if ((this.modFlags & 2) != 0) {
            jMenuItem = menuButton.addItem(new JMenuItem("New IDN Writer"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WDriverPanel.this.newIDNFileWriter();
                    }
                    catch (Throwable throwable) {
                        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, WDriverPanel.this);
                        ParsecTools.showExceptionDialog(frame, "File open error", throwable);
                    }
                }
            });
        }
        if ((this.modFlags & 0x10) != 0) {
            jMenuItem = menuButton.addItem(new JMenuItem("New IDN Pull Server"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WDriverPanel.this.newIDNPullServer();
                    }
                    catch (Throwable throwable) {
                        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, WDriverPanel.this);
                        ParsecTools.showExceptionDialog(frame, "Pull server creation error", throwable);
                    }
                }
            });
        }
        if ((this.modFlags & 0x20) != 0) {
            jMenuItem = menuButton.addItem(new JMenuItem("New File Reader"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WDriverPanel.this.newFileReader();
                    }
                    catch (Throwable throwable) {
                        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, WDriverPanel.this);
                        ParsecTools.showExceptionDialog(frame, "File open error", throwable);
                    }
                }
            });
        }
    }

    public WDriverPanel(SetupProvider setupProvider, SetupSchema.Element element) {
        super(setupProvider, element);
        if (element != null && element instanceof SetupSchema.Driver) {
            SetupSchema.Driver driver = (SetupSchema.Driver)element;
            String string = driver.getDriverID();
            if (string.equals("IDNClient")) {
                this.modFlags = 1;
            } else if (string.equals("FileWriter")) {
                this.modFlags = 2;
            } else if (string.equals("IDNServer")) {
                this.modFlags = 16;
            } else if (string.equals("FileReader")) {
                this.modFlags = 32;
            }
        }
        this.setControlPanel(this.buildControlPanel());
        this.childIndent = 15;
    }
}

