/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.routes.RPCArg;
import dexlogic.parsec.routes.RPCArgException;
import dexlogic.parsec.routes.RPCArray;
import dexlogic.parsec.routes.RPCObject;

public class RPCJob {
    private String methodName;
    private RPCObject params;

    RPCJob(RPCObject rPCObject) throws RPCArgException {
        Object v = rPCObject.get("jsonrpc");
        if (v == null || !(v instanceof String) || !v.equals("2.0")) {
            throw new RPCArgException("Invalid JSON-RPC header");
        }
        Object v2 = rPCObject.get("method");
        if (v2 == null || !(v2 instanceof String)) {
            throw new RPCArgException("Invalid JSON-RPC method object");
        }
        this.methodName = (String)v2;
        Object v3 = rPCObject.get("params");
        if (v3 != null && !(v3 instanceof RPCObject) && !(v3 instanceof RPCArray)) {
            throw new RPCArgException("Invalid JSON-RPC params object");
        }
        this.params = (RPCObject)v3;
    }

    void toString(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append("{\n");
        String string2 = string + "  ";
        stringBuilder.append(string2).append("\"jsonrpc\": \"").append("2.0").append("\",\n");
        stringBuilder.append(string2).append("\"method\": \"").append(this.methodName).append("\",\n");
        stringBuilder.append(string2).append("\"params\":\n");
        RPCArg.writeJSONObject(stringBuilder, string2, this.params);
        stringBuilder.append(string).append("}");
    }

    public RPCJob(String string, RPCObject rPCObject) {
        this.methodName = string;
        this.params = rPCObject;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, "");
        return stringBuilder.toString();
    }
}

