/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.SetupArgIO;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MediaSource {
    private Feed feed;

    public MediaSource(URI uRI) {
        this.feed = new Feed(uRI);
    }

    public MediaSource(String string, File file) {
        this.feed = new Feed(string, file);
    }

    public Feed getFeed() {
        return this.feed;
    }

    public static Map<String, String> parseSetupArg(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string == null) {
            return linkedHashMap;
        }
        try {
            SetupArgIO.readArg(string, new SetupArgIO(){
                Map<String, String> setupMap;

                public SetupArgIO init(Map<String, String> map) {
                    this.setupMap = map;
                    return this;
                }

                @Override
                public void processParam(String string, String string2) {
                    this.setupMap.put(string, string2);
                }
            }.init(linkedHashMap));
        }
        catch (ParsecException parsecException) {
            return null;
        }
        return linkedHashMap;
    }

    public static class Feed
    extends Element {
        public ArrayList<Trunk> trunks = new ArrayList();
        public String scheme;
        public URI absoluteURI;
        public boolean originalPathFlag;
        public boolean absolutePathFlag;

        public Feed(URI uRI) {
            this.absoluteURI = uRI;
        }

        public Feed(String string, File file) {
            this.scheme = string;
            this.absoluteURI = file.toURI();
        }

        public Trunk addTrunk(String string, String string2) {
            Trunk trunk = new Trunk(string, MediaSource.parseSetupArg(string2));
            this.trunks.add(trunk);
            return trunk;
        }

        public Trunk addTrunk(String string) {
            return this.addTrunk(string, null);
        }
    }

    public static class Trunk
    extends Element {
        public ArrayList<Jack> jacks = new ArrayList();
        public String trunkName;
        public boolean enabled;
        public String layout;
        public String label;
        public long durationMS;

        public Trunk(String string, Map<String, String> map) {
            super(map);
            this.trunkName = string;
            this.enabled = false;
        }

        public Jack addJack(String string, String string2) {
            Jack jack = new Jack(string, MediaSource.parseSetupArg(string2));
            this.jacks.add(jack);
            return jack;
        }

        public Jack addJack(String string) {
            return this.addJack(string, null);
        }
    }

    public static class Jack
    extends Element {
        public Routing routing;
        public String jackName;
        public String comment;
        public int serviceType;

        public Jack(String string, Map<String, String> map) {
            super(map);
            this.jackName = string;
            this.routing = new Routing();
            this.routing.enabled = true;
            this.routing.patch = null;
        }

        public Jack(String string) {
            this(string, null);
        }
    }

    public static class Plugin
    extends Element {
        public Routing routing = new Routing();
        public String driverID;
        public String scheme;
        public String setupArg;

        public Plugin() {
            this((String)null);
        }

        public Plugin(String string) {
            super(string);
            this.routing.enabled = true;
            this.routing.patch = "";
        }

        public void setTransparent() {
            this.driverID = null;
            this.scheme = null;
            this.setupArg = null;
        }
    }

    public static class Routing {
        public ArrayList<Plugin> plugins = new ArrayList();
        public String patch;
        public boolean enabled;
    }

    public static class Element {
        private LocalObjectAgent objectAgent = new LocalObjectAgent();
        private Map<String, String> setupMap;
        private String rpcArg;

        LocalObjectAgent getObjectAgent() {
            return this.objectAgent;
        }

        public Element() {
            this.setupMap = null;
        }

        public Element(Map<String, String> map) {
            this.setupMap = map;
        }

        public Element(String string) {
            this.rpcArg = string;
        }

        public Element(Map<String, String> map, String string) {
            this.setupMap = map;
            this.rpcArg = string;
        }

        public String getSetupArg(String string) {
            if (this.setupMap == null) {
                return null;
            }
            return this.setupMap.get(string);
        }

        public void putSetupArg(String string, String string2) {
            if (this.setupMap == null) {
                this.setupMap = new LinkedHashMap<String, String>();
            }
            this.setupMap.put(string, string2);
        }

        public String getSetupArgs() {
            if (this.setupMap == null) {
                return null;
            }
            if (this.setupMap.size() == 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : this.setupMap.entrySet()) {
                SetupArgIO.writeParam(stringBuilder, entry.getKey(), entry.getValue());
            }
            return stringBuilder.toString();
        }

        public String getRPCArg() {
            return this.rpcArg;
        }

        public void updateRPCArg(String string) {
            this.rpcArg = string;
            if (this.objectAgent == null) {
                this.objectAgent = new LocalObjectAgent();
            }
            this.objectAgent.fwdCall(string);
        }

        public synchronized void addInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            if (rPCInvokeAdapter == null) {
                return;
            }
            if (this.objectAgent == null) {
                this.objectAgent = new LocalObjectAgent();
            }
            this.objectAgent.addInvokeAdapter(rPCInvokeAdapter);
        }

        public synchronized void removeInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            if (rPCInvokeAdapter == null) {
                return;
            }
            if (this.objectAgent != null) {
                this.objectAgent.removeInvokeAdapter(rPCInvokeAdapter);
            }
        }
    }
}

