/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.FWDCallEvent;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeBroker;
import dexlogic.parsec.routes.RemoteObjectProxy;

public class LocalObjectAgent
implements RPCInvokeBroker {
    volatile RemoteObjectProxy[] remoteObjectProxyArray;
    volatile RPCInvokeAdapter[] rpcInvokeAdapterArray;

    synchronized void addRemoteObjectProxy(RemoteObjectProxy remoteObjectProxy) {
        if (remoteObjectProxy == null) {
            return;
        }
        this.remoteObjectProxyArray = ParsecTools.arrayAdd(RemoteObjectProxy.class, this.remoteObjectProxyArray, remoteObjectProxy);
    }

    synchronized void removeRemoteObjectProxy(RemoteObjectProxy remoteObjectProxy) {
        if (remoteObjectProxy == null || this.remoteObjectProxyArray == null) {
            return;
        }
        this.remoteObjectProxyArray = ParsecTools.arrayRemove(this.remoteObjectProxyArray, remoteObjectProxy);
    }

    public void fwdCall(String string) {
        RemoteObjectProxy[] remoteObjectProxyArray = this.remoteObjectProxyArray;
        if (remoteObjectProxyArray == null || remoteObjectProxyArray.length <= 0) {
            return;
        }
        FWDCallEvent fWDCallEvent = new FWDCallEvent(this, string);
        for (int i = remoteObjectProxyArray.length - 1; i >= 0; --i) {
            try {
                remoteObjectProxyArray[i].fwdCallHandler(fWDCallEvent);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter == null) {
            return;
        }
        if (rPCInvokeAdapter.selector == null || !(rPCInvokeAdapter.selector instanceof String || rPCInvokeAdapter.selector instanceof Integer)) {
            throw new IllegalArgumentException("Selector must be a String or Integer object");
        }
        this.rpcInvokeAdapterArray = ParsecTools.arrayAdd(RPCInvokeAdapter.class, this.rpcInvokeAdapterArray, rPCInvokeAdapter);
        RemoteObjectProxy[] remoteObjectProxyArray = this.remoteObjectProxyArray;
        if (remoteObjectProxyArray != null && remoteObjectProxyArray.length >= 0) {
            for (int i = remoteObjectProxyArray.length - 1; i >= 0; --i) {
                remoteObjectProxyArray[i].addRPCInvokeAdapter(rPCInvokeAdapter);
            }
        }
    }

    @Override
    public synchronized void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter == null) {
            return;
        }
        RPCInvokeAdapter[] rPCInvokeAdapterArray = this.rpcInvokeAdapterArray;
        this.rpcInvokeAdapterArray = ParsecTools.arrayRemove(rPCInvokeAdapterArray, rPCInvokeAdapter);
        if (this.rpcInvokeAdapterArray == rPCInvokeAdapterArray) {
            throw new IllegalArgumentException("RPC invoke adapter not found");
        }
        RemoteObjectProxy[] remoteObjectProxyArray = this.remoteObjectProxyArray;
        if (remoteObjectProxyArray != null && remoteObjectProxyArray.length >= 0) {
            for (int i = remoteObjectProxyArray.length - 1; i >= 0; --i) {
                remoteObjectProxyArray[i].removeRPCInvokeAdapter(rPCInvokeAdapter);
            }
        }
    }
}

