/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.FlowProxy;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.ProxyStateHandler;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeHandler;

public class FlowProxyEditor {
    private FlowProxy flowProxy;
    private FlowManager flowManager;

    FlowProxyEditor(FlowProxy flowProxy, FlowManager flowManager) {
        this.flowProxy = flowProxy;
        this.flowManager = flowManager;
    }

    void reset() {
        this.flowProxy = null;
        this.flowManager = null;
    }

    public int getNextObjectNum() {
        if (this.flowManager == null) {
            throw new RuntimeException("Invalid state");
        }
        return this.flowManager.getNextObjectNum();
    }

    public String addObjectAgent(int n, LocalObjectAgent localObjectAgent) {
        int n2;
        if (this.flowManager == null) {
            throw new RuntimeException("Invalid state");
        }
        if (this.flowProxy == null) {
            throw new RuntimeException("Invalid state");
        }
        this.flowProxy.addObjectGateway(n, localObjectAgent);
        StringBuilder stringBuilder = null;
        RPCInvokeAdapter[] rPCInvokeAdapterArray = localObjectAgent.rpcInvokeAdapterArray;
        int n3 = n2 = rPCInvokeAdapterArray == null ? 0 : rPCInvokeAdapterArray.length;
        for (int i = 0; i < n2; ++i) {
            RPCInvokeAdapter rPCInvokeAdapter = rPCInvokeAdapterArray[i];
            RPCInvokeHandler rPCInvokeHandler = this.flowManager.createRPCInvokeHandler(n, rPCInvokeAdapter);
            this.flowProxy.addInvokeHandler(rPCInvokeAdapter, rPCInvokeHandler);
            if (!(rPCInvokeAdapter.selector instanceof String)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(";");
            }
            stringBuilder.append((String)rPCInvokeAdapter.selector);
            stringBuilder.append(":\"");
            int n4 = rPCInvokeHandler.lsnID & 0xFFFF3FFF;
            stringBuilder.append("s#").append(n4);
            stringBuilder.append("\"");
        }
        return stringBuilder == null ? "" : stringBuilder.toString();
    }

    public void addStateHandler(ProxyStateHandler proxyStateHandler) {
        if (this.flowProxy == null) {
            throw new RuntimeException("Invalid state");
        }
        this.flowProxy.addStateHandler(proxyStateHandler);
    }

    public void setXML(String string) {
        if (this.flowProxy == null) {
            throw new RuntimeException("Invalid state");
        }
        this.flowProxy.setXML(string);
    }
}

