/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.remote;

import dexlogic.parsec.remote.DRCArgException;
import dexlogic.parsec.remote.DRCArray;
import dexlogic.parsec.remote.DRCBatch;
import dexlogic.parsec.remote.DRCJob;
import dexlogic.parsec.remote.DRCNumber;
import dexlogic.parsec.remote.DRCObject;
import java.util.Iterator;
import java.util.Map;

public class DRCArg {
    private DRCArg() {
    }

    private static DRCNumber readJSONNumber(CharStream charStream) throws DRCArgException {
        char c;
        int n = charStream.getPos();
        if (charStream.peekChar() == '-') {
            charStream.skipChar();
        }
        if ((c = charStream.peekChar()) == '0') {
            charStream.skipChar();
        } else if (c >= '1' && c <= '9') {
            charStream.expectDigitsAndSkip();
        } else {
            throw new DRCArgException(charStream, "Not a digit: '" + c + "'");
        }
        if (charStream.hasChars() && charStream.peekChar() == '.') {
            charStream.skipChar();
            charStream.expectDigitsAndSkip();
        }
        if (charStream.hasChars() && (charStream.peekChar() == 'E' || charStream.peekChar() == 'e')) {
            charStream.skipChar();
            c = charStream.peekChar();
            if (c == '-' || c == '+') {
                charStream.skipChar();
            }
            charStream.expectDigitsAndSkip();
        }
        int n2 = charStream.getPos();
        return new DRCNumber(charStream.substring(n, n2));
    }

    private static String readJSONString(CharStream charStream) throws DRCArgException {
        int n;
        charStream.expectCharAndSkip(Character.valueOf('\"'));
        int n2 = charStream.getPos();
        while ((n = charStream.peekChar()) != 34) {
            if (n == 92) {
                charStream.skipChar();
                n = charStream.peekChar();
                if (n == 34 || n == 92 || n == 47 || n == 98 || n == 102 || n == 110 || n == 114 || n == 116) {
                    charStream.skipChar();
                    continue;
                }
                if (n == 117) {
                    charStream.skipChar();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    charStream.expectHexCharAndSkip();
                    continue;
                }
                throw new DRCArgException(charStream, "Expected escaped character");
            }
            if (n >= 32) {
                charStream.skipChar();
                continue;
            }
            throw new DRCArgException(charStream, "Invalid JSON string character");
        }
        n = charStream.getPos();
        charStream.expectCharAndSkip(Character.valueOf('\"'));
        return charStream.substring(n2, n);
    }

    private static Object readJSONValue(CharStream charStream) throws DRCArgException {
        Object object = null;
        char c = charStream.peekChar();
        if (c == 'n') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('u'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
        } else if (c == '-' || c >= '0' && c <= '9') {
            object = DRCArg.readJSONNumber(charStream);
        } else if (c == '\"') {
            object = DRCArg.readJSONString(charStream);
        } else if (c == '{') {
            object = DRCArg.readJSONObject(charStream);
        } else if (c == '[') {
            object = DRCArg.readJSONArray(charStream);
        } else if (c == 't') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('r'));
            charStream.expectCharAndSkip(Character.valueOf('u'));
            charStream.expectCharAndSkip(Character.valueOf('e'));
            object = true;
        } else if (c == 'f') {
            charStream.skipChar();
            charStream.expectCharAndSkip(Character.valueOf('a'));
            charStream.expectCharAndSkip(Character.valueOf('l'));
            charStream.expectCharAndSkip(Character.valueOf('s'));
            charStream.expectCharAndSkip(Character.valueOf('e'));
            object = false;
        } else {
            throw new DRCArgException(charStream, "Invalid JSON value");
        }
        return object;
    }

    private static DRCObject readJSONObject(CharStream charStream) throws DRCArgException {
        DRCObject dRCObject = new DRCObject();
        charStream.expectCharAndSkip(Character.valueOf('{'));
        charStream.skipWhitespace();
        if (charStream.peekChar() == '}') {
            charStream.skipChar();
            return dRCObject;
        }
        while (true) {
            String string = DRCArg.readJSONString(charStream);
            charStream.skipWhitespace();
            charStream.expectCharAndSkip(Character.valueOf(':'));
            charStream.skipWhitespace();
            Object object = DRCArg.readJSONValue(charStream);
            dRCObject.put(string, object);
            charStream.skipWhitespace();
            if (charStream.peekChar() == '}') break;
            charStream.expectCharAndSkip(Character.valueOf(','));
            charStream.skipWhitespace();
        }
        charStream.skipChar();
        return dRCObject;
    }

    private static DRCArray readJSONArray(CharStream charStream) throws DRCArgException {
        DRCArray dRCArray = new DRCArray();
        charStream.expectCharAndSkip(Character.valueOf('['));
        charStream.skipWhitespace();
        if (charStream.peekChar() == ']') {
            charStream.skipChar();
            return dRCArray;
        }
        while (true) {
            dRCArray.add(DRCArg.readJSONValue(charStream));
            charStream.skipWhitespace();
            if (charStream.peekChar() == ']') break;
            charStream.expectCharAndSkip(Character.valueOf(','));
            charStream.skipWhitespace();
        }
        charStream.skipChar();
        return dRCArray;
    }

    private static void writeJSONValue(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof DRCNumber) {
            stringBuilder.append(((DRCNumber)object).toString());
        } else if (object instanceof String) {
            stringBuilder.append('\"').append((String)object).append('\"');
        } else if (object instanceof DRCObject) {
            DRCArg.writeJSONObject(stringBuilder, null, (DRCObject)object);
        } else if (object instanceof DRCArray) {
            DRCArg.writeJSONArray(stringBuilder, null, (DRCArray)object);
        } else if (object instanceof Boolean) {
            String string = (Boolean)object != false ? "true" : "false";
            stringBuilder.append(string);
        } else {
            throw new IllegalArgumentException("Invalid object type: " + object.getClass());
        }
    }

    static void writeJSONObject(StringBuilder stringBuilder, String string, DRCObject dRCObject) {
        if (string == null) {
            stringBuilder.append("{ ");
        } else {
            stringBuilder.append(string).append("{\n");
        }
        Iterator iterator = dRCObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (string != null) {
                stringBuilder.append(string).append("  ");
            }
            stringBuilder.append("\"").append((String)entry.getKey()).append('\"').append(": ");
            DRCArg.writeJSONValue(stringBuilder, entry.getValue());
            if (iterator.hasNext()) {
                stringBuilder.append(',');
            }
            if (string == null) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("\n");
        }
        if (string == null) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append(string).append("}\n");
        }
    }

    static void writeJSONArray(StringBuilder stringBuilder, String string, DRCArray dRCArray) {
        if (string == null) {
            stringBuilder.append("[ ");
        } else {
            stringBuilder.append(string).append("[\n");
        }
        Iterator iterator = dRCArray.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (string != null) {
                stringBuilder.append(string).append("  ");
            }
            DRCArg.writeJSONValue(stringBuilder, e);
            if (iterator.hasNext()) {
                stringBuilder.append(',');
            }
            if (string == null) {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append("\n");
        }
        if (string == null) {
            stringBuilder.append("]");
        } else {
            stringBuilder.append(string).append("]\n");
        }
    }

    public static Object parseJSON(String string) throws DRCArgException {
        if (string == null) {
            return null;
        }
        if ((string = string.strip()).length() == 0) {
            return null;
        }
        Cloneable cloneable = null;
        CharStream charStream = new CharStream(string);
        if (string.startsWith("{") && string.endsWith("}")) {
            cloneable = DRCArg.readJSONObject(charStream);
        } else if (string.startsWith("[") && string.endsWith("]")) {
            cloneable = DRCArg.readJSONArray(charStream);
        } else {
            throw new DRCArgException(charStream, "No valid top-level JSON");
        }
        if (charStream.hasChars()) {
            throw new DRCArgException(charStream, "Excess argument characters");
        }
        return cloneable;
    }

    public static DRCBatch parse(String string) throws DRCArgException {
        if (string == null) {
            return null;
        }
        if ((string = string.strip()).length() == 0) {
            return null;
        }
        DRCBatch dRCBatch = null;
        CharStream charStream = new CharStream(string);
        if (string.startsWith("{") && string.endsWith("}")) {
            DRCObject dRCObject = DRCArg.readJSONObject(charStream);
            if (dRCObject == null) {
                return null;
            }
            if (charStream.hasChars()) {
                throw new DRCArgException(charStream, "Excess argument characters");
            }
            dRCBatch = new DRCBatch();
            dRCBatch.add(new DRCJob(dRCObject));
        } else if (string.startsWith("[") && string.endsWith("]")) {
            DRCArray dRCArray = DRCArg.readJSONArray(charStream);
            if (dRCArray == null) {
                return null;
            }
            if (charStream.hasChars()) {
                throw new DRCArgException(charStream, "Excess argument characters");
            }
            dRCBatch = new DRCBatch();
            for (Object e : dRCArray) {
                if (!(e instanceof DRCObject)) {
                    throw new DRCArgException("Invalid batch array structure");
                }
                dRCBatch.add(new DRCJob((DRCObject)e));
            }
        } else {
            throw new DRCArgException(charStream, "Not a valid RPC argument");
        }
        return dRCBatch;
    }

    static class CharStream {
        private String string;
        private int length;
        private int pos;
        int lineCount;
        int charCount;

        public CharStream(String string) {
            this.string = string;
            this.length = string.length();
            this.lineCount = 1;
            this.charCount = 1;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean hasChars() {
            return this.pos < this.length;
        }

        public char peekChar() throws DRCArgException {
            if (this.pos >= this.length) {
                throw new DRCArgException("Premature end of stream");
            }
            return this.string.charAt(this.pos);
        }

        public void expectCharAndSkip(Character c) throws DRCArgException {
            if (this.pos >= this.length) {
                throw new DRCArgException("Premature end of stream");
            }
            if (this.string.charAt(this.pos) != c.charValue()) {
                throw new DRCArgException(this, "Expected character '" + c + "'");
            }
            if (c.charValue() == '\n') {
                ++this.lineCount;
                this.charCount = 1;
            } else {
                ++this.charCount;
            }
            ++this.pos;
        }

        public void expectHexCharAndSkip() throws DRCArgException {
            if (this.pos >= this.length) {
                throw new DRCArgException("Premature end of stream");
            }
            char c = Character.toUpperCase(this.string.charAt(this.pos));
            if (c < '0' || c > '9' && c < 'A' || c > 'F') {
                throw new DRCArgException(this, "Expected hex digit");
            }
            ++this.pos;
            ++this.charCount;
        }

        public void expectDigitsAndSkip() throws DRCArgException {
            if (this.pos >= this.length) {
                throw new DRCArgException("Premature end of stream");
            }
            char c = this.string.charAt(this.pos);
            if (c < '0' || c > '9') {
                throw new DRCArgException(this, "Invalid number format");
            }
            ++this.pos;
            ++this.charCount;
            while (this.pos < this.length && (c = this.string.charAt(this.pos)) >= '0' && c <= '9') {
                ++this.pos;
                ++this.charCount;
            }
        }

        public void skipChar() throws DRCArgException {
            if (this.pos >= this.length) {
                throw new DRCArgException("Premature end of stream");
            }
            char c = this.string.charAt(this.pos);
            if (c == '\n') {
                ++this.lineCount;
                this.charCount = 1;
            } else {
                ++this.charCount;
            }
            ++this.pos;
        }

        public void skipWhitespace() {
            char c;
            while (this.pos < this.length && Character.isWhitespace(c = this.string.charAt(this.pos))) {
                if (c == '\n') {
                    ++this.lineCount;
                    this.charCount = 1;
                } else {
                    ++this.charCount;
                }
                ++this.pos;
            }
        }

        public String substring(int n, int n2) {
            return this.string.substring(n, n2);
        }
    }
}

