/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.FileSaveAction;
import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WFileChooser;
import dexlogic.parsec.WLogFrame;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.WRenderSystemDialog;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.pplx.MediaEntry;
import dexlogic.parsec.pplx.PPLXReader;
import dexlogic.parsec.pplx.PPLXWriter;
import dexlogic.parsec.pplx.PlaylistModel;
import dexlogic.parsec.pplx.PopupEvent;
import dexlogic.parsec.pplx.PopupListener;
import dexlogic.parsec.pplx.TablePopupEvent;
import dexlogic.parsec.pplx.WControlPanel;
import dexlogic.parsec.pplx.WPlaylistTable;
import dexlogic.parsec.routes.FlowProxyBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WPPLXRootPane
extends WParsecRootPane {
    private File pplxFilePath;
    private boolean unsavedWorkFlag = false;
    private WRenderSystemDialog renderSystemDialog;
    private WLogFrame logFrame;
    private PlaylistModel playlistModel;
    private JMenuItem saveMenuItem;
    private JLabel totalLabel;
    private WPlaylistTable playlistTable;
    private JScrollPane panelScrollPane;
    private JSplitPane splitPane;
    private JPanel emptyFeedPanel;
    private JPanel currentFeedPanel;
    private WControlPanel controlPanel;

    private RefinedFileFilter createFilterPPLX() {
        return new RefinedFileFilter("Parsec Playlist XML", ".pplx");
    }

    private void filenameChanged() {
        String string = "Untitled";
        if (this.pplxFilePath != null) {
            string = this.pplxFilePath.getName();
            this.saveMenuItem.setEnabled(true);
        } else {
            this.saveMenuItem.setEnabled(false);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parsec Playlist");
        if (string != null) {
            stringBuilder.append("  -  ").append(string);
        }
        if (this.unsavedWorkFlag) {
            stringBuilder.append(" *");
        }
        this.setTitle(stringBuilder.toString());
    }

    private void save(File file) {
        File file2 = new FileSaveAction(this){

            @Override
            public void saveTo(File file) throws ParsecException {
                ArrayList<MediaSource> arrayList = new ArrayList<MediaSource>(WPPLXRootPane.this.playlistModel.getRowCount());
                for (MediaEntry mediaEntry : WPPLXRootPane.this.playlistModel.getEntryIterable()) {
                    arrayList.add(mediaEntry.mediaSource);
                }
                PPLXWriter.writeTo(file, arrayList.iterator());
            }
        }.save(file, this.createFilterPPLX());
        if (file2 != null) {
            this.pplxFilePath = file2;
            this.unsavedWorkFlag = false;
            this.filenameChanged();
        }
    }

    private void updateTotalTime() {
        long l = this.playlistModel.getDurationMS();
        this.totalLabel.setText(ParsecTools.durationToString(l));
        this.controlPanel.updateTotalTime();
    }

    private void addFileDialog() {
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("IDN-File Format", ".idn"));
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("Waveform File Format", ".wav"));
        int n = wFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.addFile(wFileChooser.getSelectedFile());
    }

    private void addURIDialog() {
        String string = "URI";
        String string2 = "Add Uniform Resource Identifier";
        int n = 3;
        String string3 = JOptionPane.showInputDialog(this, string, string2, n);
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        try {
            URI uRI;
            try {
                uRI = new URI(string3);
                if (uRI.isOpaque()) {
                    String string4 = "URI syntax error: " + string3;
                    throw new GenericParsecException(string4);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                String string5 = "URI syntax error: " + string3;
                GenericParsecException genericParsecException = new GenericParsecException(string5);
                genericParsecException.setDetails(ParsecTools.getTraceDetails(uRISyntaxException));
                throw genericParsecException;
            }
            uRI = uRI.normalize();
            String string6 = uRI.getScheme();
            if (!uRI.isAbsolute() || string6 == null || !string6.equals("imsp")) {
                String string7 = "URI scheme error: " + string3;
                throw new GenericParsecException(string7);
            }
            MediaSource mediaSource = new MediaSource(uRI);
            MediaEntry mediaEntry = new MediaEntry((SetupProvider)this.controlPanel, mediaSource);
            this.playlistModel.addMedia(mediaEntry);
            this.setUnsavedWork();
        }
        catch (Throwable throwable) {
            ParsecTools.showExceptionDialog(this, "Playlist URI Entry Error", throwable);
        }
    }

    private JMenuItem buildFileAddFileItem() {
        JMenuItem jMenuItem = new JMenuItem("Add File...");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPPLXRootPane.this.addFileDialog();
            }
        });
        return jMenuItem;
    }

    private JMenuItem buildFileAddURIItem() {
        JMenuItem jMenuItem = new JMenuItem("Add URI...");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPPLXRootPane.this.addURIDialog();
            }
        });
        return jMenuItem;
    }

    private WRenderSystemDialog getRenderSystemDialog() {
        if (this.renderSystemDialog == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this.renderSystemDialog = new WRenderSystemDialog(window, this.controlPanel);
        }
        return this.renderSystemDialog;
    }

    private void buildMenu() {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.buildFileMenu();
        jMenu.add(this.buildFileNewMenu());
        jMenu.add(this.buildFileOpenItem());
        jMenu.add(this.buildFileCloseItem());
        jMenu.addSeparator();
        jMenu.add(this.buildFileAddFileItem());
        jMenu.add(this.buildFileAddURIItem());
        jMenu.addSeparator();
        this.saveMenuItem = jMenuItem = jMenu.add(new JMenuItem("Save"));
        jMenuItem.setEnabled(this.pplxFilePath != null);
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPPLXRootPane.this.save(WPPLXRootPane.this.pplxFilePath);
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Save As..."));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPPLXRootPane.this.save(null);
            }
        });
        jMenu.addSeparator();
        jMenuItem = jMenu.add(new JMenuItem("Render System..."));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WRenderSystemDialog wRenderSystemDialog = WPPLXRootPane.this.getRenderSystemDialog();
                wRenderSystemDialog.setVisible(true);
                wRenderSystemDialog.toFront();
                wRenderSystemDialog.requestFocus();
            }
        });
        jMenu.addSeparator();
        jMenu.add(this.buildQuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        jMenuItem = jMenu.add(new JMenuItem("Developer Log..."));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.getWindowAncestor(WPPLXRootPane.this);
                WPPLXRootPane.this.logFrame.setVisible(true);
            }
        });
        jMenuBar.add(jMenu);
        jMenuBar.add(this.buildWindowMenu());
        this.setJMenuBar(jMenuBar);
    }

    private JComponent buildTools() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.totalLabel = new JLabel("0:00");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JLabel("Total:"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(8, 10, 8, 8);
        jPanel.add((Component)this.totalLabel, gridBagConstraints);
        return jPanel;
    }

    private void buildUI() {
        this.getContentPane().add((Component)this.buildTools(), "North");
        this.splitPane = new JSplitPane(0);
        this.splitPane.setDividerSize(5);
        this.splitPane.setResizeWeight(0.4);
        this.splitPane.setBorder(new EmptyBorder(0, 3, 0, 3));
        this.playlistTable = new WPlaylistTable(this.playlistModel);
        this.playlistTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!(listSelectionEvent.getSource() instanceof ListSelectionModel)) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                MediaEntry mediaEntry = null;
                int n2 = listSelectionModel.getMinSelectionIndex();
                if (n2 >= 0 && (n = WPPLXRootPane.this.playlistTable.convertRowIndexToModel(n2)) >= 0) {
                    PlaylistModel playlistModel = (PlaylistModel)WPPLXRootPane.this.playlistTable.getModel();
                    mediaEntry = playlistModel.getMediaEntry(n);
                }
                JPanel jPanel = WPPLXRootPane.this.emptyFeedPanel;
                if (mediaEntry != null && mediaEntry.feedPanel != null) {
                    jPanel = mediaEntry.feedPanel;
                }
                if (jPanel != WPPLXRootPane.this.currentFeedPanel) {
                    WPPLXRootPane.this.controlPanel.setSelected(mediaEntry);
                    WPPLXRootPane.this.panelScrollPane.setViewportView(jPanel);
                    WPPLXRootPane.this.currentFeedPanel = jPanel;
                }
            }
        });
        this.playlistTable.addPopupListener(new PopupListener(){

            @Override
            public void popupInvoked(PopupEvent popupEvent) {
                MediaEntry mediaEntry;
                if (!(popupEvent instanceof TablePopupEvent)) {
                    return;
                }
                if (!(popupEvent.getSource() instanceof WPlaylistTable)) {
                    return;
                }
                WPlaylistTable wPlaylistTable = (WPlaylistTable)popupEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = ((TablePopupEvent)popupEvent).getRow();
                int n2 = n < 0 ? -1 : wPlaylistTable.convertRowIndexToModel(n);
                MediaEntry mediaEntry2 = mediaEntry = n2 < 0 ? null : WPPLXRootPane.this.playlistModel.getMediaEntry(n2);
                if (mediaEntry != null) {
                    JMenuItem jMenuItem = jPopupMenu.add(new JMenuItem("Remove"));
                    jMenuItem.addActionListener(new AbstractAction(){
                        MediaEntry mediaEntry;

                        public AbstractAction init(MediaEntry mediaEntry) {
                            this.mediaEntry = mediaEntry;
                            return this;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WPPLXRootPane.this.controlPanel.ejectIfLoaded(this.mediaEntry);
                            WPPLXRootPane.this.playlistModel.removeFile(this.mediaEntry);
                            WPPLXRootPane.this.setUnsavedWork();
                        }
                    }.init(mediaEntry));
                } else {
                    jPopupMenu.add(WPPLXRootPane.this.buildFileAddFileItem());
                }
                jPopupMenu.show(wPlaylistTable, popupEvent.getX(), popupEvent.getY());
            }
        });
        this.playlistTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                    ListSelectionModel listSelectionModel = WPPLXRootPane.this.playlistTable.getSelectionModel();
                    int n = listSelectionModel.getMinSelectionIndex();
                    if (n < 0) {
                        return;
                    }
                    int n2 = WPPLXRootPane.this.playlistTable.convertRowIndexToModel(n);
                    if (n2 < 0) {
                        return;
                    }
                    PlaylistModel playlistModel = (PlaylistModel)WPPLXRootPane.this.playlistTable.getModel();
                    MediaEntry mediaEntry = playlistModel.getMediaEntry(n2);
                    if (mediaEntry != null) {
                        WPPLXRootPane.this.controlPanel.loadAndPlay(mediaEntry);
                    }
                }
            }
        });
        this.splitPane.setTopComponent(new JScrollPane(this.playlistTable));
        this.currentFeedPanel = this.emptyFeedPanel = new JPanel();
        this.panelScrollPane = new JScrollPane(this.emptyFeedPanel);
        this.splitPane.setBottomComponent(this.panelScrollPane);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.controlPanel = new WControlPanel(this.playlistModel){

            private int getViewRow(MediaEntry mediaEntry) {
                if (mediaEntry == null) {
                    ListSelectionModel listSelectionModel = WPPLXRootPane.this.playlistTable.getSelectionModel();
                    return listSelectionModel.getMinSelectionIndex();
                }
                PlaylistModel playlistModel = (PlaylistModel)WPPLXRootPane.this.playlistTable.getModel();
                int n = playlistModel.getEntryRow(mediaEntry);
                if (n < 0) {
                    return -1;
                }
                return WPPLXRootPane.this.playlistTable.convertRowIndexToView(n);
            }

            private MediaEntry getMediaEntry(int n, boolean bl) {
                if (n < 0) {
                    return null;
                }
                if (n >= WPPLXRootPane.this.playlistTable.getRowCount()) {
                    return null;
                }
                int n2 = WPPLXRootPane.this.playlistTable.convertRowIndexToModel(n);
                PlaylistModel playlistModel = (PlaylistModel)WPPLXRootPane.this.playlistTable.getModel();
                MediaEntry mediaEntry = playlistModel.getMediaEntry(n2);
                if (bl && mediaEntry != null) {
                    WPPLXRootPane.this.playlistTable.setRowSelectionInterval(n, n);
                }
                return mediaEntry;
            }

            @Override
            protected MediaEntry getNextEntry(MediaEntry mediaEntry, boolean bl) {
                int n = this.getViewRow(mediaEntry);
                if (n < 0) {
                    if (mediaEntry != null) {
                        return null;
                    }
                    int n2 = WPPLXRootPane.this.playlistTable.getRowCount();
                    if (n2 <= 0) {
                        return null;
                    }
                    n = 0;
                } else {
                    ++n;
                }
                return this.getMediaEntry(n, bl);
            }

            @Override
            protected MediaEntry getPrevEntry(MediaEntry mediaEntry, boolean bl) {
                int n = this.getViewRow(mediaEntry);
                if (n < 0) {
                    if (mediaEntry != null) {
                        return null;
                    }
                    int n2 = WPPLXRootPane.this.playlistTable.getRowCount();
                    if (n2 <= 0) {
                        return null;
                    }
                    n = n2 - 1;
                } else {
                    --n;
                }
                return this.getMediaEntry(n, bl);
            }

            @Override
            protected void logClear() {
                WPPLXRootPane.this.logFrame.clear();
                super.logClear();
            }

            @Override
            protected void logAppend(String string) {
                WPPLXRootPane.this.logFrame.append(string + "\n");
            }

            @Override
            protected void setRenderWorkLock(boolean bl) {
                if (WPPLXRootPane.this.renderSystemDialog == null) {
                    return;
                }
                WPPLXRootPane.this.renderSystemDialog.setWorkLock(bl);
            }

            @Override
            protected FlowProxyBuilder getRenderProxyBuilder() {
                if (WPPLXRootPane.this.renderSystemDialog == null) {
                    return null;
                }
                return WPPLXRootPane.this.renderSystemDialog.getRenderProxyBuilder();
            }
        };
        this.getContentPane().add((Component)this.controlPanel, "South");
    }

    public WPPLXRootPane(File file) throws ParsecException {
        this.pplxFilePath = file;
        this.logFrame = new WLogFrame();
        this.logFrame.pack();
        this.playlistModel = new PlaylistModel();
        this.playlistModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                WPPLXRootPane.this.updateTotalTime();
            }
        });
        this.buildMenu();
        this.buildUI();
        this.filenameChanged();
        if (file != null) {
            PPLXReader pPLXReader = PPLXReader.readFrom(file);
            Iterator<MediaSource> iterator = pPLXReader.getMediaIterator();
            while (iterator.hasNext()) {
                MediaEntry mediaEntry = new MediaEntry((SetupProvider)this.controlPanel, iterator.next());
                this.playlistModel.addMedia(mediaEntry);
            }
        }
    }

    public void addFile(File file) {
        try {
            MediaEntry mediaEntry = new MediaEntry((SetupProvider)this.controlPanel, file);
            this.playlistModel.addMedia(mediaEntry);
            this.setUnsavedWork();
        }
        catch (Throwable throwable) {
            String string = "Playlist File Entry Error";
            ParsecTools.showExceptionDialog(this, string, throwable);
        }
    }

    @Override
    public boolean loadSinkSetup(File file) {
        try {
            this.getRenderSystemDialog().loadFrom(file);
            return true;
        }
        catch (Throwable throwable) {
            String string = "Sink Configuration Error";
            ParsecTools.showExceptionDialog(this, string, throwable);
            return false;
        }
    }

    @Override
    public boolean confirmClose() {
        if (this.renderSystemDialog != null && !this.renderSystemDialog.confirmDiscard()) {
            return false;
        }
        if (this.unsavedWorkFlag) {
            Window window;
            if (this.renderSystemDialog != null) {
                this.renderSystemDialog.setVisible(false);
            }
            if ((window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null) {
                window.setVisible(true);
                window.toFront();
                window.requestFocus();
            }
            if (!this.showConfirmCloseMsg()) {
                return false;
            }
        }
        this.controlPanel.stop();
        return true;
    }

    public void setUnsavedWork() {
        this.unsavedWorkFlag = true;
        this.filenameChanged();
    }

    @Override
    public void dispose() {
        this.controlPanel.stop();
    }
}

