/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.remote.DRCArg;
import dexlogic.parsec.remote.DRCBatch;
import java.io.File;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;

public class PPLXWriter {
    private static void writePlugins(StringBuilder stringBuilder, String string, Iterable<MediaSource.Plugin> iterable) throws ParsecException {
        for (MediaSource.Plugin plugin : iterable) {
            String string2;
            boolean bl = plugin.style != null;
            String string3 = bl ? "plugin" : "copy";
            stringBuilder.append(string).append("<").append(string3);
            if (bl) {
                stringBuilder.append(" style='").append(plugin.style.trim()).append("'");
            }
            if (!plugin.routing.enabled) {
                stringBuilder.append(" enabled='false'");
            }
            if (plugin.routing.plugins.size() == 0 && (string2 = plugin.routing.patch) != null) {
                stringBuilder.append(" patch='").append(string2.trim()).append("'");
            }
            if (bl) {
                string2 = plugin.getSetupArgs();
                if (string2 != null) {
                    stringBuilder.append(" setup='").append(string2).append("'");
                }
                String string4 = plugin.getRPCArg();
                DRCBatch dRCBatch = null;
                try {
                    dRCBatch = DRCArg.parse(string4);
                }
                catch (ParsecException parsecException) {
                    parsecException.setDetails(string4);
                    throw parsecException;
                }
                String string5 = string4 = dRCBatch != null ? dRCBatch.toString() : null;
                if (string4 != null) {
                    String string6 = string + "    ";
                    string4 = string4.replaceAll("\n+", "\n" + string6);
                    stringBuilder.append("\n").append(string6);
                    stringBuilder.append("rpc='\n").append(string6).append(string4).append("'\n").append(string);
                }
            }
            if (plugin.routing.plugins.size() == 0) {
                stringBuilder.append(" />\n");
                continue;
            }
            stringBuilder.append(">\n");
            PPLXWriter.writePlugins(stringBuilder, string + "  ", plugin.routing.plugins);
            stringBuilder.append(string).append("</").append(string3).append(">\n");
        }
    }

    private static void writeJacks(StringBuilder stringBuilder, String string, Iterable<MediaSource.Jack> iterable) throws ParsecException {
        for (MediaSource.Jack jack : iterable) {
            String string2;
            stringBuilder.append(string).append("<jack");
            String string3 = ParsecTools.trimString(jack.jackName);
            if (string3 != null) {
                stringBuilder.append(" name='").append(string3).append("'");
            }
            if (!jack.routing.enabled) {
                stringBuilder.append(" enabled='false'");
            }
            if (jack.routing.plugins.size() == 0 && (string2 = jack.routing.patch) != null) {
                stringBuilder.append(" patch='").append(string2.trim()).append("'");
            }
            if ((string2 = jack.getSetupArgs()) != null) {
                stringBuilder.append(" setup='").append(string2).append("'");
            }
            if (jack.routing.plugins.size() == 0) {
                stringBuilder.append(" />\n");
                continue;
            }
            stringBuilder.append(">\n");
            PPLXWriter.writePlugins(stringBuilder, string + "  ", jack.routing.plugins);
            stringBuilder.append(string).append("</jack>\n");
        }
    }

    private static void writeTrunks(StringBuilder stringBuilder, String string, Iterable<MediaSource.Trunk> iterable) throws ParsecException {
        for (MediaSource.Trunk trunk : iterable) {
            String string2;
            String string3;
            stringBuilder.append(string).append("<trunk");
            String string4 = ParsecTools.trimString(trunk.trunkName);
            if (string4 != null) {
                stringBuilder.append(" name='").append(string4).append("'");
            }
            if (!trunk.enabled) {
                stringBuilder.append(" enabled='false'");
            }
            if ((string3 = ParsecTools.trimString(trunk.layout)) != null) {
                stringBuilder.append(" layout='").append(string3).append("'");
            }
            if ((string2 = trunk.getSetupArgs()) != null) {
                stringBuilder.append(" setup='").append(string2).append("'");
            }
            if (trunk.jacks.size() == 0) {
                stringBuilder.append(" />\n");
                continue;
            }
            stringBuilder.append(">\n");
            PPLXWriter.writeJacks(stringBuilder, string + "  ", trunk.jacks);
            stringBuilder.append(string).append("</trunk>\n");
        }
    }

    public static void writeTo(File file, Iterator<MediaSource> iterator) throws ParsecException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            Path path = file.toPath().toAbsolutePath().getParent();
            outputStreamWriter = new FileWriter(file);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<pplx version='1.0'>\n");
            while (iterator.hasNext()) {
                Path path2;
                MediaSource mediaSource = iterator.next();
                stringBuilder.append("  <entry>\n");
                URI uRI = mediaSource.getFeed().absoluteURI.normalize();
                String string = null;
                if (mediaSource.getFeed().originalPathFlag) {
                    if (mediaSource.getFeed().absolutePathFlag) {
                        string = uRI.toString();
                    } else if (path != null) {
                        path2 = path.relativize(Path.of(uRI));
                        string = path2.toString();
                    } else {
                        string = uRI.toString();
                    }
                } else if (uRI.getScheme().equals("file")) {
                    path2 = Path.of(uRI);
                    if (path != null && path2.startsWith(path)) {
                        Path path3 = path.relativize(path2);
                        string = path3.toString();
                    } else {
                        string = uRI.toString();
                    }
                } else {
                    string = uRI.toString();
                }
                stringBuilder.append("    <source uri='").append(string).append("'>\n");
                PPLXWriter.writeTrunks(stringBuilder, "      ", mediaSource.getFeed().trunks);
                stringBuilder.append("    </source>\n");
                stringBuilder.append("  </entry>\n");
            }
            stringBuilder.append("</pplx>\n");
            outputStreamWriter.write(stringBuilder.toString());
            outputStreamWriter.close();
            outputStreamWriter = null;
        }
        catch (IOError | IOException throwable) {
            GenericParsecException genericParsecException = new GenericParsecException(throwable.getMessage());
            genericParsecException.initCause(throwable);
            throw genericParsecException;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

