/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PPLXReader {
    private File pplxFilePath;
    private ArrayList<MediaSource> mediaList = new ArrayList();

    private PPLXReader() {
    }

    private void dumpNode(int n, Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        String string = stringBuilder.toString();
        System.out.println(string + node.getNodeType() + "  " + node.getNodeName());
        if (node.hasChildNodes()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.dumpNode(n + 1, node2);
            }
        }
    }

    private String readPatch(String string, MediaSource.Routing routing) throws ParsecException {
        int n;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            if (routing.plugins.size() == 0) {
                return string;
            }
            return null;
        }
        String[] stringArray = string.split(",", -1);
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        if (stringArray.length == 1 && routing.plugins.size() == 0) {
            return stringArray[0];
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            if (stringArray[n].length() == 0) continue;
            MediaSource.Plugin plugin = new MediaSource.Plugin();
            routing.plugins.add(0, plugin);
            plugin.routing.patch = stringArray[n];
        }
        return null;
    }

    private void buildRouting(Node node, MediaSource.Routing routing) throws ParsecException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("copy")) {
                this.buildCopy(node2, routing);
                continue;
            }
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("plugin")) {
                this.buildPlugin(node2, routing);
                continue;
            }
            if (node2.getNodeType() == 3) {
                String string = node2.getNodeValue();
                if (string == null || string.trim().length() == 0) continue;
                throw new ParsecException("Invalid schema");
            }
            throw new ParsecException("Invalid schema");
        }
    }

    private void buildCopy(Node node, MediaSource.Routing routing) throws ParsecException {
        String string = null;
        boolean bl = true;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("patch")) {
                string = node2.getNodeValue();
                continue;
            }
            if (string2.equals("enabled")) {
                bl = node2.getNodeValue().equals("true");
                continue;
            }
            throw new ParsecException("Invalid attribute: " + string2);
        }
        MediaSource.Plugin plugin = new MediaSource.Plugin();
        routing.plugins.add(plugin);
        plugin.routing.enabled = bl;
        this.buildRouting(node, plugin.routing);
        plugin.routing.patch = this.readPatch(string, plugin.routing);
    }

    private void buildPlugin(Node node, MediaSource.Routing routing) throws ParsecException {
        String string = null;
        String string2 = null;
        boolean bl = true;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            String string4 = node2.getNodeName();
            if (string4.equals("style")) {
                string = node2.getNodeValue();
                continue;
            }
            if (string4.equals("patch")) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (string4.equals("enabled")) {
                bl = node2.getNodeValue().equals("true");
                continue;
            }
            if (string4.equals("rpc")) {
                string3 = node2.getNodeValue();
                continue;
            }
            throw new ParsecException("Invalid attribute: " + string4);
        }
        if (string == null) {
            throw new ParsecException("style");
        }
        MediaSource.Plugin plugin = new MediaSource.Plugin(string3);
        routing.plugins.add(plugin);
        plugin.style = string;
        plugin.routing.enabled = bl;
        this.buildRouting(node, plugin.routing);
        plugin.routing.patch = this.readPatch(string2, plugin.routing);
    }

    private void buildJack(Node node, MediaSource.Trunk trunk) throws ParsecException {
        String string = null;
        String string2 = null;
        boolean bl = true;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            String string4 = node2.getNodeName();
            if (string4.equals("name")) {
                string = node2.getNodeValue();
                continue;
            }
            if (string4.equals("setup")) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (string4.equals("enabled")) {
                bl = node2.getNodeValue().equals("true");
                continue;
            }
            if (string4.equals("patch")) {
                string3 = node2.getNodeValue();
                continue;
            }
            throw new ParsecException("Invalid attribute: " + string4);
        }
        MediaSource.Jack jack = trunk.addJack(string, string2);
        jack.routing.enabled = bl;
        this.buildRouting(node, jack.routing);
        jack.routing.patch = this.readPatch(string3, jack.routing);
    }

    private void buildTrunk(Node node, MediaSource mediaSource) throws ParsecException {
        String string;
        Node node2;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        String string4 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = namedNodeMap.item(i);
            string = node2.getNodeName();
            if (string.equals("name")) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (string.equals("setup")) {
                string3 = node2.getNodeValue();
                continue;
            }
            if (string.equals("enabled")) {
                bl = node2.getNodeValue().equals("true");
                continue;
            }
            if (string.equals("layout")) {
                string4 = node2.getNodeValue();
                continue;
            }
            throw new ParsecException("Invalid attribute: " + string);
        }
        MediaSource.Trunk trunk = mediaSource.getFeed().addTrunk(string2, string3);
        trunk.enabled = bl;
        trunk.layout = string4;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("jack")) {
                this.buildJack(node2, trunk);
                continue;
            }
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
                if (string == null || string.trim().length() == 0) continue;
                throw new ParsecException("Invalid schema");
            }
            throw new ParsecException("Invalid schema");
        }
    }

    private MediaSource buildSource(Node node) throws ParsecException {
        Object object;
        URI uRI;
        Object object2;
        Object object3;
        String string = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap == null ? 0 : namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = namedNodeMap.item(i);
            object2 = object3.getNodeName();
            if (!((String)object2).equals("uri")) {
                throw new ParsecException("Invalid attribute: " + (String)object2);
            }
            string = object3.getNodeValue();
        }
        if (string == null) {
            throw new ParsecException("No URI");
        }
        try {
            uRI = new URI(string);
            if (uRI.isOpaque()) {
                object3 = "URI syntax error: " + string;
                throw new GenericParsecException((String)object3);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            object2 = "URI syntax error: " + string;
            GenericParsecException genericParsecException = new GenericParsecException((String)object2);
            genericParsecException.setDetails(ParsecTools.getTraceDetails(uRISyntaxException));
            throw genericParsecException;
        }
        object3 = uRI.isAbsolute() ? uRI.normalize() : this.pplxFilePath.toURI().resolve(uRI).normalize();
        object2 = ((URI)object3).getScheme();
        if (object2 == null) {
            String string2 = "No scheme on absolute URI" + string;
            throw new GenericParsecException(string2);
        }
        if (((String)object2).equals("file")) {
            if (((URI)object3).getAuthority() != null) {
                String string3 = "URI syntax error: " + string;
                throw new GenericParsecException(string3);
            }
            object = new File(((URI)object3).getPath());
            if (!((File)object).exists() || !((File)object).canRead()) {
                String string4 = "Media file access error: " + ((File)object).getName();
                GenericParsecException genericParsecException = new GenericParsecException(string4);
                genericParsecException.setHints("Absolute path: \n" + ((File)object).getAbsolutePath());
                throw genericParsecException;
            }
        }
        object = new MediaSource((URI)object3);
        ((MediaSource)object).getFeed().originalPathFlag = true;
        ((MediaSource)object).getFeed().absolutePathFlag = uRI.isAbsolute();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("trunk")) {
                this.buildTrunk(node2, (MediaSource)object);
                continue;
            }
            if (node2.getNodeType() == 3) {
                String string5 = node2.getNodeValue();
                if (string5 == null || string5.trim().length() == 0) continue;
                throw new ParsecException("Invalid schema");
            }
            throw new ParsecException("Invalid schema");
        }
        return object;
    }

    private void buildEntry(Node node) throws ParsecException {
        MediaSource mediaSource = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("source")) {
                if (mediaSource != null) {
                    throw new ParsecException("Duplicate source element");
                }
                mediaSource = this.buildSource(node2);
                continue;
            }
            if (node2.getNodeType() == 3) {
                String string = node2.getNodeValue();
                if (string == null || string.trim().length() == 0) continue;
                throw new ParsecException("Invalid schema");
            }
            throw new ParsecException("Invalid schema");
        }
        if (mediaSource != null) {
            this.mediaList.add(mediaSource);
        }
    }

    private void buildMediaList(Node node) throws ParsecException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("entry")) {
                this.buildEntry(node2);
                continue;
            }
            if (node2.getNodeType() == 3) {
                String string = node2.getNodeValue();
                if (string == null || string.trim().length() == 0) continue;
                throw new ParsecException("Invalid schema");
            }
            throw new ParsecException("Invalid schema");
        }
    }

    private Document parseDoc(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().normalize();
        return document;
    }

    public Iterator<MediaSource> getMediaIterator() {
        return this.mediaList.iterator();
    }

    public static PPLXReader readFrom(File file) throws ParsecException {
        PPLXReader pPLXReader = new PPLXReader();
        pPLXReader.pplxFilePath = file;
        try {
            String string;
            if (file != null && (string = Files.readString(file.toPath())) != null && (string = string.trim()).length() != 0) {
                if (!string.startsWith("<pplx") || !string.endsWith("</pplx>")) {
                    throw new ParsecException("Invalid XML, root schema: <pplx>...</pplx>");
                }
                Document document = pPLXReader.parseDoc(string);
                Element element = document.getDocumentElement();
                if (!element.getNodeName().equals("pplx")) {
                    throw new ParsecException("Invalid XML, root element: " + element.getNodeName());
                }
                pPLXReader.buildMediaList(element);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            GenericParsecException genericParsecException = new GenericParsecException(exception.getMessage());
            genericParsecException.initCause(exception);
            throw genericParsecException;
        }
        return pPLXReader;
    }
}

