/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.idn.IDNSource;
import dexlogic.parsec.imsp.IMSPSource;
import dexlogic.parsec.pplx.WFeedPanel;
import dexlogic.parsec.wav.WAVSource;
import java.io.File;
import java.net.URI;

class MediaEntry {
    URI uri;
    String displayName;
    MediaSource mediaSource;
    WFeedPanel feedPanel;

    /*
     * Enabled aggressive block sorting
     */
    MediaEntry(SetupProvider setupProvider, MediaSource mediaSource) throws ParsecException {
        if (mediaSource == null) {
            throw new InternalParsecException("No source setup");
        }
        this.mediaSource = mediaSource;
        if (mediaSource.getFeed().absoluteURI == null) {
            throw new InternalParsecException("No URI");
        }
        this.uri = mediaSource.getFeed().absoluteURI;
        String string = this.uri.getScheme();
        if (string == null || string.equals("file")) {
            String string2;
            this.displayName = new File(this.uri.getPath()).getName();
            int n = this.displayName.lastIndexOf(46);
            String string3 = string2 = n < 0 ? "" : this.displayName.substring(n);
            if (string2.equalsIgnoreCase(".idn")) {
                mediaSource.getFeed().style = "IDN";
                IDNSource.checkSource(mediaSource);
            } else {
                if (!string2.equalsIgnoreCase(".wav")) {
                    String string4 = "Can't handle filename extension of " + this.displayName;
                    throw new GenericParsecException(string4);
                }
                mediaSource.getFeed().style = "WAV";
                WAVSource.checkSource(mediaSource);
            }
        } else {
            if (!string.equals("imsp")) {
                String string5 = "Can't handle URI scheme of " + this.uri.toString();
                throw new GenericParsecException(string5);
            }
            this.displayName = this.uri.toString();
            mediaSource.getFeed().style = "pull";
            IMSPSource.checkSource(mediaSource);
        }
        this.feedPanel = new WFeedPanel(setupProvider, mediaSource);
    }

    MediaEntry(SetupProvider setupProvider, File file) throws ParsecException {
        String string;
        this.uri = file.toURI();
        this.displayName = file.getName();
        int n = this.displayName.lastIndexOf(46);
        String string2 = string = n < 0 ? "" : this.displayName.substring(n);
        if (string.equalsIgnoreCase(".idn")) {
            this.mediaSource = IDNSource.createSource(file);
        } else if (string.equalsIgnoreCase(".wav")) {
            this.mediaSource = WAVSource.createSource(file);
        } else {
            String string3 = "Can't handle filename extension of " + this.displayName;
            throw new GenericParsecException(string3);
        }
        if (this.mediaSource == null) {
            throw new InternalParsecException("No media source");
        }
        this.feedPanel = new WFeedPanel(setupProvider, this.mediaSource);
    }

    long getDurationMS() {
        if (this.mediaSource == null) {
            return -1L;
        }
        if (this.mediaSource.getFeed().trunks == null) {
            return -1L;
        }
        long l = 0L;
        for (MediaSource.Trunk trunk : this.mediaSource.getFeed().trunks) {
            if (!trunk.enabled) continue;
            if (trunk.durationMS < 0L) {
                return -1L;
            }
            if (trunk.durationMS <= l) continue;
            l = trunk.durationMS;
        }
        return l;
    }
}

