/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.plj;

import dexlogic.io.idn.IDNTools;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.WLogFrame;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.plj.DLNUnitID;
import dexlogic.parsec.plj.FeedEntry;
import dexlogic.parsec.plj.RenderSetup;
import dexlogic.parsec.plj.WFeedListPanel;
import dexlogic.parsec.plj.WPLJContentPane;
import dexlogic.parsec.routes.DXCLogEvent;
import dexlogic.parsec.routes.FlowEventListener;
import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.FlowProxy;
import dexlogic.parsec.routes.RPCInvokeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WPLJRootPane
extends WParsecRootPane {
    private WLogFrame logFrame;
    private RenderSetup renderSetup;
    private FlowManager flowManager;
    private FlowProxy loadedProxy;
    private JCheckBoxMenuItem audioCheck;
    private JTextArea textArea;
    private JToggleButton stopButton;
    private JToggleButton playButton;
    private JButton findButton;
    private JButton applyButton;
    private WFeedListPanel feedListPanel;
    private HashSet<FeedEntry> feedSet;
    private boolean playingFlag = false;

    /*
     * WARNING - void declaration
     */
    private String buildSourceXML(int n) {
        void var5_8;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        for (FeedEntry object32 : this.feedSet) {
            if (!object32.enabled) continue;
            object2 = "";
            if (object32.patch == null || ((String)(object = object32.patch.trim())).length() == 0) continue;
            object2 = " name='" + (String)object + "'";
            object32.serviceID = n2;
            String string = "serviceID:\"" + n2 + "\"; serviceType:\"lapro\"";
            String string2 = " setup=' " + string + " '";
            stringBuilder.append("        <jack" + (String)object2 + string2 + " />\n");
            ++n2;
        }
        Object object4 = "";
        if (n != 0) {
            object4 = (String)object4 + "port:\"" + n + "\"; ";
        }
        object4 = ((String)object4).trim();
        String string = "";
        if (((String)object4).length() > 0) {
            String string3 = " setup=' " + (String)object4 + " '";
        }
        object = "  <sourceDriver driverID='IDNServer'>\n    <feed style='IDN-RT' name='#1' " + (String)var5_8 + " >\n      <trunk setup='clientGroup:\"*\"'>\n";
        object2 = "      </trunk>\n    </feed>\n  </sourceDriver>\n";
        stringBuilder.insert(0, (String)object);
        stringBuilder.append((String)object2);
        if (this.audioCheck.getState()) {
            stringBuilder.append("  <sourceDriver driverID='SysInlet' name='inlet'>\n    <feed style='PCM' name='feed2'>\n      <trunk>\n        <jack name='default' patch='stdSound' />\n      </trunk>\n    </feed>\n  </sourceDriver>\n");
        }
        stringBuilder.insert(0, "<dxcSetup>\n");
        stringBuilder.append("</dxcSetup>");
        return stringBuilder.toString();
    }

    private void play() {
        if (this.playingFlag) {
            return;
        }
        int n = 0;
        this.logFrame.clear();
        try {
            this.flowManager.createEntity();
            this.flowManager.loadProxy(this.renderSetup);
            this.loadedProxy = this.flowManager.loadProxy(this.buildSourceXML(n));
            this.flowManager.play(null);
            for (FeedEntry feedEntry : this.feedSet) {
                if (!feedEntry.enabled) continue;
                feedEntry.start(n);
            }
            this.playingFlag = true;
        }
        catch (Throwable throwable) {
            this.flowManager.destroyEntity();
            ParsecTools.showExceptionDialog(this, "Playback Error", throwable);
            this.stopButton.setSelected(true);
            this.playingFlag = false;
        }
    }

    private void stop() {
        if (!this.playingFlag) {
            return;
        }
        try {
            for (FeedEntry feedEntry : this.feedSet) {
                feedEntry.stopAll();
            }
            this.flowManager.stop(null);
            this.loadedProxy = null;
            this.flowManager.destroyEntity();
            this.playingFlag = false;
        }
        catch (Throwable throwable) {
            this.flowManager.destroyEntity();
            ParsecTools.showExceptionDialog(this, "Playback Error", throwable);
            this.stopButton.setSelected(true);
            this.playingFlag = false;
        }
    }

    private void updateFeeds(HashSet<FeedEntry> hashSet) {
        this.feedSet = hashSet;
        this.feedListPanel.updateFeeds(hashSet);
        this.feedListPanel.revalidate();
    }

    private void sinkSetupChanged() {
        this.applyButton.setBackground(Color.YELLOW);
    }

    private void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.buildFileMenu();
        jMenu.add(this.buildFileNewMenu());
        jMenu.add(this.buildFileOpenItem());
        jMenu.add(this.buildFileCloseItem());
        jMenu.addSeparator();
        jMenu.add(this.buildQuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        this.audioCheck = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Include Audio"));
        this.audioCheck.setState(true);
        jMenu.addSeparator();
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Developer Log..."));
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPLJRootPane.this.logFrame.setVisible(true);
            }
        });
        jMenuBar.add(jMenu);
        jMenuBar.add(this.buildWindowMenu());
        this.setJMenuBar(jMenuBar);
    }

    private ImageIcon getIconImage(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private JToggleButton createCtlToggleButton(String string) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(this.getIconImage(string));
        jToggleButton.setMargin(new Insets(5, 8, 5, 8));
        jToggleButton.setBorderPainted(false);
        return jToggleButton;
    }

    private JComponent buildControlUI() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.stopButton = this.createCtlToggleButton("/icons/stop-button.png");
        buttonGroup.add(this.stopButton);
        this.stopButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPLJRootPane.this.stop();
            }
        });
        this.playButton = this.createCtlToggleButton("/icons/play-button.png");
        buttonGroup.add(this.playButton);
        this.playButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPLJRootPane.this.play();
            }
        });
        this.stopButton.setSelected(true);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.stopButton);
        jPanel.add(this.playButton);
        return jPanel;
    }

    private JComponent buildSetupUI() {
        this.findButton = new JButton("Find Feeds");
        this.findButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ScanThread().run();
            }
        });
        JButton jButton = new JButton("Load Sinks...");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                int n = jFileChooser.showOpenDialog(WPLJRootPane.this);
                if (n != 0) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                if (file.exists()) {
                    try {
                        byte[] byArray = Files.readAllBytes(file.toPath());
                        WPLJRootPane.this.textArea.setText(new String(byArray, StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.applyButton = new JButton("Apply Sinks");
        this.applyButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WPLJRootPane.this.renderSetup.setSinkSetup(WPLJRootPane.this.textArea.getText());
                    WPLJRootPane.this.applyButton.setBackground(null);
                }
                catch (Throwable throwable) {
                    Component component = (Component)actionEvent.getSource();
                    ParsecTools.showExceptionDialog(component, "Sink Configuration Error", throwable);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.findButton);
        jPanel.add(jButton);
        jPanel.add(this.applyButton);
        return jPanel;
    }

    private void buildUI() {
        this.textArea = new JTextArea(20, 80);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        this.textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                WPLJRootPane.this.sinkSetupChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                WPLJRootPane.this.sinkSetupChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                WPLJRootPane.this.sinkSetupChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.buildControlUI(), "West");
        jPanel.add((Component)this.buildSetupUI(), "East");
        jPanel.setBackground(jPanel.getBackground().darker());
        this.feedListPanel = new WFeedListPanel(this.renderSetup);
        this.feedListPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.feedListPanel, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(8, 8, 8, 8));
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel3, "Center");
    }

    @Override
    protected Container createContentPane() {
        WPLJContentPane wPLJContentPane = new WPLJContentPane(this);
        wPLJContentPane.setName(this.getName() + ".contentPane");
        return wPLJContentPane;
    }

    public WPLJRootPane(File file) throws ParsecException {
        this.setTitle("Parsec Laser Jockey");
        this.logFrame = new WLogFrame();
        this.logFrame.pack();
        this.renderSetup = new RenderSetup();
        this.flowManager = new FlowManager(new FlowEventListener(){

            @Override
            public void flowLogPosted(DXCLogEvent dXCLogEvent) {
                WPLJRootPane.this.logFrame.append(dXCLogEvent.getString() + "\n");
            }

            public void flowInfoPosted(RPCInvokeEvent rPCInvokeEvent) {
            }
        });
        this.feedSet = new HashSet();
        this.buildMenu();
        this.buildUI();
    }

    @Override
    public void dispose() {
        this.stop();
    }

    class ScanThread
    extends Thread {
        ScanThread() {
        }

        private FeedEntry buildFeed(ByteBuffer byteBuffer) {
            if (byteBuffer.remaining() < 4) {
                return null;
            }
            if ((byteBuffer.get() & 0xFF) != 17) {
                return null;
            }
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.get();
            if (byteBuffer.remaining() < 40) {
                return null;
            }
            if ((byteBuffer.get() & 0xFF) < 40) {
                return null;
            }
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.get();
            int n = byteBuffer.get() & 0xFF;
            if (n > 15) {
                return null;
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            for (int i = 0; i < 15 - n; ++i) {
                byteBuffer.get();
            }
            DLNUnitID dLNUnitID = new DLNUnitID(byArray);
            String string = IDNTools.readStringField(byteBuffer, 20);
            return new FeedEntry(dLNUnitID, string);
        }

        private ArrayList<InetAddress> getAddressList() throws IOException {
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress inetAddress;
                    if (interfaceAddress == null || interfaceAddress.getAddress() == null || (inetAddress = interfaceAddress.getBroadcast()) == null) continue;
                    arrayList.add(inetAddress);
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashSet<FeedEntry> doScan() {
            DatagramChannel datagramChannel = null;
            Selector selector = null;
            HashSet<FeedEntry> hashSet = new HashSet<FeedEntry>();
            try {
                long l;
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
                selector = Selector.open();
                datagramChannel = DatagramChannel.open();
                datagramChannel.socket().setBroadcast(true);
                datagramChannel.configureBlocking(false);
                datagramChannel.register(selector, 1);
                byteBuffer.clear();
                byteBuffer.put((byte)16);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.limit(byteBuffer.position());
                ArrayList<InetAddress> arrayList = this.getAddressList();
                for (InetAddress inetAddress : arrayList) {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, 7272);
                    byteBuffer.rewind();
                    if (datagramChannel.send(byteBuffer, inetSocketAddress) > 0) continue;
                    throw new IOException("Insufficient send buffer");
                }
                long l2 = 500L;
                long l3 = System.currentTimeMillis();
                block18: while ((l = l2 - (System.currentTimeMillis() - l3)) > 0L) {
                    selector.select(l);
                    Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block18;
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        SelectableChannel selectableChannel = selectionKey.channel();
                        if (selectableChannel != datagramChannel) continue;
                        byteBuffer.clear();
                        SocketAddress socketAddress = datagramChannel.receive(byteBuffer);
                        byteBuffer.flip();
                        FeedEntry feedEntry = this.buildFeed(byteBuffer);
                        if (feedEntry == null || !(socketAddress instanceof InetSocketAddress)) continue;
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                        feedEntry.remoteAddress = inetSocketAddress.getAddress();
                        hashSet.add(feedEntry);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (selector != null && selector.isOpen()) {
                    try {
                        selector.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (datagramChannel != null && datagramChannel.isOpen()) {
                    try {
                        datagramChannel.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return hashSet;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WPLJRootPane.this.findButton.setEnabled(false);
                }
            });
            try {
                HashSet<FeedEntry> hashSet = this.doScan();
                SwingUtilities.invokeLater(new Runnable(){
                    private HashSet<FeedEntry> feedSet;

                    public Runnable init(HashSet<FeedEntry> hashSet) {
                        this.feedSet = hashSet;
                        return this;
                    }

                    @Override
                    public void run() {
                        WPLJRootPane.this.updateFeeds(this.feedSet);
                    }
                }.init(hashSet));
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WPLJRootPane.this.findButton.setEnabled(true);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

