/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.plj;

import dexlogic.parsec.plj.DLNUnitID;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class FeedEntry {
    private static final int DLN_FEED_PORT = 7272;
    private static final int DLNCMD_DRAINROUTE_REQUEST = 120;
    private static final int DLNCMD_DRAINROUTE_RESPONSE = 121;
    private static final int DLNVAL_BRIDGETYPE_VOID = 0;
    private static final int DLNVAL_BRIDGETYPE_IDNBRT_IPV4 = 17;
    private static final int DLNVAL_BRIDGETYPE_IDNHELLO_IPV4 = 33;
    private static final int DLNVAL_BRIDGETYPE_IDNHELLO_UNITID = 35;
    private static final int DLNVAL_DRAINCMD_START = 129;
    private static final int DLNVAL_DRAINCMD_STOP = 130;
    private static final int DLNVAL_DRAINCMD_VERIFY = 131;
    private static final int DLNFLG_DRAINROUTE_PERSIST = 128;
    private static final int DLNFLG_DRAIN_CAPTUREID_WILDCARD = 2;
    private static final int DLNFLG_DRAIN_SERVICEID_WILDCARD = 1;
    public DLNUnitID unitID;
    public String hostName;
    public InetAddress remoteAddress;
    public boolean enabled;
    public String patch;
    public int serviceID;

    private static DrainRoute buildRoute(int n, int n2, int n3) throws IOException {
        DrainRoute drainRoute = new DrainRoute();
        drainRoute.cmd = 129;
        drainRoute.flags = 2;
        drainRoute.captureID = 0;
        drainRoute.serviceID = n3;
        drainRoute.bridgeType = 33;
        drainRoute.port = n2;
        return drainRoute;
    }

    private static DrainRoute buildStopAll() throws IOException {
        DrainRoute drainRoute = new DrainRoute();
        drainRoute.cmd = 130;
        drainRoute.flags = 3;
        drainRoute.bridgeType = 0;
        return drainRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendRouteRequests(ArrayList<RouteRequest> arrayList) throws IOException {
        try (DatagramSocket datagramSocket = null;){
            datagramSocket = new DatagramSocket();
            int n = 0;
            DatagramPacket[] datagramPacketArray = new DatagramPacket[arrayList.size()];
            for (RouteRequest routeRequest : arrayList) {
                byte[] byArray = routeRequest.buildPacket();
                InetAddress inetAddress = routeRequest.feedAddress;
                datagramPacketArray[n++] = new DatagramPacket(byArray, byArray.length, inetAddress, 7272);
            }
            for (n = 0; n < datagramPacketArray.length; ++n) {
                datagramSocket.send(datagramPacketArray[n]);
            }
        }
    }

    public FeedEntry(DLNUnitID dLNUnitID, String string) {
        this.unitID = dLNUnitID;
        this.hostName = string;
        this.enabled = true;
    }

    public void start(int n) throws IOException {
        ArrayList<RouteRequest> arrayList = new ArrayList<RouteRequest>();
        ArrayList<DrainRoute> arrayList2 = new ArrayList<DrainRoute>();
        arrayList2.add(FeedEntry.buildRoute(1, n, this.serviceID));
        RouteRequest routeRequest = new RouteRequest();
        routeRequest.feedAddress = this.remoteAddress;
        routeRequest.drainRoutes = arrayList2;
        arrayList.add(routeRequest);
        FeedEntry.sendRouteRequests(arrayList);
    }

    public void stopAll() throws IOException {
        ArrayList<RouteRequest> arrayList = new ArrayList<RouteRequest>();
        ArrayList<DrainRoute> arrayList2 = new ArrayList<DrainRoute>();
        arrayList2.add(FeedEntry.buildStopAll());
        RouteRequest routeRequest = new RouteRequest();
        routeRequest.feedAddress = this.remoteAddress;
        routeRequest.drainRoutes = arrayList2;
        arrayList.add(routeRequest);
        FeedEntry.sendRouteRequests(arrayList);
    }

    public int hashCode() {
        return this.unitID.hashCode();
    }

    public boolean equals(Object object) {
        return this.unitID.equals(object);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitID.toString());
        if (this.hostName != null && this.hostName.length() > 0) {
            stringBuilder.append("(").append(this.hostName).append(")");
        }
        stringBuilder.append(" at ").append(this.remoteAddress.toString());
        return stringBuilder.toString();
    }

    public static class RouteRequest {
        public InetAddress feedAddress;
        public ArrayList<DrainRoute> drainRoutes;

        public byte[] buildPacket() throws IOException {
            int n = this.drainRoutes.size();
            int n2 = 4 + n * 28;
            if (n > 1) {
                n2 += 4;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            byteBuffer.put((byte)120);
            byteBuffer.put((byte)0);
            byteBuffer.putShort((short)4660);
            if (n > 1) {
                byteBuffer.put((byte)4);
                byteBuffer.put((byte)n);
                byteBuffer.putShort((short)0);
            }
            for (DrainRoute drainRoute : this.drainRoutes) {
                drainRoute.writeStruct(byteBuffer);
            }
            return byteBuffer.array();
        }
    }

    public static class DrainRoute {
        public int cmd;
        public int flags;
        public int captureID;
        public int serviceID;
        public int bridgeType;
        public int port;
        byte[] address;

        public void writeStruct(ByteBuffer byteBuffer) throws IOException {
            byteBuffer.put((byte)28);
            byteBuffer.put((byte)this.cmd);
            byteBuffer.put((byte)this.flags);
            byteBuffer.put((byte)this.captureID);
            byteBuffer.put((byte)this.serviceID);
            byteBuffer.put((byte)this.bridgeType);
            byteBuffer.putShort((short)this.port);
            for (int i = 0; i < 20; ++i) {
                if (this.address != null && i < this.address.length) {
                    byteBuffer.put(this.address[i]);
                    continue;
                }
                byteBuffer.put((byte)0);
            }
        }
    }
}

