/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pdcx;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WSystemPanel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Files;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDCXReader {
    private SetupProvider setupProvider;
    private WSystemPanel sourceSystemPanel;
    private WSystemPanel renderSystemPanel;

    private PDCXReader() {
    }

    private ConfigSchema.Element findElementSchema(Node node, ConfigSchema.Element element) throws ParsecException {
        if (node.getNodeType() == 3) {
            String string = node.getNodeValue();
            if (string == null || string.strip().length() == 0) {
                return null;
            }
            throw new ParsecException("Invalid text: " + string);
        }
        if (node.getNodeType() != 1) {
            throw new ParsecException("Invalid schema: " + node);
        }
        String string = node.getNodeName();
        ConfigSchema.Element[] elementArray = element.getChildSchemas();
        int n = elementArray == null ? 0 : elementArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigSchema.Element element2;
            Node node2;
            ConfigSchema.Element element3 = elementArray[i];
            if (element3 == null || !element3.getName().equals(string) || (element3 instanceof ConfigSchema.Driver ? (node2 = node.getAttributes().getNamedItem("driverID")) == null || !((ConfigSchema.Driver)(element2 = (ConfigSchema.Driver)element3)).getDriverID().equals(node2.getNodeValue()) : (element3 instanceof ConfigSchema.Feed ? (node2 = node.getAttributes().getNamedItem("style")) == null || !((ConfigSchema.StyledElement)(element2 = (ConfigSchema.Feed)element3)).getStyle().equals(node2.getNodeValue()) : element3 instanceof ConfigSchema.Module && ((node2 = node.getAttributes().getNamedItem("style")) == null || !((ConfigSchema.StyledElement)(element2 = (ConfigSchema.Module)element3)).getStyle().equals(node2.getNodeValue()))))) continue;
            return element3;
        }
        throw new ParsecException("Invalid element: " + string);
    }

    private void loadCopies(WConfigPanel wConfigPanel, String string) throws ParsecException {
        String[] stringArray = string.split(",", -1);
        if (stringArray.length == 1) {
            wConfigPanel.putAttrib("patch", stringArray[0].strip());
            return;
        }
        ConfigSchema.Element element = wConfigPanel.getElementSchema();
        ConfigSchema.Element element2 = element.getChildSchema("plugin");
        if (element2 == null) {
            StringBuilder stringBuilder = new StringBuilder(element.getName());
            stringBuilder.append(": Unexpected patch '").append(string).append("'");
            stringBuilder.append(", element doesn't support plugins.");
            throw new ParsecException(stringBuilder.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            WConfigPanel wConfigPanel2 = WConfigPanel.createPanel(this.setupProvider, element2);
            wConfigPanel2.putAttrib("patch", stringArray[i].strip());
            wConfigPanel.addChildPanel(wConfigPanel2);
        }
    }

    private void loadFork(WConfigPanel wConfigPanel, String string) throws ParsecException {
        ConfigSchema.Element element = wConfigPanel.getElementSchema();
        ConfigSchema.Element element2 = element.getChildSchema("branch");
        if (element2 == null) {
            StringBuilder stringBuilder = new StringBuilder(element.getName());
            stringBuilder.append(": Unexpected fork '").append(string).append("'");
            stringBuilder.append(", element doesn't support branches.");
            throw new ParsecException(stringBuilder.toString());
        }
        String[] stringArray = string.split("\\|", -1);
        for (int i = 0; i < stringArray.length; ++i) {
            WConfigPanel wConfigPanel2 = WConfigPanel.createPanel(this.setupProvider, element2);
            this.loadCopies(wConfigPanel2, stringArray[i]);
            wConfigPanel.addChildPanel(wConfigPanel2);
        }
    }

    private WConfigPanel buildPanel(Node node, ConfigSchema.Element element) throws ParsecException {
        Object object;
        WConfigPanel wConfigPanel = WConfigPanel.createPanel(this.setupProvider, element);
        if (wConfigPanel == null) {
            throw new InternalParsecException("Failed to create a panel for the element");
        }
        String string = null;
        String string2 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            object = element.getAttribs();
            int n = object == null ? 0 : ((ConfigSchema.Attrib[])object).length;
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node2 = namedNodeMap.item(i);
                String string3 = node2.getNodeName();
                if (string3 == null || string3.length() <= 0) continue;
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                        StringBuilder stringBuilder = new StringBuilder(element.getName());
                        stringBuilder.append(": Unexpected attribute '").append(string3).append("'");
                        throw new ParsecException(stringBuilder.toString());
                    }
                    if (((ConfigSchema.Attrib)object[n3]).getName().equals(string3)) break;
                    ++n3;
                }
                String string4 = node2.getNodeValue();
                if (string4 == null) {
                    StringBuilder stringBuilder = new StringBuilder(element.getName());
                    stringBuilder.append(", attribute ").append(string3);
                    stringBuilder.append(": Unexpected value of 'null'");
                    throw new InternalParsecException(stringBuilder.toString());
                }
                if (string3.equals("patch")) {
                    string = string4;
                    continue;
                }
                if (string3.equals("fork")) {
                    string2 = string4;
                    continue;
                }
                try {
                    wConfigPanel.putAttrib(string3, string4);
                    continue;
                }
                catch (Throwable throwable) {
                    GenericParsecException genericParsecException = new GenericParsecException(throwable.getMessage());
                    genericParsecException.initCause(throwable);
                    throw genericParsecException;
                }
            }
        }
        if (string != null) {
            this.loadCopies(wConfigPanel, string);
        }
        if (string2 != null) {
            this.loadFork(wConfigPanel, string2);
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            ConfigSchema.Element element2 = this.findElementSchema((Node)object, element);
            if (element2 == null) continue;
            if (element2.isOnlyChild() && wConfigPanel.getStemPanelCount() > 0) {
                throw new ParsecException("Only one child allowed: " + element2);
            }
            wConfigPanel.addChildPanel(this.buildPanel((Node)object, element2));
        }
        return wConfigPanel;
    }

    private void buildDXC(Node node, ConfigSchema.Element element) throws ParsecException {
        this.renderSystemPanel = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            ConfigSchema.Element element2 = this.findElementSchema(node2, element);
            if (element2 == null) continue;
            if (this.renderSystemPanel == null) {
                this.renderSystemPanel = new WSystemPanel(this.setupProvider, ConfigSchema.renderSystemElement);
            }
            this.renderSystemPanel.addChildPanel(this.buildPanel(node2, element2));
        }
    }

    private void buildSystems(Node node, ConfigSchema.Element element) throws ParsecException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Serializable serializable;
            ConfigSchema.Element element2 = this.findElementSchema(node2, element);
            if (element2 == null) continue;
            String string = element2.getName();
            if (string.equals("sourceSystem")) {
                serializable = this.buildPanel(node2, element2);
                if (serializable instanceof WSystemPanel) {
                    this.sourceSystemPanel = (WSystemPanel)serializable;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(element.getName());
                stringBuilder.append(": Unexpected panel object " + serializable.getClass());
                throw new InternalParsecException(stringBuilder.toString());
            }
            if (string.equals("renderSystem")) {
                serializable = this.buildPanel(node2, element2);
                if (serializable instanceof WSystemPanel) {
                    this.renderSystemPanel = (WSystemPanel)serializable;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(element.getName());
                stringBuilder.append(": Unexpected panel object " + serializable.getClass());
                throw new InternalParsecException(stringBuilder.toString());
            }
            serializable = new StringBuilder(element.getName());
            ((StringBuilder)serializable).append(": Unexpected element " + element2.getName());
            throw new InternalParsecException(((StringBuilder)serializable).toString());
        }
    }

    private Document parseDoc(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().normalize();
        return document;
    }

    public WSystemPanel getSourceSystemPanel() {
        return this.sourceSystemPanel;
    }

    public WSystemPanel getRenderSystemPanel() {
        return this.renderSystemPanel;
    }

    public static PDCXReader readFrom(File file, SetupProvider setupProvider) throws ParsecException {
        PDCXReader pDCXReader;
        block5: {
            pDCXReader = new PDCXReader();
            pDCXReader.setupProvider = setupProvider;
            try {
                String string;
                if (file == null || (string = Files.readString(file.toPath())) == null || (string = string.trim()).length() == 0) break block5;
                if (!(string.startsWith("<pdcx") && string.endsWith("</pdcx>") || string.startsWith("<dxcSetup") && string.endsWith("</dxcSetup>"))) {
                    throw new ParsecException("Invalid XML, unexpected root schema");
                }
                Document document = pDCXReader.parseDoc(string);
                Element element = document.getDocumentElement();
                if (element.getNodeName().equals("pdcx")) {
                    pDCXReader.buildSystems(element, ConfigSchema.pdcxRootElement);
                    break block5;
                }
                if (element.getNodeName().equals("dxcSetup")) {
                    pDCXReader.buildDXC(element, ConfigSchema.renderSystemElement);
                    break block5;
                }
                throw new ParsecException("Invalid XML, root element: " + element.getNodeName());
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                GenericParsecException genericParsecException = new GenericParsecException(exception.getMessage());
                genericParsecException.initCause(exception);
                throw genericParsecException;
            }
        }
        return pDCXReader;
    }
}

