/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.parsec.idn.ClipRectangle;
import dexlogic.parsec.idn.FormatBorder;
import dexlogic.parsec.idn.WFilePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WTrackHead
extends JComponent {
    private WFilePanel filePanel;
    private Dimension cachedPrefSize = null;
    private static final Color TRACK_BACKGROUND = new Color(0xEEEEEE);
    private static final Color FOLDER_BACKGROUND = new Color(0xDDDDDD);

    private void validateAttributeCache(FontMetrics fontMetrics) {
        if (this.cachedPrefSize == null) {
            Insets insets = this.getInsets();
            int n = 0;
            int n2 = 80;
            n = insets.top + n + insets.bottom;
            n2 = insets.left + n2 + insets.right;
            this.cachedPrefSize = new Dimension(n2, n);
        }
    }

    public WTrackHead(WFilePanel wFilePanel) {
        this.filePanel = wFilePanel;
        Font font = UIManager.getDefaults().getFont("Panel.font");
        if (font != null) {
            this.setFont(font);
        }
        Color color = WFilePanel.CONTROL_3DFGND;
        this.setBorder(new FormatBorder(null, color, null, null));
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPrefSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - insets.left - insets.right;
        int n4 = dimension.height - insets.top - insets.bottom;
        if (!ClipRectangle.initialize(n, n2, n3, n4, graphics.getClipBounds())) {
            return;
        }
        graphics.setColor(WFilePanel.CONTROL_BGND);
        graphics.fillRect(ClipRectangle.x, ClipRectangle.y, ClipRectangle.width, ClipRectangle.height);
    }
}

