/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.parsec.idn.ClipRectangle;
import dexlogic.parsec.idn.FormatBorder;
import dexlogic.parsec.idn.WFilePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WTimeView
extends JComponent {
    private WFilePanel filePanel;
    private RubberBand rubberBand = null;
    private int selectStartTime = -1;
    private int selectEndTime = -1;
    private Dimension cachedPrefSize = null;
    private int cachedTimeTextWidth = 0;
    private int cachedFracTextWidth = 0;
    private int cachedTimePerPixel = 0;
    private int cachedDisplayMode = 0;
    private float cachedTimeLineIncrement = 0.0f;
    private static final int zoomInFactor = 8;
    private static final int zoomOutFactor = 32;

    private void setSelection(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension = this.getSize();
        int n5 = this.selectStartTime;
        int n6 = this.selectEndTime;
        this.selectEndTime = -1;
        this.selectStartTime = -1;
        if (n5 != -1) {
            n4 = this.filePanel.cvtTimeToPixel(n5);
            n3 = this.filePanel.cvtTimeToPixel(n6) - n4 + 1;
            this.repaint(n4, 0, n3, dimension.height);
        }
        this.selectStartTime = n;
        this.selectEndTime = n2;
        if (this.selectStartTime != -1) {
            n4 = this.filePanel.cvtTimeToPixel(this.selectStartTime);
            n3 = this.filePanel.cvtTimeToPixel(this.selectEndTime) - n4 + 1;
            this.repaint(n4, 0, n3, dimension.height);
        }
    }

    private float getTimeLineIncrement() {
        int n = this.cachedTimeTextWidth * this.cachedTimePerPixel;
        float f = n >= 1000 ? n : this.cachedFracTextWidth * this.cachedTimePerPixel;
        if ((double)f < 1000.0) {
            if ((double)f <= 1.0) {
                return 1.0f;
            }
            if (this.cachedDisplayMode == 1) {
                if (f <= 41.666668f) {
                    return 41.666668f;
                }
                if (f <= 83.333336f) {
                    return 83.333336f;
                }
                if (f <= 166.66667f) {
                    return 166.66667f;
                }
                if (f <= 500.0f) {
                    return 500.0f;
                }
            } else if (this.cachedDisplayMode == 2) {
                if (f <= 40.0f) {
                    return 40.0f;
                }
                if (f <= 200.0f) {
                    return 200.0f;
                }
            } else if (this.cachedDisplayMode == 3) {
                if (f <= 33.333332f) {
                    return 33.333332f;
                }
                if (f <= 66.666664f) {
                    return 66.666664f;
                }
                if (f <= 166.66667f) {
                    return 166.66667f;
                }
                if (f <= 333.33334f) {
                    return 333.33334f;
                }
                if (f <= 500.0f) {
                    return 500.0f;
                }
            } else {
                if ((double)f <= 20.0) {
                    return 20.0f;
                }
                if ((double)f <= 50.0) {
                    return 50.0f;
                }
                if ((double)f <= 100.0) {
                    return 100.0f;
                }
                if ((double)f <= 200.0) {
                    return 200.0f;
                }
                if ((double)f <= 500.0) {
                    return 500.0f;
                }
            }
            f = 1000.0f;
        } else {
            int n2 = 1;
            boolean bl = true;
            while (bl) {
                if ((double)f <= 1.0) {
                    f = 1.0f;
                    break;
                }
                if ((double)f <= 2.0) {
                    f = 2.0f;
                    break;
                }
                if ((double)f <= 5.0) {
                    f = 5.0f;
                    break;
                }
                n2 *= 10;
                f /= 10.0f;
            }
            f *= (float)n2;
        }
        return f;
    }

    private void validateAttributeCache(FontMetrics fontMetrics) {
        int n;
        if (this.cachedPrefSize == null) {
            Insets insets = this.getInsets();
            n = 1;
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n3 = n2 + n + 1 + n + n2;
            int n4 = 0;
            int n5 = 2;
            n3 = insets.top + n5 + n3 + n5 + insets.bottom;
            n4 = insets.left + n4 + insets.right;
            this.cachedPrefSize = new Dimension(n4, n3);
        }
        if (this.cachedTimeTextWidth == 0) {
            this.cachedTimeTextWidth = fontMetrics.stringWidth("99:99:99") + 10;
            this.cachedTimeLineIncrement = 0.0f;
        }
        if (this.cachedFracTextWidth == 0) {
            this.cachedFracTextWidth = fontMetrics.stringWidth("99") + 6;
            this.cachedTimeLineIncrement = 0.0f;
        }
        int n6 = this.filePanel.getTimePerPixel();
        n = this.filePanel.getTimeDisplayMode();
        if (this.cachedTimePerPixel != n6 || this.cachedDisplayMode != n || this.cachedTimeLineIncrement == 0.0f) {
            this.cachedTimePerPixel = n6;
            this.cachedDisplayMode = n;
            this.cachedTimeLineIncrement = this.getTimeLineIncrement();
        }
    }

    public WTimeView(WFilePanel wFilePanel) {
        this.filePanel = wFilePanel;
        Font font = UIManager.getDefaults().getFont("Panel.font");
        if (font != null) {
            this.setFont(font);
        }
        Color color = WFilePanel.CONTROL_3DFGND;
        this.setBorder(new FormatBorder(color, null, color, null));
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(131072L);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPrefSize = null;
        this.cachedTimeTextWidth = 0;
        this.cachedFracTextWidth = 0;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public void resetSelection() {
        this.setSelection(-1, -1);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = dimension.width - insets.left - insets.right;
        int n7 = dimension.height - insets.top - insets.bottom;
        if (!ClipRectangle.initialize(n4, n5, n6, n7, graphics.getClipBounds())) {
            return;
        }
        graphics.setColor(WFilePanel.CONTROL_BGND);
        graphics.fillRect(ClipRectangle.x, ClipRectangle.y, ClipRectangle.width, ClipRectangle.height);
        if (this.selectStartTime >= 0) {
            n3 = this.filePanel.cvtTimeToPixel(this.selectStartTime);
            n2 = this.filePanel.cvtTimeToPixel(this.selectEndTime) - n3 + 1;
            if (n2 > 0 && ClipRectangle.intersectsRangeX(n3, n2)) {
                graphics.setColor(Color.red);
                graphics.fillRect(n3, ClipRectangle.y, n2, ClipRectangle.height);
            }
        }
        if (this.rubberBand != null) {
            n3 = this.rubberBand.getStart();
            n2 = this.rubberBand.getWidth();
            if (n2 > 0 && ClipRectangle.intersectsRangeX(n3, n2)) {
                graphics.setColor(Color.blue);
                graphics.fillRect(n3, ClipRectangle.y, n2, ClipRectangle.height);
            }
        }
        graphics.setColor(Color.black);
        n3 = n5 + n7 / 2;
        if (ClipRectangle.containsY(n3) && ClipRectangle.hasValidWidth()) {
            graphics.drawLine(ClipRectangle.x, n3, ClipRectangle.x + ClipRectangle.width - 1, n3);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.validateAttributeCache(fontMetrics);
        int n8 = this.filePanel.cvtPixelToStartTime(ClipRectangle.x);
        int n9 = this.filePanel.cvtPixelToEndTime(ClipRectangle.x + ClipRectangle.width - 1);
        if (n8 < 0) {
            n8 = 0;
        }
        if ((n = (int)((double)this.cachedTimeLineIncrement + 0.5)) < 1000) {
            n = 1000;
        }
        n8 -= n8 % n;
        for (float f = (float)n8; f < (float)n9; f += this.cachedTimeLineIncrement) {
            int n10 = (int)f;
            if (f - (float)n10 > (float)(n10 + 1) - f) {
                ++n10;
            }
            int n11 = this.filePanel.cvtTimeToPixel(n10);
            graphics.drawLine(n11, n3 + 1, n11, n5 + n7 - 1);
            if (this.cachedTimeLineIncrement < 1000.0f) {
                String string = Integer.toString(this.filePanel.cvtTimeToFrame(n10));
                graphics.drawString(string, n11 + 2, n3 + fontMetrics.getMaxAscent() + 1);
            }
            if (n10 % 1000 != 0) continue;
            graphics.drawLine(n11, n5, n11, n3 - 1);
            int n12 = n10 / 1000;
            int n13 = n12 / 3600;
            int n14 = n12 / 60 % 60;
            int n15 = n12 % 60;
            String string = String.format("%02d:%02d:%02d", n13, n14, n15);
            graphics.drawString(string, n11 + 2, n3 - fontMetrics.getMaxDescent() - 1);
        }
    }

    private class RubberBand {
        int xMark;
        int xCursor;
        boolean fDragged = false;

        public RubberBand(int n) {
            this.xMark = n;
            this.xCursor = -1;
        }

        public int getMark() {
            return this.xMark;
        }

        public int getCursor() {
            return this.xCursor < 0 ? this.xMark : this.xCursor;
        }

        public void setCursor(int n) {
            this.xCursor = n;
        }

        public int getStart() {
            int n = this.getCursor();
            return this.xMark < n ? this.xMark : n;
        }

        public int getEnd() {
            int n = this.getCursor();
            return this.xMark > n ? this.xMark : n;
        }

        public int getWidth() {
            return this.xCursor < 0 ? 0 : Math.abs(this.xCursor - this.xMark) + 1;
        }

        public void setDragged() {
            this.fDragged = true;
        }

        public boolean getDragged() {
            return this.fDragged;
        }
    }
}

