/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.parsec.idn.ClipRectangle;
import dexlogic.parsec.idn.FormatBorder;
import dexlogic.parsec.idn.WFilePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WTimeHead
extends JComponent {
    private WFilePanel filePanel;
    private Dimension cachedPrefSize = null;

    private void validateAttributeCache(FontMetrics fontMetrics) {
        if (this.cachedPrefSize == null) {
            Insets insets = this.getInsets();
            int n = 1;
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n3 = n2 + n + 1 + n + n2;
            int n4 = 0;
            int n5 = 2;
            n3 = insets.top + n5 + n3 + n5 + insets.bottom;
            n4 = insets.left + n4 + insets.right;
            this.cachedPrefSize = new Dimension(n4, n3);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            super.processMouseEvent(mouseEvent);
        }
    }

    public WTimeHead(WFilePanel wFilePanel) {
        this.filePanel = wFilePanel;
        Font font = UIManager.getDefaults().getFont("Panel.font");
        if (font != null) {
            this.setFont(font);
        }
        Color color = WFilePanel.CONTROL_3DFGND;
        this.setBorder(new FormatBorder(color, color, color, null));
        this.enableEvents(16L);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPrefSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.cachedPrefSize == null) {
            this.validateAttributeCache(this.getFontMetrics(this.getFont()));
        }
        return this.cachedPrefSize;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - insets.left - insets.right;
        int n4 = dimension.height - insets.top - insets.bottom;
        if (!ClipRectangle.initialize(n, n2, n3, n4, graphics.getClipBounds())) {
            return;
        }
        graphics.setColor(WFilePanel.CONTROL_BGND);
        graphics.fillRect(ClipRectangle.x, ClipRectangle.y, ClipRectangle.width, ClipRectangle.height);
        graphics.setColor(Color.black);
        int n5 = n2 + n4 / 2;
        if (ClipRectangle.containsY(n5)) {
            graphics.drawLine(ClipRectangle.x, n5, ClipRectangle.x + ClipRectangle.width - 1, n5);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        graphics.drawString("Time", n + 2, n5 - fontMetrics.getMaxDescent() - 1);
        String string = "?";
        int n6 = this.filePanel.getTimeDisplayMode();
        if (n6 == 0) {
            string = "1/100s";
        } else if (n6 == 1) {
            string = "24 FPS";
        } else if (n6 == 2) {
            string = "25 FPS";
        } else if (n6 == 3) {
            string = "30 FPS";
        }
        graphics.drawString(string, n + 2, n5 + fontMetrics.getMaxAscent() + 1);
    }
}

