/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.parsec.idn.WIDNRootPane;
import dexlogic.parsec.idn.WSpacing;
import dexlogic.parsec.idn.WTimeHead;
import dexlogic.parsec.idn.WTimeView;
import dexlogic.parsec.idn.WTrackHead;
import dexlogic.parsec.idn.WTrackView;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;

public class WFilePanel
extends JPanel
implements AdjustmentListener {
    private WIDNRootPane rootPane;
    private JScrollBar hrzScrollBar;
    private JScrollBar vrtScrollBar;
    private WTimeHead timeHeadWin;
    private WTimeView timeViewWin;
    private WTrackHead trackHeadWin;
    private WTrackView trackViewWin;
    private boolean scrollbarAdjustmentEnabled = true;
    private int yLayoutHeight;
    private int yPaintOffset;
    private float cachedFractionScale;
    private int xStartTime;
    private int xTimePerPixel;
    private int timeDisplayMode;
    public static final int TIMEDISPLAY_100 = 0;
    public static final int TIMEDISPLAY_24FPS = 1;
    public static final int TIMEDISPLAY_25FPS = 2;
    public static final int TIMEDISPLAY_30FPS = 3;
    public static final Color CONTROL_BGND = new Color(0xCCCCCC);
    public static final Color CONTROL_3DFGND = new Color(0xFFFFFF);
    public static final Color CONTROL_3DBGND = new Color(0xA0A0A0);

    private JComponent buildLeftPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        WSpacing wSpacing = new WSpacing(null, CONTROL_3DFGND, null, null);
        int n = this.trackHeadWin.getPreferredSize().width;
        int n2 = this.hrzScrollBar.getPreferredSize().height;
        Dimension dimension = new Dimension(n, n2);
        wSpacing.setMinimumSize(dimension);
        wSpacing.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.timeHeadWin, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.trackHeadWin, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)wSpacing, gridBagConstraints);
        return jPanel;
    }

    private JComponent buildRightPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        WSpacing wSpacing = new WSpacing(CONTROL_3DFGND, CONTROL_3DFGND, CONTROL_3DFGND, null);
        WSpacing wSpacing2 = new WSpacing(null, null, null, null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.timeViewWin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)wSpacing, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.trackViewWin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.vrtScrollBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.hrzScrollBar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)wSpacing2, gridBagConstraints);
        return jPanel;
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.timeHeadWin = new WTimeHead(this);
        this.trackHeadWin = new WTrackHead(this);
        this.timeViewWin = new WTimeView(this);
        this.trackViewWin = new WTrackView(this);
        this.hrzScrollBar = new JScrollBar(0, 0, 10, 0, 100);
        this.hrzScrollBar.addAdjustmentListener(this);
        this.vrtScrollBar = new JScrollBar(1, 0, 10, 0, 100);
        this.vrtScrollBar.addAdjustmentListener(this);
        JSplitPane jSplitPane = new JSplitPane(1, this.buildLeftPane(), this.buildRightPane());
        jSplitPane.setDividerSize(5);
        this.add((Component)jSplitPane, "Center");
    }

    private void adjustVScroll() {
        int n;
        int n2 = this.yLayoutHeight;
        int n3 = this.trackViewWin.getSize().height;
        if (n2 < n3) {
            n2 = n3;
        }
        if ((n = this.vrtScrollBar.getValue()) > n2 - n3) {
            n = n2 - n3;
        }
        this.vrtScrollBar.setValues(n, n3, 0, n2);
    }

    private void adjustHScroll() {
        BoundedRangeModel boundedRangeModel = this.getStartTimeRange(this.xTimePerPixel);
        int n = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
        int n2 = this.xStartTime;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n) {
            n2 = n;
        }
        this.hrzScrollBar.setValues(n2, boundedRangeModel.getExtent(), 0, boundedRangeModel.getMaximum());
    }

    private float getFractionScale() {
        float f = 10.0f;
        if (this.timeDisplayMode == 1) {
            f = 41.666668f;
        } else if (this.timeDisplayMode == 2) {
            f = 40.0f;
        } else if (this.timeDisplayMode == 3) {
            f = 33.333332f;
        }
        return f;
    }

    private void validateTrackLayout() {
        int n = 15;
        boolean bl = false;
        boolean bl2 = false;
        this.yLayoutHeight = n + 15;
    }

    @Override
    protected void validateTree() {
        super.validateTree();
        this.validateTrackLayout();
        this.adjustVScroll();
        this.adjustHScroll();
    }

    public WFilePanel(WIDNRootPane wIDNRootPane) {
        this.rootPane = wIDNRootPane;
        this.buildUI();
        this.xStartTime = 0;
        this.xTimePerPixel = 1;
        this.timeDisplayMode = 0;
        this.cachedFractionScale = this.getFractionScale();
    }

    public BoundedRangeModel getStartTimeRange(int n) {
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel();
        int n2 = 5000;
        int n3 = this.trackViewWin.getSize().width * n;
        if ((n2 += n3 / 5) < n3) {
            n2 = n3;
        }
        return new DefaultBoundedRangeModel(0, n3, 0, n2);
    }

    public int getTimePerPixel() {
        return this.xTimePerPixel;
    }

    public int getTimeDisplayMode() {
        return this.timeDisplayMode;
    }

    public int cvtPixelToStartTime(int n) {
        return this.xStartTime + n * this.xTimePerPixel;
    }

    public int cvtPixelToEndTime(int n) {
        return this.xStartTime + (n + 1) * this.xTimePerPixel - 1;
    }

    public int cvtTimeToPixel(int n) {
        return (n - this.xStartTime) / this.xTimePerPixel;
    }

    public int cvtTimeToFrame(int n) {
        float f = this.cachedFractionScale;
        int n2 = n % 1000;
        int n3 = (int)((float)n2 / f);
        int n4 = (int)((float)(n2 + 1) / f);
        if ((int)((float)n3 * f) != n2 && (int)((float)n4 * f) == n2) {
            n3 = n4;
        }
        return n3;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.scrollbarAdjustmentEnabled) {
            return;
        }
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        int n = adjustmentEvent.getValue();
        if (adjustable == this.hrzScrollBar) {
            if (n == this.xStartTime) {
                return;
            }
            this.xStartTime = adjustmentEvent.getValue();
            this.trackViewWin.repaint();
            this.timeViewWin.repaint();
        } else if (adjustable == this.vrtScrollBar) {
            if (n == this.yPaintOffset) {
                return;
            }
            this.yPaintOffset = n;
            this.trackHeadWin.repaint();
            this.trackViewWin.repaint();
        }
    }
}

