/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.dxc.DXCException;
import dexlogic.dxc.DXCManager;
import dexlogic.parsec.MediaSource;
import java.net.URI;

public class SourceManager {
    private MediaSource mediaSource;
    private DXCManager streamManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStreamManager() {
        String string;
        if (this.streamManager != null) {
            throw new RuntimeException("Invalid method call, streamManager exists");
        }
        URI uRI = this.mediaSource.getFeed().absoluteURI;
        String string2 = uRI.getScheme();
        if (string2 == null || string2.equals("file")) {
            string = "  <sourceDriver driverID='FileReader'>\n    <feed style='" + this.mediaSource.getFeed().style + "' name='#1' setup='path:\"" + uRI.getPath() + "\"'>\n";
        } else if (string2.equals("idsp")) {
            string = "  <sourceDriver driverID='IDNServer'>\n    <feed style='" + this.mediaSource.getFeed().style + "' name='#1' setup='pullAddress:\"" + uRI.toString() + "\"'>\n";
        } else {
            throw new RuntimeException("Invalid URI scheme" + string2);
        }
        String string3 = "    </feed>\n  </sourceDriver>\n";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<dxcSetup>\n");
        stringBuilder.append(string);
        for (MediaSource.Trunk trunk : this.mediaSource.getFeed().trunks) {
            if (!trunk.enabled) continue;
            Object object = "";
            if (trunk.trunkName != null && trunk.trunkName.length() != 0) {
                object = " name=\"" + trunk.trunkName + "\"";
            }
            Object object2 = "";
            String string4 = trunk.getSetupArgs();
            if (string4 != null && (string4 = string4.trim()).length() != 0) {
                object2 = " setup=' " + string4 + " '";
            }
            stringBuilder.append("      <trunk" + (String)object + (String)object2 + ">\n");
            for (MediaSource.Jack jack : trunk.jacks) {
                if (!jack.routing.enabled) continue;
                Object object3 = "";
                if (jack.jackName != null && jack.jackName.length() != 0) {
                    object3 = " name=\"" + jack.jackName + "\"";
                }
                String string5 = "";
                Object object4 = "";
                String string6 = jack.getSetupArgs();
                if (string6 != null && (string6 = string6.trim()).length() != 0) {
                    object4 = " setup=' " + string6 + " '";
                }
                stringBuilder.append("        <jack" + (String)object3 + string5 + (String)object4 + "/>\n");
            }
            stringBuilder.append("      </trunk>\n");
        }
        stringBuilder.append(string3);
        stringBuilder.append("</dxcSetup>");
        System.out.println(stringBuilder);
        try (Object object = null;){
            object = new DXCManager(0x10000FF);
            ((DXCManager)object).buildFromXML(stringBuilder.toString());
            this.streamManager = object;
            object = null;
        }
    }

    public SourceManager(MediaSource mediaSource) {
        this.mediaSource = mediaSource;
    }

    public void play() {
        if (this.streamManager == null) {
            this.createStreamManager();
        }
        if (this.streamManager != null) {
            try {
                this.streamManager.play(null);
            }
            catch (DXCException dXCException) {
                System.out.println();
                dXCException.printStackTrace();
            }
        }
    }

    public void pause() {
        if (this.streamManager == null) {
            this.createStreamManager();
        }
        if (this.streamManager != null) {
            try {
                this.streamManager.pause(null);
            }
            catch (DXCException dXCException) {
                System.out.println();
                dXCException.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.streamManager == null) {
            return;
        }
        try {
            this.streamManager.idle(null);
            this.streamManager.reset();
            this.streamManager.close();
        }
        finally {
            this.streamManager = null;
        }
    }
}

