/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.io.idn.IDNFile;
import dexlogic.io.idn.messages.IDNFileAnchorMessage;
import dexlogic.io.idn.structs.IDNFileTrackEntryStruct;
import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class IDNSource {
    private static void prepareJack(MediaSource.Jack jack, IDNFileTrackEntryStruct iDNFileTrackEntryStruct) throws ParsecException {
        jack.comment = null;
        jack.serviceType = iDNFileTrackEntryStruct.getServiceType();
    }

    private static MediaSource.Jack fetchJack(MediaSource.Jack[] jackArray, int n, String string) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < jackArray.length; ++i) {
            MediaSource.Jack jack = jackArray[i];
            if (jack == null) continue;
            String string2 = ParsecTools.trimString(jack.getSetupArg("serviceID"));
            int n4 = -1;
            try {
                if (string2 != null) {
                    n4 = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -1;
            }
            String string3 = ParsecTools.trimString(jack.jackName);
            if (n2 < 0 && n3 < 10 && n4 > 0 && n4 == n && (string3 == null || string != null && string3.equals(string))) {
                n2 = i;
                n3 = 10;
                break;
            }
            if (n2 >= 0 || n3 >= 5 || string2 != null || string3 == null || string == null || !string3.equals(string)) continue;
            n2 = i;
            n3 = 5;
        }
        if (n2 >= 0) {
            MediaSource.Jack jack = jackArray[n2];
            jackArray[n2] = null;
            return jack;
        }
        return null;
    }

    private static void prepareTrunk(MediaSource.Trunk trunk, IDNFileAnchorMessage iDNFileAnchorMessage) throws ParsecException {
        CharSequence charSequence;
        Object object;
        int n;
        String string = ParsecTools.trimString(trunk.getSetupArg("anchorNum"));
        int n2 = -1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n2 < 0) {
            if (string == null) {
                throw new InternalParsecException("No anchorNum");
            }
            throw new InternalParsecException("Invalid anchorNum: " + string);
        }
        String string2 = ParsecTools.trimString(iDNFileAnchorMessage.getStreamName());
        String string3 = "Stream " + n2;
        if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        trunk.label = string3;
        trunk.durationMS = iDNFileAnchorMessage.getDurationMS();
        MediaSource.Jack[] jackArray = new MediaSource.Jack[trunk.jacks.size()];
        trunk.jacks.toArray(jackArray);
        IDNFileTrackEntryStruct[] iDNFileTrackEntryStructArray = iDNFileAnchorMessage.getTrackArray();
        for (n = 0; n < iDNFileTrackEntryStructArray.length; ++n) {
            int n3;
            object = iDNFileTrackEntryStructArray[n];
            if (object == null || (n3 = ((IDNFileTrackEntryStruct)object).getServiceID()) <= 0) continue;
            charSequence = ParsecTools.trimString(((IDNFileTrackEntryStruct)object).getTrackName());
            MediaSource.Jack jack = IDNSource.fetchJack(jackArray, n3, (String)charSequence);
            if (jack == null) {
                jack = trunk.addJack((String)charSequence);
                jack.routing.enabled = jackArray.length == 0;
            } else {
                jack.jackName = charSequence;
            }
            jack.putSetupArg("serviceID", Integer.toString(n3));
            IDNSource.prepareJack(jack, (IDNFileTrackEntryStruct)object);
        }
        for (n = 0; n < jackArray.length; ++n) {
            object = jackArray[n];
            if (object == null) continue;
            String string4 = ((MediaSource.Element)object).getSetupArg("serviceID");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Jack ").append(n + 1);
            if (((MediaSource.Jack)object).jackName != null) {
                ((StringBuilder)charSequence).append(" (").append(((MediaSource.Jack)object).jackName).append(")");
            }
            if (string4 != null) {
                ((StringBuilder)charSequence).append(", serviceID ").append(string4);
            }
            ((StringBuilder)charSequence).append(" assignment error (unmatched)");
            throw new GenericParsecException(((StringBuilder)charSequence).toString());
        }
    }

    private static MediaSource.Trunk fetchTrunk(MediaSource.Trunk[] trunkArray, int n, String string) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < trunkArray.length; ++i) {
            MediaSource.Trunk trunk = trunkArray[i];
            if (trunk == null) continue;
            String string2 = ParsecTools.trimString(trunk.getSetupArg("anchorNum"));
            int n4 = -1;
            try {
                if (string2 != null) {
                    n4 = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -1;
            }
            String string3 = ParsecTools.trimString(trunk.trunkName);
            if (n2 < 0 && n3 < 10 && n4 > 0 && n4 == n && (string3 == null || string != null && string3.equals(string))) {
                n2 = i;
                n3 = 10;
                break;
            }
            if (n2 < 0 && n3 < 5 && string2 == null && string3 != null && string != null && string3.equals(string)) {
                n2 = i;
                n3 = 5;
                continue;
            }
            if (n2 >= 0 || n3 >= 1 || string2 != null || string3 != null || i != n - 1) continue;
            n2 = i;
            n3 = 1;
        }
        if (n2 >= 0) {
            MediaSource.Trunk trunk = trunkArray[n2];
            trunkArray[n2] = null;
            return trunk;
        }
        return null;
    }

    private static void prepareSource(IDNFile iDNFile, MediaSource mediaSource) throws ParsecException {
        Object object;
        MediaSource.Trunk[] trunkArray;
        ArrayList<MediaSource.Trunk[]> arrayList = new ArrayList<MediaSource.Trunk[]>();
        try {
            trunkArray = iDNFile.getFirstAnchorMessage();
            while (trunkArray != null) {
                arrayList.add(trunkArray);
                trunkArray = iDNFile.getAnchorMessageAt(trunkArray.getNextAnchorFP());
            }
        }
        catch (Throwable throwable) {
            String string = "Anchor list read error";
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
            throw genericParsecException;
        }
        trunkArray = new MediaSource.Trunk[mediaSource.getFeed().trunks.size()];
        mediaSource.getFeed().trunks.toArray(trunkArray);
        int n = 1;
        for (IDNFileAnchorMessage object2 : arrayList) {
            String string = ParsecTools.trimString(object2.getStreamName());
            object = IDNSource.fetchTrunk(trunkArray, n, string);
            if (object == null) {
                object = mediaSource.getFeed().addTrunk(string);
                ((MediaSource.Trunk)object).enabled = trunkArray.length == 0 && mediaSource.getFeed().trunks.size() == 1;
            } else {
                ((MediaSource.Trunk)object).trunkName = string;
            }
            ((MediaSource.Element)object).putSetupArg("anchorNum", Integer.toString(n));
            ((MediaSource.Trunk)object).layout = null;
            try {
                IDNSource.prepareTrunk((MediaSource.Trunk)object, object2);
            }
            catch (ParsecException parsecException) {
                int n2 = mediaSource.getFeed().trunks.indexOf(object);
                int n3 = n2 + 1;
                String string2 = ParsecTools.trimString(((MediaSource.Trunk)object).trunkName);
                StringBuilder stringBuilder = new StringBuilder();
                if (n2 < 0) {
                    stringBuilder.append("New trunk ");
                } else {
                    stringBuilder.append("Trunk ").append(n3);
                }
                if (string2 != null) {
                    stringBuilder.append(" (").append(string2).append(")");
                }
                stringBuilder.append(", anchorNum ").append(n);
                parsecException.addHint(stringBuilder.toString());
                throw parsecException;
            }
            ++n;
        }
        for (int i = 0; i < trunkArray.length; ++i) {
            MediaSource.Trunk trunk = trunkArray[i];
            if (trunk == null) continue;
            int n4 = i + 1;
            object = ParsecTools.trimString(trunk.trunkName);
            String string = ParsecTools.trimString(trunk.getSetupArg("anchorNum"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Trunk ").append(n4);
            if (object != null) {
                stringBuilder.append(" (").append((String)object).append(")");
            }
            if (string != null) {
                stringBuilder.append(", anchorNum ").append(string);
            }
            stringBuilder.append(" assignment error (unmatched)");
            throw new GenericParsecException(stringBuilder.toString());
        }
    }

    public static MediaSource createSource(File file, IDNFile iDNFile) throws ParsecException {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string = "File path error: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setDetails(ParsecTools.getTraceDetails(iOException));
            throw genericParsecException;
        }
        MediaSource mediaSource = new MediaSource("IDN", file2);
        try {
            IDNSource.prepareSource(iDNFile, mediaSource);
        }
        catch (ParsecException parsecException) {
            parsecException.addHint("Media file: " + file.getName());
            throw parsecException;
        }
        return mediaSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaSource createSource(File file) throws ParsecException {
        if (file == null) {
            throw new InternalParsecException("Invalid parameter");
        }
        if (!file.exists()) {
            String string = "Media file not found: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
            throw genericParsecException;
        }
        IDNFile iDNFile = null;
        MediaSource mediaSource = null;
        try {
            try {
                iDNFile = new IDNFile(file.getCanonicalPath());
                iDNFile.open("r");
            }
            catch (Exception exception) {
                String string = "Media file open error: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string);
                genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
                genericParsecException.setDetails(ParsecTools.getTraceDetails(exception));
                throw genericParsecException;
            }
            mediaSource = IDNSource.createSource(file, iDNFile);
        }
        finally {
            if (iDNFile != null) {
                try {
                    iDNFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return mediaSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSource(MediaSource mediaSource) throws ParsecException {
        File file = new File(mediaSource.getFeed().absoluteURI.getPath());
        if (!file.exists()) {
            String string = "Media file not found: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
            throw genericParsecException;
        }
        IDNFile iDNFile = null;
        try {
            try {
                iDNFile = new IDNFile(file.getCanonicalPath());
                iDNFile.open("r");
            }
            catch (Exception exception) {
                String string = "Media file open error: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string);
                genericParsecException.setHints("Absolute path: \n" + file.getAbsolutePath());
                genericParsecException.setDetails(ParsecTools.getTraceDetails(exception));
                throw genericParsecException;
            }
            try {
                IDNSource.prepareSource(iDNFile, mediaSource);
            }
            catch (ParsecException parsecException) {
                parsecException.addHint("Media file: " + file.getName());
                throw parsecException;
            }
        }
        finally {
            if (iDNFile != null) {
                try {
                    iDNFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

