/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import java.awt.Rectangle;

public class ClipRectangle {
    public static int x;
    public static int y;
    public static int width;
    public static int height;

    public static boolean initialize(int n, int n2, int n3, int n4) {
        x = n;
        y = n2;
        width = n3;
        height = n4;
        return width > 0 && x + (width - 1) >= x && height > 0 && y + (height - 1) >= y;
    }

    public static boolean initialize(Rectangle rectangle) {
        x = rectangle.x;
        y = rectangle.y;
        width = rectangle.width;
        height = rectangle.height;
        return width > 0 && x + (width - 1) >= x && height > 0 && y + (height - 1) >= y;
    }

    public static boolean initialize(int n, int n2, int n3, int n4, Rectangle rectangle) {
        if (rectangle == null) {
            x = n;
            y = n2;
            width = n3;
            height = n4;
        } else {
            int n5 = Math.max(rectangle.x, n);
            int n6 = Math.max(rectangle.y, n2);
            int n7 = Math.min(rectangle.x + rectangle.width, n + n3);
            int n8 = Math.min(rectangle.y + rectangle.height, n2 + n4);
            x = n5;
            y = n6;
            width = n7 - n5;
            height = n8 - n6;
        }
        return width > 0 && x + (width - 1) >= x && height > 0 && y + (height - 1) >= y;
    }

    public static void clipLeft(int n) {
        if (width <= 0) {
            return;
        }
        int n2 = x + (width - 1);
        int n3 = x;
        if (n2 < n3 || n <= n3) {
            return;
        }
        if (n > n2) {
            x = n2;
            width = 0;
            return;
        }
        width = n2 - n + 1;
        x = n;
    }

    public static void clipRight(int n) {
        if (width <= 0) {
            return;
        }
        int n2 = x + (width - 1);
        int n3 = x;
        if (n2 < n3 || n2 <= n) {
            return;
        }
        if (n < n3) {
            width = 0;
            return;
        }
        width = n - n3 + 1;
    }

    public static void clipTop(int n) {
        if (height <= 0) {
            return;
        }
        int n2 = y + (height - 1);
        int n3 = y;
        if (n2 < n3 || n <= n3) {
            return;
        }
        if (n > n2) {
            y = n2;
            height = 0;
            return;
        }
        height = n2 - n + 1;
        y = n;
    }

    public static void clipBottom(int n) {
        if (height <= 0) {
            return;
        }
        int n2 = y + (height - 1);
        int n3 = y;
        if (n2 < n3 || n2 <= n) {
            return;
        }
        if (n < n3) {
            height = 0;
            return;
        }
        height = n - n3 + 1;
    }

    public static boolean hasValidWidth() {
        if (width <= 0) {
            return false;
        }
        return x + (width - 1) >= x;
    }

    public static boolean hasValidHeight() {
        if (height <= 0) {
            return false;
        }
        return y + (height - 1) >= y;
    }

    public static boolean containsX(int n) {
        if (width <= 0) {
            return false;
        }
        int n2 = x + (width - 1);
        int n3 = x;
        return n2 >= n3 && n3 <= n && n <= n2;
    }

    public static boolean containsY(int n) {
        if (height <= 0) {
            return false;
        }
        int n2 = y + (height - 1);
        int n3 = y;
        return n2 >= n3 && n3 <= n && n <= n2;
    }

    public static boolean intersectsRangeX(int n, int n2) {
        if (width <= 0 || n2 <= 0) {
            return false;
        }
        int n3 = x;
        int n4 = x + (width - 1);
        int n5 = n;
        int n6 = n + (n2 - 1);
        if (n4 < n3 || n6 < n5) {
            return false;
        }
        return n5 <= n4 && n6 >= n3;
    }

    public static boolean intersectsBoundsY(int n, int n2) {
        if (height <= 0) {
            return false;
        }
        int n3 = y + (height - 1);
        int n4 = y;
        if (n3 < n4 || n2 < n) {
            return false;
        }
        return n <= n3 && n2 >= n4;
    }
}

