/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WFileChooser;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WDriverPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;

public class WSourceDriverPanel
extends WDriverPanel {
    private int modFlags;
    public static final int MODFLAG_IDNSERVER = 16;
    public static final int MODFLAG_READER = 32;

    private void newIDNPullServer() throws ParsecException {
    }

    private void newFileReader() throws ParsecException {
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.setDialogType(0);
        wFileChooser.setAcceptAllFileFilterUsed(false);
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("IDN-File Format", ".idn"));
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("Waveform File Format", ".wav"));
        int n = wFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = wFileChooser.getSelectedFile();
        String string = file.getName().toLowerCase();
        if (!string.endsWith(".idn") && !string.endsWith(".wav")) {
            throw new ParsecException("Invalid file extension");
        }
    }

    @Override
    protected void addPopupItemsNew(UMenuButton uMenuButton) {
        super.addPopupItemsNew(uMenuButton);
        if ((this.modFlags & 0x20) != 0) {
            JMenuItem jMenuItem = uMenuButton.addItem(new JMenuItem("New File Reader"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        WSourceDriverPanel.this.newFileReader();
                    }
                    catch (Throwable throwable) {
                        String string = "File open error";
                        ParsecTools.showExceptionDialog(WSourceDriverPanel.this, string, throwable);
                    }
                }
            });
        }
    }

    public WSourceDriverPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
    }
}

