/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UFilterButton;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.UPluginCombo;
import dexlogic.parsec.config.WBranchPanel;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WFilterDriverPanel;
import dexlogic.parsec.config.WRoutingPanel;
import dexlogic.parsec.remote.WAlertIndicator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class WSourceDSPPanel
extends WRoutingPanel {
    private int filterID = this.getSetupProvider().requestFilterID();
    private WFilterDriverPanel.ChildAuditor branchAuditor;
    private WFilterDriverPanel.ChildAuditor stemAuditor;
    private int inputType = -1;
    private JCheckBox enabledCheck;
    private UPluginCombo pluginCombo;
    private WAlertIndicator alertIndicator;
    private UFilterButton filterButton;
    private JLabel changeTypeLabel;
    private JLabel outputTypeLabel;
    private JLabel patchLabel;
    private FilterSpec filterSpec;
    private boolean inputOnlyLane;

    private void updateTypeChain() {
        boolean bl;
        int n;
        if (this.filterSpec != null) {
            n = this.filterSpec.getLaneOutputType(0);
            if (n > 0) {
                bl = n != this.inputType;
                this.outputTypeLabel.setText(ParsecTools.getServiceTypeText(n));
            } else if (n == 0) {
                n = this.inputType;
                bl = false;
                this.outputTypeLabel.setText("");
            } else {
                bl = false;
                this.outputTypeLabel.setText("");
            }
        } else {
            n = -1;
            bl = false;
            this.outputTypeLabel.setText("");
        }
        this.changeTypeLabel.setVisible(bl);
        this.outputTypeLabel.setVisible(bl);
        this.setPatchType(n);
    }

    private void setFilterSpec(FilterSpec filterSpec) {
        if (this.filterSpec == filterSpec) {
            return;
        }
        if (this.filterSpec != null) {
            this.putAttrib("rpc", null);
        }
        this.filterSpec = filterSpec;
        if (filterSpec != null) {
            this.branchAuditor.checkContainer();
            if (filterSpec.getLaneOutputType(0) < 0) {
                int n;
                this.inputOnlyLane = true;
                Component[] componentArray = this.getStemPanels();
                int n2 = n = componentArray != null ? componentArray.length : 0;
                for (int i = 0; i < n; ++i) {
                    ((WConfigPanel)componentArray[i]).discard();
                }
            } else {
                this.inputOnlyLane = false;
            }
        } else {
            int n;
            this.inputOnlyLane = false;
            Component[] componentArray = this.getBranchPanels();
            int n3 = n = componentArray != null ? componentArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (!(componentArray[i] instanceof WBranchPanel)) continue;
                ((WBranchPanel)componentArray[i]).setFilterSpec(null, -1);
            }
        }
        this.updateTypeChain();
        this.filterButton.setFilterSpec(filterSpec);
        this.updateUIState();
        this.resetPopupMenu();
    }

    private void applyInputType() {
        this.pluginCombo.setFilterOptions(this.getSetupProvider().getSourcePluginOptions(this.inputType));
        FilterSpec filterSpec = this.pluginCombo.getVerifiedFilterSpec();
        if (filterSpec == this.filterSpec) {
            this.updateTypeChain();
        } else {
            this.setFilterSpec(filterSpec);
        }
    }

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.enabledCheck = new JCheckBox("");
        this.enabledCheck.setOpaque(false);
        this.enabledCheck.setSelected(true);
        this.enabledCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WSourceDSPPanel.this.isDisplayable()) {
                    return;
                }
                WSourceDSPPanel.this.updateUIState();
                WSourceDSPPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        this.pluginCombo = new UPluginCombo();
        this.pluginCombo.setOpaque(false);
        this.pluginCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WSourceDSPPanel.this.isDisplayable()) {
                    return;
                }
                WSourceDSPPanel.this.setFilterSpec(WSourceDSPPanel.this.pluginCombo.getVerifiedFilterSpec());
                WSourceDSPPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        this.alertIndicator = new WAlertIndicator(this);
        this.filterButton = new UFilterButton("F" + this.filterID, this);
        this.changeTypeLabel = new JLabel(WSourceDSPPanel.getChangeIcon());
        this.changeTypeLabel.setVisible(false);
        this.outputTypeLabel = WConfigPanel.createServiceTypeLabel();
        this.outputTypeLabel.setVisible(false);
        this.patchLabel = new JLabel("Patch");
        this.patchLabel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)this.enabledCheck, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.pluginCombo, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.filterButton, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        jPanel.add((Component)this.changeTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)this.outputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.patchLabel, gridBagConstraints);
    }

    @Override
    protected JMenuItem createPopupItemNew(UMenuButton uMenuButton, ConfigSchema.Element element) {
        if (element.getName().equals("branch") ? this.filterSpec == null || this.filterSpec.getBranchCount() < 0 : element.getName().equals("plugin") && !this.inputOnlyLane) {
            return super.createPopupItemNew(uMenuButton, element);
        }
        return null;
    }

    @Override
    protected boolean evalPatchConfigurable() {
        return super.evalPatchConfigurable() && !this.inputOnlyLane;
    }

    @Override
    protected boolean evalPanelEnabled() {
        return super.evalPanelEnabled() && this.enabledCheck.isSelected();
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPatchConfigurable();
        this.patchLabel.setVisible(bl);
        boolean bl2 = this.evalPanelEnabled();
        this.setCompEnabled(this.enabledCheck, true);
        this.setCompEnabled(this.pluginCombo, bl2);
        boolean bl3 = this.filterSpec != null && this.filterSpec.getDialogClass() != null;
        this.setCompEnabled(this.filterButton, bl2 && bl3);
    }

    public WSourceDSPPanel(final SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.ensureLocalObjectAgent();
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
        this.setPatchAttrib("");
        this.branchAuditor = new WFilterDriverPanel.ChildAuditor(){

            @Override
            public int getChannelCount() {
                return WSourceDSPPanel.this.filterSpec.getBranchCount();
            }

            @Override
            public int getChannelType(int n) {
                return WSourceDSPPanel.this.filterSpec.getBranchOutputType(n);
            }

            @Override
            public int getPanelCount() {
                return WSourceDSPPanel.this.getBranchPanelCount();
            }

            @Override
            public WConfigPanel getPanel(int n) {
                return WSourceDSPPanel.this.getBranchPanel(n);
            }

            @Override
            public void bindPanel(WConfigPanel wConfigPanel, int n) {
                if (wConfigPanel instanceof WBranchPanel) {
                    ((WBranchPanel)wConfigPanel).setFilterSpec(WSourceDSPPanel.this.filterSpec, n);
                }
            }

            @Override
            public void createPanel() {
                ConfigSchema.Element element = WSourceDSPPanel.this.getElementSchema().getChildSchema("branch");
                try {
                    WSourceDSPPanel.this.addChildPanel(WConfigPanel.createPanel(setupProvider, element));
                }
                catch (ParsecException parsecException) {
                    parsecException.printStackTrace();
                }
            }
        };
    }

    @Override
    public void discard() {
        super.discard();
        this.filterButton.discardNotify();
        if (this.filterID > 0) {
            this.getSetupProvider().releaseFilterID(this.filterID);
            this.filterID = -1;
        }
    }

    public void setInputType(int n) {
        this.inputType = n;
        if (this.isDisplayable()) {
            this.applyInputType();
        }
    }

    public int getInputType() {
        return this.inputType;
    }

    public String getPluginName() {
        return this.filterButton.getText();
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("enabled")) {
            boolean bl;
            boolean bl2 = bl = string2 != null && string2.equals("true");
            if (this.enabledCheck.isSelected() != bl) {
                this.enabledCheck.setSelected(bl);
                this.updateUIState();
            }
        } else if (string.equals("style")) {
            this.pluginCombo.putStyleAttrib(string2);
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("enabled")) {
            return !this.enabledCheck.isSelected() ? "false" : null;
        }
        if (string.equals("style")) {
            return this.pluginCombo.getStyleAttrib();
        }
        return super.getAttrib(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (this.filterSpec != null) {
            if (wConfigPanel instanceof WBranchPanel) {
                if (!this.branchAuditor.checkPanel(wConfigPanel, this.getBranchPanelCount())) {
                    return;
                }
            } else {
                if (!(wConfigPanel instanceof WSourceDSPPanel)) return;
                if (this.inputOnlyLane) {
                    return;
                }
            }
        } else if (wConfigPanel instanceof WBranchPanel) {
            ((WBranchPanel)wConfigPanel).setFilterSpec(null, -1);
        } else if (!(wConfigPanel instanceof WSourceDSPPanel)) {
            return;
        }
        super.addChildPanel(wConfigPanel);
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.enabledCheck, false);
            this.setCompEnabled(this.pluginCombo, false);
        }
    }

    @Override
    public void addNotify() {
        this.applyInputType();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.pluginCombo.setFilterOptions(null);
    }
}

