/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.idn.IDNUnitID;
import dexlogic.io.netscan.NetScanExplorer;
import dexlogic.io.netscan.NetScanResult;
import dexlogic.io.netscan.proto.IDNHelloScanHandler;
import dexlogic.io.netscan.proto.IDNHelloServer;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.DefaultPortSocketAddress;
import dexlogic.parsec.config.IDNServerMerger;
import dexlogic.parsec.config.IDNServiceMerger;
import dexlogic.parsec.config.ScanResultMerger;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WDriverPanel;
import dexlogic.parsec.config.WModulePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class WSinkDriverPanel
extends WDriverPanel {
    private int modFlags;
    private JMenuItem findIDNServersItem;
    public static final int MODFLAG_IDNCLIENT = 1;
    public static final int MODFLAG_WRITER = 2;

    private void mergeScanResult(NetScanResult netScanResult) {
        IDNServerMerger iDNServerMerger = new IDNServerMerger(new IDNServiceMerger());
        ScanResultMerger scanResultMerger = new ScanResultMerger(iDNServerMerger){

            @Override
            public void merge(WConfigPanel wConfigPanel, NetScanResult netScanResult) {
                try {
                    super.merge(wConfigPanel, netScanResult);
                }
                finally {
                    WSinkDriverPanel.this.findIDNServersItem.setEnabled(true);
                }
            }
        };
        scanResultMerger.merge(this, netScanResult);
    }

    private void findIDNServers(Object object) {
        int n;
        this.findIDNServersItem.setEnabled(false);
        IDNHelloScanHandler iDNHelloScanHandler = new IDNHelloScanHandler();
        Object object2 = this.getSetupValue("clientGroup");
        if (!(object2 instanceof Integer)) {
            object2 = this.getDefaultValue("clientGroup");
        }
        if (object2 instanceof Integer) {
            iDNHelloScanHandler.setClientGroup((Integer)object2);
        }
        Component[] componentArray = this.getStemPanels();
        int n2 = n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Object object3;
            WModulePanel wModulePanel;
            Object object4;
            if (!(componentArray[i] instanceof WModulePanel) || !((object4 = (wModulePanel = (WModulePanel)componentArray[i]).getSetupValue("unitID")) instanceof IDNUnitID) || !((object3 = wModulePanel.getSetupValue("remoteAddress")) instanceof DefaultPortSocketAddress)) continue;
            InetSocketAddress inetSocketAddress = ((DefaultPortSocketAddress)object3).getInetSocketAddress();
            iDNHelloScanHandler.putServer(new IDNHelloServer((IDNUnitID)object4, inetSocketAddress));
        }
        try {
            new NetScanExplorer(iDNHelloScanHandler){

                @Override
                protected void scanEnded(NetScanResult netScanResult) {
                    SwingUtilities.invokeLater(new Runnable(){
                        NetScanResult scanResult;

                        public Runnable init(NetScanResult netScanResult) {
                            this.scanResult = netScanResult;
                            return this;
                        }

                        @Override
                        public void run() {
                            WSinkDriverPanel.this.mergeScanResult(this.scanResult);
                        }
                    }.init(netScanResult));
                }
            }.runScan(object);
        }
        catch (Throwable throwable) {
            this.findIDNServersItem.setEnabled(true);
            String string = "Network scan setup error";
            ParsecTools.showExceptionDialog(this, string, throwable);
        }
    }

    @Override
    protected JMenuItem createPopupItemNew(UMenuButton uMenuButton, ConfigSchema.Element element) {
        if ((this.modFlags & 2) != 0 && element instanceof ConfigSchema.Module && element.hasModFlags(2)) {
            int n;
            ConfigSchema.Module module = (ConfigSchema.Module)element;
            JMenuItem jMenuItem = super.createPopupItemNew(uMenuButton, element);
            jMenuItem.setText(jMenuItem.getText() + "...");
            ActionListener[] actionListenerArray = jMenuItem.getActionListeners();
            int n2 = n = actionListenerArray == null ? 0 : actionListenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (!(actionListenerArray[i] instanceof UMenuButton.CreatePanelListener)) continue;
                UMenuButton.CreatePanelListener createPanelListener = (UMenuButton.CreatePanelListener)actionListenerArray[i];
                jMenuItem.removeActionListener(createPanelListener);
                jMenuItem.addActionListener(new ActionListener(){
                    UMenuButton.CreatePanelListener cpListener;

                    public ActionListener init(UMenuButton.CreatePanelListener createPanelListener) {
                        this.cpListener = createPanelListener;
                        return this;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WConfigPanel wConfigPanel = this.cpListener.getParentPanel();
                        WConfigPanel wConfigPanel2 = this.cpListener.createChildPanel();
                        if (!(wConfigPanel2 instanceof WModulePanel)) {
                            return;
                        }
                        if (!((WModulePanel)wConfigPanel2).chooseFile(wConfigPanel)) {
                            return;
                        }
                        wConfigPanel.addChildPanel(wConfigPanel2);
                    }
                }.init(createPanelListener));
            }
            return jMenuItem;
        }
        JMenuItem jMenuItem = super.createPopupItemNew(uMenuButton, element);
        return jMenuItem;
    }

    @Override
    protected void addPopupItemsCmd(UMenuButton uMenuButton) {
        super.addPopupItemsCmd(uMenuButton);
        if ((this.modFlags & 1) != 0) {
            this.findIDNServersItem = uMenuButton.addItem(new JMenuItem("Find IDN Servers"));
            this.findIDNServersItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WSinkDriverPanel.this.findIDNServers(null);
                }
            });
        }
    }

    public WSinkDriverPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
    }
}

