/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UFilterButton;
import dexlogic.parsec.config.UPluginCombo;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.remote.WAlertIndicator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class WSinkDSPPanel
extends WConfigPanel {
    private int filterID = this.getSetupProvider().requestFilterID();
    private int inputType = -1;
    private UPluginCombo pluginCombo;
    private WAlertIndicator alertIndicator;
    private UFilterButton filterButton;
    private FilterSpec filterSpec;
    private int outputType = -1;

    private void setFilterSpec(FilterSpec filterSpec) {
        int n;
        if (this.filterSpec == filterSpec) {
            return;
        }
        if (this.filterSpec != null) {
            this.putAttrib("rpc", null);
        }
        this.filterSpec = filterSpec;
        this.outputType = this.inputType;
        Component[] componentArray = this.getStemPanels();
        int n2 = n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof WSinkDSPPanel)) continue;
            ((WSinkDSPPanel)componentArray[i]).setInputType(this.outputType);
        }
        this.filterButton.setFilterSpec(filterSpec);
        this.updateUIState();
        this.resetPopupMenu();
    }

    private void applyInputType() {
        this.pluginCombo.setFilterOptions(this.getSetupProvider().getSinkPluginOptions(this.inputType));
        this.setFilterSpec(this.pluginCombo.getVerifiedFilterSpec());
    }

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.pluginCombo = new UPluginCombo();
        this.pluginCombo.setOpaque(false);
        this.pluginCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WSinkDSPPanel.this.isDisplayable()) {
                    return;
                }
                WSinkDSPPanel.this.setFilterSpec(WSinkDSPPanel.this.pluginCombo.getVerifiedFilterSpec());
                WSinkDSPPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        this.alertIndicator = new WAlertIndicator(this);
        this.filterButton = new UFilterButton("F" + this.filterID, this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.pluginCombo, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.filterButton, gridBagConstraints);
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPanelEnabled();
        this.setCompEnabled(this.pluginCombo, bl);
        boolean bl2 = this.filterSpec != null && this.filterSpec.getDialogClass() != null;
        this.setCompEnabled(this.filterButton, bl && bl2);
    }

    public WSinkDSPPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.ensureLocalObjectAgent();
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
    }

    @Override
    public void discard() {
        super.discard();
        this.filterButton.discardNotify();
        if (this.filterID > 0) {
            this.getSetupProvider().releaseFilterID(this.filterID);
            this.filterID = -1;
        }
    }

    public void setInputType(int n) {
        this.inputType = n;
        if (this.isDisplayable()) {
            this.applyInputType();
        }
    }

    public int getInputType() {
        return this.inputType;
    }

    public String getPluginName() {
        return this.filterButton.getText();
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("style")) {
            this.pluginCombo.putStyleAttrib(string2);
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("style")) {
            return this.pluginCombo.getStyleAttrib();
        }
        return super.getAttrib(string);
    }

    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (wConfigPanel instanceof WSinkDSPPanel) {
            if (this.getStemPanelCount() != 0) {
                return;
            }
        } else {
            return;
        }
        super.addChildPanel(wConfigPanel);
        if (wConfigPanel instanceof WSinkDSPPanel) {
            ((WSinkDSPPanel)wConfigPanel).setInputType(this.outputType);
        }
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.pluginCombo, false);
        }
    }

    @Override
    public void addNotify() {
        this.applyInputType();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.pluginCombo.setFilterOptions(null);
    }
}

