/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WFileChooser;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WModulePanel
extends WConfigPanel {
    private int modFlags;
    private JComponent titleComp;
    private boolean checkedFlag = false;
    private boolean reachableFlag = false;
    public static final int MODFLAG_IDNCLIENT = 1;
    public static final int MODFLAG_IDNWRITER = 2;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JLabel jLabel = null;
        if ((this.modFlags & 2) != 0) {
            jLabel = new JLabel("Stream:");
            jLabel.setOpaque(false);
            this.titleComp = new JTextField(10);
        } else {
            this.titleComp = new JLabel(this.getElementSchema().toString());
            this.titleComp.setOpaque(false);
        }
        if (jLabel != null) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 8);
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.titleComp, gridBagConstraints);
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.getParamLabel(), gridBagConstraints);
    }

    @Override
    protected boolean getParamMutable(ConfigSchema.Param param) {
        File file;
        Object object;
        if (param.getName().equals("title") && (object = this.getSetupValue("path")) != null && (file = new File(object.toString())).exists()) {
            return false;
        }
        return super.getParamMutable(param);
    }

    @Override
    protected void buildParamString(StringBuilder stringBuilder) {
        super.buildParamString(stringBuilder);
        if ((this.modFlags & 1) != 0) {
            if (!this.checkedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;unchecked&nbsp;");
                stringBuilder.append("</span>");
            } else if (this.reachableFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='color:#008000'>");
                stringBuilder.append("&#x2713;");
                stringBuilder.append("</span>");
            } else {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;missing&nbsp;");
                stringBuilder.append("</span>");
            }
        }
    }

    @Override
    protected void addPopupItemsParam(UMenuButton uMenuButton) {
        if ((this.modFlags & 2) != 0) {
            JMenuItem jMenuItem = uMenuButton.addItem(new JMenuItem("Change path..."));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WModulePanel.this.chooseFile(WModulePanel.this);
                }
            });
        }
        super.addPopupItemsParam(uMenuButton);
    }

    public WModulePanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
        this.childIndent = 0;
        this.amendControlPanel(this.getControlPanel());
    }

    public void setChecked(boolean bl) {
        if (!this.checkedFlag || this.reachableFlag != bl) {
            this.checkedFlag = true;
            this.reachableFlag = bl;
            this.updateParamLabel();
        }
    }

    @Override
    public void putSetupValue(String string, Object object) {
        super.putSetupValue(string, object);
        if ((this.modFlags & 1) != 0 && (string.equals("unitID") || string.equals("unitName"))) {
            this.checkedFlag = false;
            this.reachableFlag = false;
            this.updateParamLabel();
        }
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("style")) {
            ConfigSchema.Element element = this.getElementSchema();
            if (element instanceof ConfigSchema.StyledElement) {
                String string3 = ((ConfigSchema.StyledElement)element).getStyle();
                if (!string3.equals(string2)) {
                    throw new IllegalArgumentException("schema(" + string3 + ") / style(" + string2 + ") mismatch");
                }
            } else {
                super.putAttrib(string, string2);
            }
        } else if (string.equals("name")) {
            if ((this.modFlags & 2) != 0) {
                ((JTextField)this.titleComp).setText(ParsecTools.stripString(string2));
            } else {
                super.putAttrib(string, string2);
            }
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("style")) {
            ConfigSchema.Element element = this.getElementSchema();
            if (element instanceof ConfigSchema.StyledElement) {
                return ((ConfigSchema.StyledElement)element).getStyle();
            }
            return super.getAttrib(string);
        }
        if (string.equals("name")) {
            if ((this.modFlags & 2) != 0) {
                return ParsecTools.stripString(((JTextField)this.titleComp).getText());
            }
            return super.getAttrib(string);
        }
        return super.getAttrib(string);
    }

    public boolean chooseFile(JComponent jComponent) {
        int n;
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.setAcceptAllFileFilterUsed(false);
        wFileChooser.addChoosableFileFilter(new RefinedFileFilter("IDN-File Format", ".idn"));
        Object object = this.getSetupValue("path");
        if (object instanceof String) {
            wFileChooser.setSelectedFile(new File((String)object));
        }
        if ((n = wFileChooser.showDialog(jComponent, "Create/Open")) != 0) {
            return false;
        }
        File file = wFileChooser.getSelectedFile();
        if (file == null) {
            return false;
        }
        try {
            String string = file.getPath();
            if (!string.endsWith(".idn")) {
                file = new File(string + ".idn");
                string = file.getPath();
            }
            this.putSetupValue("path", string);
            if (file.exists()) {
                this.putSetupValue("overdub", "true");
                this.putSetupValue("title", null);
            } else {
                this.putSetupValue("overdub", "false");
            }
        }
        catch (Throwable throwable) {
            String string = "File setup error";
            ParsecTools.showExceptionDialog(jComponent, string, throwable);
            return false;
        }
        return true;
    }
}

