/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class WMenuButton
extends JButton {
    private WConfigPanel configPanel;
    private JPopupMenu popupMenu;
    private ArrayList<JMenuItem> onlyChildMenuItems;
    static ImageIcon menuIcon;

    public WMenuButton(final WConfigPanel wConfigPanel) {
        this.configPanel = wConfigPanel;
        if (menuIcon == null) {
            menuIcon = ParsecTools.getImageIcon("/icons/menu-button.png");
        }
        if (menuIcon != null) {
            this.setIcon(menuIcon);
        } else {
            this.setText("M");
        }
        this.setOpaque(false);
        this.setMargin(new Insets(0, 2, 0, 2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (WMenuButton.this.popupMenu == null) {
                    wConfigPanel.buildPopupMenu(WMenuButton.this);
                    if (WMenuButton.this.popupMenu == null) {
                        return;
                    }
                }
                wConfigPanel.updatePopupItems();
                if (WMenuButton.this.onlyChildMenuItems != null) {
                    for (JMenuItem jMenuItem : WMenuButton.this.onlyChildMenuItems) {
                        jMenuItem.setEnabled(wConfigPanel.getBranchPanelCount() <= 0 && wConfigPanel.getStemPanelCount() <= 0);
                    }
                }
                WMenuButton.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void resetPopupMenu() {
        this.popupMenu = null;
    }

    public boolean hasItems() {
        if (this.popupMenu == null) {
            return false;
        }
        return this.popupMenu.getComponentCount() != 0;
    }

    public int getItemCount() {
        if (this.popupMenu == null) {
            return 0;
        }
        return this.popupMenu.getComponentCount();
    }

    public JMenuItem addItem(JMenuItem jMenuItem) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(jMenuItem);
    }

    public JMenuItem addItemNew(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
        JMenuItem jMenuItem = new JMenuItem("New " + element.toString());
        jMenuItem.addActionListener(new CreatePanelListener(wConfigPanel, element));
        if (element.isOnlyChild()) {
            if (this.onlyChildMenuItems == null) {
                this.onlyChildMenuItems = new ArrayList();
            }
            this.onlyChildMenuItems.add(jMenuItem);
        }
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(jMenuItem);
    }

    public JMenuItem addTypeMenuNew(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
        int[] nArray = new int[]{4, 5, 8, 128, 132};
        JMenu jMenu = new JMenu("New " + element.toString());
        for (int i = 0; i < nArray.length; ++i) {
            String string = ParsecTools.getServiceTypeText(nArray[i]);
            String string2 = String.format("%s (serviceType 0x%02X)", string, nArray[i]);
            JMenuItem jMenuItem = jMenu.add(new JMenuItem(string2));
            jMenuItem.addActionListener(new CreatePanelListener(wConfigPanel, element, string));
        }
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(jMenu);
    }

    public JMenuItem addFilterMenuNew(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
        if (!(element instanceof ConfigSchema.FilterDriver)) {
            return null;
        }
        ConfigSchema.FilterDriver filterDriver = (ConfigSchema.FilterDriver)element;
        FilterSpec[] filterSpecArray = filterDriver.getFilterSpecs();
        if (filterSpecArray == null || filterSpecArray.length == 0) {
            return null;
        }
        JMenu jMenu = new JMenu("New " + element.toString());
        for (int i = 0; i < filterSpecArray.length; ++i) {
            String string = filterSpecArray[i].getStyle();
            JMenuItem jMenuItem = jMenu.add(new JMenuItem(string));
            jMenuItem.addActionListener(new CreatePanelListener(wConfigPanel, element, string));
        }
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(jMenu);
    }

    public Component addSeparator() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(new JPopupMenu.Separator());
    }

    public static class CreatePanelListener
    implements ActionListener {
        private WConfigPanel parentPanel;
        private ConfigSchema.Element elementSchema;
        private String style;

        public CreatePanelListener(WConfigPanel wConfigPanel, ConfigSchema.Element element, String string) {
            this.parentPanel = wConfigPanel;
            this.elementSchema = element;
            this.style = string;
        }

        public CreatePanelListener(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
            this(wConfigPanel, element, null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WConfigPanel wConfigPanel = WConfigPanel.createPanel(this.parentPanel.getSetupProvider(), this.elementSchema);
                if (this.style != null) {
                    wConfigPanel.putAttrib("style", this.style);
                }
                this.parentPanel.addChildPanel(wConfigPanel);
            }
            catch (Throwable throwable) {
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.parentPanel);
                ParsecTools.showExceptionDialog(frame, "Panel creation error", throwable);
            }
        }
    }
}

