/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WRoutingPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WJackPanel
extends WRoutingPanel {
    private int modFlags;
    private JCheckBox enabledCheck;
    private JComponent titleComp;
    private JLabel serviceTypeLabel;
    private JToggleButton autoRoutingButton;
    private JToggleButton patchRoutingButton;
    private JSeparator routingSeparator;
    private JLabel patchLabel;
    private boolean checkedFlag = false;
    private boolean reachableFlag = false;
    private boolean appointedFlag = false;
    public static final int MODFLAG_IDNSERVER = 1;
    public static final int MODFLAG_IDNREADER = 16;
    public static final int MODFLAG_WAVREADER = 32;
    public static final int MODFLAG_COLLECTOR = 4096;
    public static final int MODFLAG_READER = 48;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.enabledCheck = new JCheckBox("");
        this.enabledCheck.setOpaque(false);
        this.enabledCheck.setSelected(true);
        this.enabledCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WJackPanel.this.isDisplayable()) {
                    return;
                }
                WJackPanel.this.updateUIState();
                WJackPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        if ((this.modFlags & 1) != 0) {
            this.titleComp = new JTextField(14);
            ((JTextField)this.titleComp).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (!WJackPanel.this.isDisplayable()) {
                        return;
                    }
                    WJackPanel.this.getSetupProvider().setUnsavedWork();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (!WJackPanel.this.isDisplayable()) {
                        return;
                    }
                    WJackPanel.this.getSetupProvider().setUnsavedWork();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (!WJackPanel.this.isDisplayable()) {
                        return;
                    }
                    WJackPanel.this.getSetupProvider().setUnsavedWork();
                }
            });
        } else {
            this.titleComp = new JLabel(this.getElementSchema().toString());
            this.titleComp.setOpaque(false);
        }
        this.serviceTypeLabel = WConfigPanel.createServiceTypeLabel();
        if ((this.modFlags & 0x31) != 0) {
            this.routingSeparator = new JSeparator(1);
            this.routingSeparator.setOpaque(false);
            this.autoRoutingButton = new JToggleButton("Auto");
            this.autoRoutingButton.setOpaque(false);
            this.autoRoutingButton.setMargin(new Insets(0, 4, 0, 4));
            this.autoRoutingButton.setBorderPainted(false);
            this.autoRoutingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!WJackPanel.this.isDisplayable()) {
                        return;
                    }
                    if (WJackPanel.this.getAttrib("patch") != null) {
                        WJackPanel.this.setPatchAttrib(null);
                        WJackPanel.this.getSetupProvider().setUnsavedWork();
                    }
                }
            });
            this.patchRoutingButton = new JToggleButton("Patch");
            this.patchRoutingButton.setOpaque(false);
            this.patchRoutingButton.setMargin(new Insets(0, 4, 0, 4));
            this.patchRoutingButton.setBorderPainted(false);
            this.patchRoutingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!WJackPanel.this.isDisplayable()) {
                        return;
                    }
                    if (WJackPanel.this.getAttrib("patch") == null) {
                        WJackPanel.this.setPatchAttrib("");
                        WJackPanel.this.getSetupProvider().setUnsavedWork();
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.autoRoutingButton);
            buttonGroup.add(this.patchRoutingButton);
            this.autoRoutingButton.setSelected(true);
        } else {
            this.patchLabel = new JLabel("Patch");
            this.patchLabel.setOpaque(false);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)this.enabledCheck, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)this.titleComp, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.serviceTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)this.getParamLabel(), gridBagConstraints);
        if ((this.modFlags & 0x31) != 0) {
            gridBagConstraints.gridx = 16;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 0);
            jPanel.add((Component)this.autoRoutingButton, gridBagConstraints);
            gridBagConstraints.gridx = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            jPanel.add((Component)this.routingSeparator, gridBagConstraints);
            gridBagConstraints.gridx = 18;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add((Component)this.patchRoutingButton, gridBagConstraints);
        } else {
            gridBagConstraints.gridx = 18;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add((Component)this.patchLabel, gridBagConstraints);
        }
    }

    @Override
    protected void buildParamString(StringBuilder stringBuilder) {
        super.buildParamString(stringBuilder);
        if ((this.modFlags & 0x1000) != 0) {
            if (!this.checkedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;unchecked&nbsp;");
                stringBuilder.append("</span>");
            } else if (this.reachableFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='color:#008000'>");
                stringBuilder.append("&#x2713;");
                stringBuilder.append("</span>");
            } else if (!this.appointedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;missing&nbsp;");
                stringBuilder.append("</span>");
            }
        }
    }

    @Override
    protected boolean evalPanelEnabled() {
        return super.evalPanelEnabled() && this.enabledCheck.isSelected();
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPatchConfigurable();
        if (this.autoRoutingButton != null) {
            this.autoRoutingButton.setVisible(bl);
        }
        if (this.routingSeparator != null) {
            this.routingSeparator.setVisible(bl);
        }
        if (this.patchRoutingButton != null) {
            this.patchRoutingButton.setVisible(bl);
        }
        if (this.patchLabel != null) {
            this.patchLabel.setVisible(bl);
        }
        boolean bl2 = this.evalPanelEnabled();
        this.setCompEnabled(this.enabledCheck, true);
        if ((this.modFlags & 1) != 0) {
            this.setCompEnabled(this.titleComp, bl2);
        }
        if (bl) {
            if (this.autoRoutingButton != null) {
                this.setCompEnabled(this.autoRoutingButton, bl2);
            }
            if (this.patchRoutingButton != null) {
                this.setCompEnabled(this.patchRoutingButton, bl2);
            }
        }
    }

    public WJackPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
        if ((this.modFlags & 0x31) != 0) {
            this.setPatchAttrib(null);
        } else {
            this.setPatchAttrib("");
        }
    }

    public void setChecked(boolean bl, boolean bl2) {
        if (!this.checkedFlag || this.reachableFlag != bl || this.appointedFlag != bl2) {
            this.checkedFlag = true;
            this.reachableFlag = bl;
            this.appointedFlag = bl2;
            this.updateParamLabel();
        }
    }

    @Override
    public void putSetupValue(String string, Object object) {
        super.putSetupValue(string, object);
        if ((this.modFlags & 0x1000) != 0 && string.equals("captureID")) {
            this.checkedFlag = false;
            this.reachableFlag = false;
            this.appointedFlag = false;
            this.updateParamLabel();
        }
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("enabled")) {
            boolean bl;
            boolean bl2 = bl = string2 != null && string2.equals("true");
            if (this.enabledCheck.isSelected() != bl) {
                this.enabledCheck.setSelected(bl);
                this.updateUIState();
            }
        } else if (string.equals("name")) {
            if ((this.modFlags & 1) != 0) {
                ((JTextField)this.titleComp).setText(string2);
            } else {
                super.putAttrib(string, string2);
            }
        } else if (string.equals("style")) {
            this.serviceTypeLabel.setText(string2 != null ? string2 : "");
            int n = ParsecTools.getServiceTypeInt(string2);
            this.setPatchType(n);
        } else if (string.equals("patch")) {
            if ((this.modFlags & 0x31) != 0) {
                if (string2 == null) {
                    this.autoRoutingButton.setSelected(true);
                } else {
                    this.patchRoutingButton.setSelected(true);
                }
            }
            super.putAttrib(string, string2);
        } else {
            super.putAttrib(string, string2);
        }
        if ((this.modFlags & 0x30) != 0 && string.equals("name")) {
            ((JCheckBox)this.titleComp).setText(string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("enabled")) {
            return !this.enabledCheck.isSelected() ? "false" : null;
        }
        if (string.equals("name")) {
            if ((this.modFlags & 1) != 0) {
                return ParsecTools.stripString(((JTextField)this.titleComp).getText());
            }
            return super.getAttrib(string);
        }
        if (string.equals("style")) {
            return ParsecTools.stripString(this.serviceTypeLabel.getText());
        }
        return super.getAttrib(string);
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.enabledCheck, false);
            if ((this.modFlags & 1) != 0) {
                this.setCompEnabled(this.titleComp, false);
            }
            if (this.autoRoutingButton != null) {
                this.setCompEnabled(this.autoRoutingButton, false);
            }
            if (this.patchRoutingButton != null) {
                this.setCompEnabled(this.patchRoutingButton, false);
            }
        }
    }
}

