/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.UServiceField;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WRoutingPanel;
import dexlogic.parsec.config.WSourceDSPPanel;
import dexlogic.parsec.remote.WAlertLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class WFilterServicePanel
extends WRoutingPanel {
    private UServiceField serviceField;
    private JLabel inputTypeLabel;
    private WAlertLabel alertLabel;
    private JLabel changeTypeLabel;
    private JLabel outputTypeLabel;
    private JLabel patchLabel;
    private ServiceInfo serviceInfo;
    private FilterSpec filterSpec;
    private int laneIndex;
    private boolean inputTypeLocked;
    private boolean panelOrderLocked;
    private boolean inputOnlyLane;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.serviceField = new UServiceField(this.getSetupProvider());
        this.serviceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WFilterServicePanel.this.isDisplayable()) {
                    return;
                }
                WFilterServicePanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        this.inputTypeLabel = WConfigPanel.createServiceTypeLabel();
        this.alertLabel = new WAlertLabel();
        this.changeTypeLabel = new JLabel(WFilterServicePanel.getChangeIcon());
        this.changeTypeLabel.setVisible(false);
        this.outputTypeLabel = WConfigPanel.createServiceTypeLabel();
        this.outputTypeLabel.setVisible(false);
        this.patchLabel = new JLabel("Patch");
        this.patchLabel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.serviceField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.inputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.alertLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        jPanel.add((Component)this.changeTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)this.outputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.patchLabel, gridBagConstraints);
    }

    void showAlert(String string) {
        this.alertLabel.showAlert(string);
    }

    void setFilterSpec(FilterSpec filterSpec, int n) {
        boolean bl;
        int n2;
        if (this.filterSpec == filterSpec && this.laneIndex == n) {
            return;
        }
        this.filterSpec = filterSpec;
        this.laneIndex = n;
        if (filterSpec != null) {
            int n3 = filterSpec.getLaneInputType(n);
            this.serviceField.setInputType(n3);
            this.inputTypeLabel.setText(ParsecTools.getServiceTypeText(n3));
            this.inputTypeLocked = true;
            this.panelOrderLocked = filterSpec.getLaneCount() >= 0;
            n2 = filterSpec.getLaneOutputType(n);
            boolean bl2 = this.inputOnlyLane = n2 < 0;
            if (n2 > 0) {
                bl = n2 != n3;
                this.outputTypeLabel.setText(ParsecTools.getServiceTypeText(n2));
            } else if (n2 == 0) {
                n2 = n3;
                bl = false;
                this.outputTypeLabel.setText("");
            } else {
                int n4;
                bl = false;
                this.outputTypeLabel.setText("");
                Component[] componentArray = this.getStemPanels();
                int n5 = n4 = componentArray != null ? componentArray.length : 0;
                for (int i = 0; i < n4; ++i) {
                    ((WConfigPanel)componentArray[i]).discard();
                }
            }
        } else {
            this.inputTypeLocked = false;
            this.panelOrderLocked = false;
            n2 = -1;
            this.inputOnlyLane = false;
            bl = false;
            this.outputTypeLabel.setText("");
        }
        this.changeTypeLabel.setVisible(bl);
        this.outputTypeLabel.setVisible(bl);
        this.setPatchType(n2);
        this.updateUIState();
        this.resetPopupMenu();
    }

    @Override
    protected JMenuItem createPopupItemNew(UMenuButton uMenuButton, ConfigSchema.Element element) {
        if (element.getName().equals("plugin") && !this.inputOnlyLane) {
            return super.createPopupItemNew(uMenuButton, element);
        }
        return null;
    }

    @Override
    protected boolean evalPatchConfigurable() {
        return super.evalPatchConfigurable() && !this.inputOnlyLane;
    }

    @Override
    protected boolean evalReorderItemsEnabled() {
        return super.evalReorderItemsEnabled() && !this.panelOrderLocked;
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPatchConfigurable();
        this.patchLabel.setVisible(bl);
        boolean bl2 = this.evalPanelEnabled();
        this.setCompEnabled(this.serviceField, bl2);
    }

    public WFilterServicePanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
        this.setPatchAttrib("");
    }

    @Override
    public void discard() {
        super.discard();
        this.serviceField.setText("");
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("name")) {
            this.serviceField.setText(string2);
        } else if (string.equals("style")) {
            if (!this.inputTypeLocked) {
                this.inputTypeLabel.setText(string2 != null ? string2 : "");
                this.serviceField.setInputType(ParsecTools.getServiceTypeInt(string2));
            }
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("name")) {
            return ParsecTools.stripString(this.serviceField.getText());
        }
        if (string.equals("style")) {
            return ParsecTools.stripString(this.inputTypeLabel.getText());
        }
        return super.getAttrib(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (this.filterSpec != null) {
            if (!(wConfigPanel instanceof WSourceDSPPanel)) return;
            if (this.inputOnlyLane) {
                return;
            }
        } else if (!(wConfigPanel instanceof WSourceDSPPanel)) {
            return;
        }
        super.addChildPanel(wConfigPanel);
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.serviceField, false);
        }
    }
}

