/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UFilterButton;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WBranchPanel;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WDriverPanel;
import dexlogic.parsec.config.WFilterServicePanel;
import dexlogic.parsec.remote.DRCJob;
import dexlogic.parsec.remote.WAlertIndicator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WFilterDriverPanel
extends WDriverPanel {
    private int filterID = this.getSetupProvider().requestFilterID();
    private ChildAuditor branchAuditor;
    private ChildAuditor stemAuditor;
    private JLabel styleLabel;
    private WAlertIndicator alertIndicator;
    private UFilterButton filterButton;
    private FilterSpec filterSpec;

    private FilterSpec findFilterSpec(String string) {
        int n;
        ConfigSchema.FilterDriver filterDriver;
        FilterSpec[] filterSpecArray = null;
        ConfigSchema.Element element = this.getElementSchema();
        if (element instanceof ConfigSchema.FilterDriver && (filterSpecArray = (filterDriver = (ConfigSchema.FilterDriver)element).getFilterSpecs()) != null && filterSpecArray.length == 0) {
            filterSpecArray = null;
        }
        int n2 = n = filterSpecArray == null ? 0 : filterSpecArray.length;
        for (int i = 0; i < n; ++i) {
            if (!filterSpecArray[i].getStyle().equals(string)) continue;
            return filterSpecArray[i];
        }
        return null;
    }

    private WFilterServicePanel findServicePanel(String string) {
        int n;
        if (string == null) {
            return null;
        }
        Component[] componentArray = this.getStemPanels();
        int n2 = n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            WFilterServicePanel wFilterServicePanel;
            if (!(componentArray[i] instanceof WFilterServicePanel) || !string.equals((wFilterServicePanel = (WFilterServicePanel)componentArray[i]).getAttrib("name"))) continue;
            return wFilterServicePanel;
        }
        return null;
    }

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel("--");
        jLabel.setOpaque(false);
        this.styleLabel = new JLabel();
        this.styleLabel.setOpaque(false);
        this.styleLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.alertIndicator = new WAlertIndicator(this){

            @Override
            protected void alertInvoked(DRCJob dRCJob) {
                String string = dRCJob.getStringParam("refName");
                String string2 = dRCJob.getStringParam("info");
                WFilterServicePanel wFilterServicePanel = WFilterDriverPanel.this.findServicePanel(string);
                if (wFilterServicePanel != null) {
                    wFilterServicePanel.showAlert(string2);
                } else {
                    this.showAlert(string2);
                }
            }
        };
        this.filterButton = new UFilterButton("F" + this.filterID, this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.styleLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.filterButton, gridBagConstraints);
    }

    @Override
    protected void verifyConfig() {
        super.verifyConfig();
        if (this.filterSpec != null) {
            this.styleLabel.setOpaque(false);
            this.styleLabel.setBackground(null);
            this.branchAuditor.checkContainer();
            this.stemAuditor.checkContainer();
        } else {
            int n;
            int n2;
            this.styleLabel.setOpaque(true);
            this.styleLabel.setBackground(new Color(255, 180, 180));
            Component[] componentArray = this.getBranchPanels();
            int n3 = n2 = componentArray != null ? componentArray.length : 0;
            for (int i = 0; i < n2; ++i) {
                if (!(componentArray[i] instanceof WBranchPanel)) continue;
                ((WBranchPanel)componentArray[i]).setFilterSpec(null, -1);
            }
            Component[] componentArray2 = this.getStemPanels();
            int n4 = n = componentArray2 != null ? componentArray2.length : 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (!(componentArray2[n2] instanceof WFilterServicePanel)) continue;
                ((WFilterServicePanel)componentArray2[n2]).setFilterSpec(null, -1);
            }
        }
    }

    @Override
    protected JMenuItem createPopupItemNew(UMenuButton uMenuButton, ConfigSchema.Element element) {
        if (element.getName().equals("branch")) {
            if (this.filterSpec == null || this.filterSpec.getBranchCount() < 0) {
                return super.createPopupItemNew(uMenuButton, element);
            }
        } else if (element.getName().equals("service")) {
            if (this.filterSpec == null) {
                return super.createPopupItemNew(uMenuButton, element);
            }
            if (this.filterSpec.getLaneCount() < 0) {
                return uMenuButton.addItemNew(this, element);
            }
        }
        return null;
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPanelEnabled();
        boolean bl2 = this.filterSpec != null && this.filterSpec.getDialogClass() != null;
        this.setCompEnabled(this.filterButton, bl && bl2);
    }

    public WFilterDriverPanel(final SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.ensureLocalObjectAgent();
        this.amendControlPanel(this.getControlPanel());
        this.branchAuditor = new ChildAuditor(){

            @Override
            public int getChannelCount() {
                return WFilterDriverPanel.this.filterSpec.getBranchCount();
            }

            @Override
            public int getChannelType(int n) {
                return WFilterDriverPanel.this.filterSpec.getBranchOutputType(n);
            }

            @Override
            public int getPanelCount() {
                return WFilterDriverPanel.this.getBranchPanelCount();
            }

            @Override
            public WConfigPanel getPanel(int n) {
                return WFilterDriverPanel.this.getBranchPanel(n);
            }

            @Override
            public void bindPanel(WConfigPanel wConfigPanel, int n) {
                if (wConfigPanel instanceof WBranchPanel) {
                    ((WBranchPanel)wConfigPanel).setFilterSpec(WFilterDriverPanel.this.filterSpec, n);
                }
            }

            @Override
            public void createPanel() {
                ConfigSchema.Element element = WFilterDriverPanel.this.getElementSchema().getChildSchema("branch");
                try {
                    WFilterDriverPanel.this.addChildPanel(WConfigPanel.createPanel(setupProvider, element));
                }
                catch (ParsecException parsecException) {
                    parsecException.printStackTrace();
                }
            }
        };
        this.stemAuditor = new ChildAuditor(){

            @Override
            public int getChannelCount() {
                return WFilterDriverPanel.this.filterSpec.getLaneCount();
            }

            @Override
            public int getChannelType(int n) {
                return WFilterDriverPanel.this.filterSpec.getLaneInputType(n);
            }

            @Override
            public int getPanelCount() {
                return WFilterDriverPanel.this.getStemPanelCount();
            }

            @Override
            public WConfigPanel getPanel(int n) {
                return WFilterDriverPanel.this.getStemPanel(n);
            }

            @Override
            public void bindPanel(WConfigPanel wConfigPanel, int n) {
                if (wConfigPanel instanceof WFilterServicePanel) {
                    ((WFilterServicePanel)wConfigPanel).setFilterSpec(WFilterDriverPanel.this.filterSpec, n);
                }
            }

            @Override
            public void createPanel() {
                ConfigSchema.Element element = WFilterDriverPanel.this.getElementSchema().getChildSchema("service");
                try {
                    WFilterDriverPanel.this.addChildPanel(WConfigPanel.createPanel(setupProvider, element));
                }
                catch (ParsecException parsecException) {
                    parsecException.printStackTrace();
                }
            }
        };
    }

    @Override
    public void discard() {
        super.discard();
        this.filterButton.discardNotify();
        if (this.filterID > 0) {
            this.getSetupProvider().releaseFilterID(this.filterID);
            this.filterID = -1;
        }
    }

    @Override
    public void putAttrib(String string, String string2) {
        super.putAttrib(string, string2);
        if (string.equals("style")) {
            this.styleLabel.setText(string2);
            if (this.filterSpec != null) {
                this.putAttrib("rpc", null);
            }
            this.filterSpec = this.findFilterSpec(string2);
            this.filterButton.setFilterSpec(this.filterSpec);
            if (this.getParent() != null) {
                this.verifyConfig();
            }
            this.resetPopupMenu();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (this.filterSpec != null) {
            if (wConfigPanel instanceof WBranchPanel) {
                if (!this.branchAuditor.checkPanel(wConfigPanel, this.getBranchPanelCount())) {
                    return;
                }
            } else {
                if (!(wConfigPanel instanceof WFilterServicePanel)) return;
                if (!this.stemAuditor.checkPanel(wConfigPanel, this.getStemPanelCount())) {
                    return;
                }
            }
        } else if (wConfigPanel instanceof WBranchPanel) {
            ((WBranchPanel)wConfigPanel).setFilterSpec(null, -1);
        } else {
            if (!(wConfigPanel instanceof WFilterServicePanel)) return;
            ((WFilterServicePanel)wConfigPanel).setFilterSpec(null, -1);
        }
        super.addChildPanel(wConfigPanel);
    }

    public static abstract class ChildAuditor {
        public abstract int getChannelCount();

        public abstract int getChannelType(int var1);

        public abstract int getPanelCount();

        public abstract WConfigPanel getPanel(int var1);

        public abstract void bindPanel(WConfigPanel var1, int var2);

        public abstract void createPanel();

        public boolean checkPanel(WConfigPanel wConfigPanel, int n) {
            int n2 = this.getChannelType(n);
            if (n2 < 0 || wConfigPanel == null) {
                return false;
            }
            this.bindPanel(wConfigPanel, n);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void checkContainer() {
            int n = 0;
            int n2 = this.getChannelCount();
            while (true) {
                block4: {
                    if (n < this.getPanelCount()) {
                        if (n2 < 0 || n < n2) {
                            this.checkPanel(this.getPanel(n), n);
                            break block4;
                        } else {
                            WConfigPanel wConfigPanel = this.getPanel(n);
                            if (wConfigPanel == null) continue;
                            wConfigPanel.discard();
                            continue;
                        }
                    }
                    if ((n2 >= 0 || n >= 1) && (n2 < 0 || n >= n2)) break;
                    this.createPanel();
                }
                ++n;
            }
        }
    }
}

