/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WMenuButton;
import dexlogic.parsec.routes.SetupArgIO;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;

public class WElementPanel
extends WConfigPanel {
    private SetupProvider setupProvider;
    private ConfigSchema.Element elementSchema;
    private Map<String, String> attribMap;
    private Map<String, SetupParam> setupMap;
    private JLabel paramLabel;
    static final int SERVICEID_COLUMN_COUNT = 14;

    @Override
    private void updateParamLabel() {
        if (this.paramLabel == null || this.setupMap == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, SetupParam> entry : this.setupMap.entrySet()) {
            SetupParam setupParam = entry.getValue();
            if (!setupParam.getParamSchema().isOutline()) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(setupParam.getName());
            stringBuilder.append(":");
            stringBuilder.append(setupParam.currentValue);
        }
        this.paramLabel.setText(stringBuilder.toString());
    }

    @Override
    protected void dumpAttribMap() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.attribMap != null) {
            for (Map.Entry<String, String> entry : this.attribMap.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("='");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("'");
            }
        }
        System.out.println(stringBuilder.toString());
    }

    protected JLabel getParameterLabel() {
        if (this.paramLabel == null) {
            this.paramLabel = WElementPanel.createParameterLabel();
            this.paramLabel.setOpaque(false);
            this.updateParamLabel();
        }
        return this.paramLabel;
    }

    protected void addPopupItemsNew(WMenuButton wMenuButton) {
        ConfigSchema.Element[] elementArray = this.elementSchema.getChildSchemas();
        if (elementArray != null) {
            for (ConfigSchema.Element element : elementArray) {
                if (element == null) {
                    wMenuButton.addSeparator();
                    continue;
                }
                if (element.isConcealed() || element.isDesignated()) continue;
                wMenuButton.addCreateItem("New " + element.toString(), this, element);
            }
        }
    }

    public WElementPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        if (setupProvider == null) {
            throw new IllegalArgumentException("Invalid setup provider parameter");
        }
        this.setupProvider = setupProvider;
        if (element == null) {
            throw new IllegalArgumentException("Invalid schema item parameter");
        }
        this.elementSchema = element;
        ConfigSchema.Param[] paramArray = element.getParams();
        if (paramArray != null) {
            for (ConfigSchema.Param param : paramArray) {
                if (this.setupMap == null) {
                    this.setupMap = new LinkedHashMap<String, SetupParam>();
                }
                this.setupMap.put(param.getName(), new SetupParam(param));
            }
        }
    }

    @Override
    public SetupProvider getSetupProvider() {
        return this.setupProvider;
    }

    @Override
    public ConfigSchema.Element getElementSchema() {
        return this.elementSchema;
    }

    @Override
    public void putSetupValue(String string, Object object) {
        SetupParam setupParam = null;
        if (this.setupMap != null) {
            setupParam = this.setupMap.get(string);
        }
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        setupParam.currentValue = object;
        if (setupParam.getParamSchema().isOutline()) {
            this.updateParamLabel();
        }
    }

    @Override
    public Object getSetupValue(String string) {
        SetupParam setupParam = null;
        if (this.setupMap != null) {
            setupParam = this.setupMap.get(string);
        }
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        return setupParam.currentValue;
    }

    @Override
    public void putAttrib(String string, String string2) throws ParsecException {
        if (string.equals("setup")) {
            SetupArgIO.readArg(string2, new SetupArgIO(){

                @Override
                public void processParam(String string, String string2) {
                    WElementPanel.this.putSetupValue(string, string2);
                }
            });
        } else {
            if (this.attribMap == null) {
                this.attribMap = new HashMap<String, String>();
            }
            this.attribMap.put(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("setup")) {
            if (this.setupMap == null || this.setupMap.size() == 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, SetupParam> entry : this.setupMap.entrySet()) {
                SetupParam setupParam = entry.getValue();
                ConfigSchema.Param param = setupParam.getParamSchema();
                Object object = param.getDefaultValue();
                if (object != null && object == setupParam.currentValue) continue;
                SetupArgIO.writeParam(stringBuilder, setupParam.getName(), setupParam.currentValue);
            }
            return stringBuilder.toString();
        }
        if (this.attribMap == null) {
            return null;
        }
        return this.attribMap.get(string);
    }

    static JLabel createParameterLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 0, font.getSize() - 1));
        jLabel.setForeground(new Color(48, 96, 80));
        return jLabel;
    }

    public static JLabel createServiceTypeLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 2, font.getSize() - 1));
        jLabel.setForeground(new Color(128, 128, 192));
        return jLabel;
    }

    public static WElementPanel createPanel(SetupProvider setupProvider, ConfigSchema.Element element) throws ParsecException {
        try {
            Constructor<?> constructor = element.getPanelClass().getConstructor(SetupProvider.class, ConfigSchema.Element.class);
            Object obj = constructor.newInstance(setupProvider, element);
            if (obj instanceof WElementPanel) {
                return (WElementPanel)obj;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalParsecException("No suitable constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            ParsecException parsecException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                throw new ParsecException("InvocationTargetException without cause");
            }
            if (throwable instanceof GenericParsecException) {
                parsecException = new GenericParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else if (throwable instanceof ParsecException) {
                parsecException = new ParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else {
                parsecException = new ParsecException(throwable.getMessage());
            }
            parsecException.initCause(invocationTargetException.getCause());
            throw parsecException;
        }
        catch (Throwable throwable) {
            InternalParsecException internalParsecException = new InternalParsecException("Instantiation exception");
            internalParsecException.initCause(throwable.getCause());
            throw internalParsecException;
        }
        return null;
    }

    public static class SetupParam {
        ConfigSchema.Param paramSchema;
        Object currentValue;

        public SetupParam(ConfigSchema.Param param) {
            this.paramSchema = param;
            this.currentValue = param.getDefaultValue();
        }

        public String getName() {
            return this.paramSchema.getName();
        }

        public ConfigSchema.Param getParamSchema() {
            return this.paramSchema;
        }
    }
}

