/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WRoutingPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WBranchPanel
extends WRoutingPanel {
    private JLabel titleLabel;
    private JLabel outputTypeLabel;
    private JLabel patchLabel;
    private FilterSpec filterSpec;
    private int branchIndex;
    private boolean panelOrderLocked;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.titleLabel = new JLabel();
        this.titleLabel.setOpaque(false);
        this.outputTypeLabel = WConfigPanel.createServiceTypeLabel();
        this.patchLabel = new JLabel("Patch");
        this.patchLabel.setOpaque(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        jPanel.add((Component)this.outputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 18;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.patchLabel, gridBagConstraints);
    }

    void setFilterSpec(FilterSpec filterSpec, int n) {
        int n2;
        if (this.filterSpec == filterSpec && this.branchIndex == n) {
            return;
        }
        this.filterSpec = filterSpec;
        this.branchIndex = n;
        if (filterSpec != null) {
            String string = filterSpec.getBranchTitle(n);
            this.titleLabel.setText(string != null ? string : "");
            n2 = filterSpec.getBranchOutputType(n);
            this.outputTypeLabel.setText(ParsecTools.getServiceTypeText(n2));
            this.panelOrderLocked = filterSpec.getBranchCount() >= 0;
        } else {
            this.panelOrderLocked = false;
            n2 = -1;
            this.outputTypeLabel.setText("");
        }
        this.setPatchType(n2);
    }

    @Override
    protected boolean evalReorderItemsEnabled() {
        return super.evalReorderItemsEnabled() && !this.panelOrderLocked;
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPatchConfigurable();
        this.patchLabel.setVisible(bl);
    }

    public WBranchPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
        this.setPatchAttrib("");
    }
}

