/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.RefinedCBEditor;
import dexlogic.parsec.RefinedCBModel;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.ServiceListener;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class UPatchCombo
extends JComboBox<ServiceInfo>
implements ServiceListener {
    private boolean optionsValid = false;
    private ServiceInfo verifiedOption;
    private ServiceList[] serviceLists;

    public void verifyAndSelect(Object object) {
        RefinedCBModel refinedCBModel = (RefinedCBModel)this.getModel();
        ServiceInfo serviceInfo = null;
        if (object != null) {
            int n = refinedCBModel.getSize();
            for (int i = 0; i < n; ++i) {
                ServiceInfo serviceInfo2 = (ServiceInfo)refinedCBModel.getElementAt(i);
                if (!object.toString().equals(serviceInfo2.toString())) continue;
                serviceInfo = serviceInfo2;
                break;
            }
        }
        this.verifiedOption = serviceInfo;
        Object object2 = refinedCBModel.getSelectedItem();
        if (this.verifiedOption != null && object2 != this.verifiedOption) {
            if (this.verifiedOption.equals(object2)) {
                refinedCBModel.setSelectedItem(this.verifiedOption);
            } else {
                super.setSelectedItem(this.verifiedOption);
            }
        } else if (object != object2) {
            super.setSelectedItem(object);
        }
        Component component = this.getEditor().getEditorComponent();
        if (this.verifiedOption != null) {
            component.setBackground(new Color(11071656));
        } else if (object == null || !this.optionsValid) {
            component.setBackground(null);
        } else {
            component.setBackground(new Color(0xFFA0A0));
        }
    }

    public UPatchCombo() {
        super(new RefinedCBModel<ServiceInfo>(new ServiceInfo[]{new VoidServiceInfo()}));
        this.setEditable(true);
        this.setEditor(new RefinedCBEditor());
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        jTextField.setEditable(false);
    }

    public void setPatchOptions(ServiceList[] serviceListArray) {
        int n;
        RefinedCBModel refinedCBModel = (RefinedCBModel)this.getModel();
        if (this.serviceLists != null) {
            for (ServiceList serviceList : this.serviceLists) {
                serviceList.removeListener(this);
            }
        }
        if ((n = refinedCBModel.getSize()) > 1) {
            refinedCBModel.removeRange(1, n);
        }
        this.serviceLists = serviceListArray;
        if (this.serviceLists != null) {
            for (ServiceList serviceList : this.serviceLists) {
                refinedCBModel.addAll(serviceList.getList());
                serviceList.addListener(this);
            }
            this.optionsValid = true;
        } else {
            this.optionsValid = false;
        }
        this.verifyAndSelect(this.getSelectedItem());
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object instanceof String && ((String)object).strip().length() == 0) {
            object = this.dataModel.getElementAt(0);
        }
        this.verifyAndSelect(object);
    }

    @Override
    public void serviceChanged(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
        RefinedCBModel refinedCBModel = (RefinedCBModel)this.getModel();
        if (serviceInfo != null) {
            if (serviceInfo2 != null) {
                refinedCBModel.replaceElement(serviceInfo, serviceInfo2);
            } else {
                refinedCBModel.removeElement(serviceInfo);
            }
        } else if (serviceInfo2 != null) {
            refinedCBModel.addElement(serviceInfo2);
        }
        if (this.verifiedOption == null || this.verifiedOption != null && this.verifiedOption.equals(serviceInfo)) {
            this.verifyAndSelect(refinedCBModel.getSelectedItem());
        }
    }

    public static class VoidServiceInfo
    extends ServiceInfo {
        public VoidServiceInfo() {
            super("void", 0);
        }
    }
}

