/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class UMenuButton
extends JButton {
    private WConfigPanel configPanel;
    private JPopupMenu popupMenu;
    private boolean[] itemEnables;
    private ArrayList<JMenuItem> onlyChildMenuItems;
    static ImageIcon menuIcon;

    public UMenuButton(final WConfigPanel wConfigPanel) {
        this.configPanel = wConfigPanel;
        if (menuIcon == null) {
            menuIcon = ParsecTools.getImageIcon("/icons/menu-button.png");
        }
        if (menuIcon != null) {
            this.setIcon(menuIcon);
        } else {
            this.setText("M");
        }
        this.setOpaque(false);
        this.setMargin(new Insets(0, 2, 0, 2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (UMenuButton.this.popupMenu == null) {
                    wConfigPanel.buildPopupMenu(UMenuButton.this);
                    if (UMenuButton.this.popupMenu == null) {
                        return;
                    }
                    Component[] componentArray = UMenuButton.this.popupMenu.getComponents();
                    int n3 = componentArray == null ? 0 : componentArray.length;
                    UMenuButton.this.itemEnables = new boolean[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        UMenuButton.this.itemEnables[n2] = componentArray[n2].isEnabled();
                    }
                }
                boolean bl = wConfigPanel.evalPanelEnabled();
                Component[] componentArray = UMenuButton.this.popupMenu.getComponents();
                int n4 = n = componentArray == null ? 0 : componentArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    if (bl) {
                        componentArray[n2].setEnabled(UMenuButton.this.itemEnables[n2]);
                        continue;
                    }
                    componentArray[n2].setEnabled(false);
                }
                wConfigPanel.updatePopupItems();
                if (UMenuButton.this.onlyChildMenuItems != null && wConfigPanel.getStemPanelCount() != 0) {
                    for (JMenuItem jMenuItem : UMenuButton.this.onlyChildMenuItems) {
                        jMenuItem.setEnabled(false);
                    }
                }
                UMenuButton.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void resetPopupMenu() {
        this.popupMenu = null;
    }

    public boolean hasItems() {
        if (this.popupMenu == null) {
            return false;
        }
        return this.popupMenu.getComponentCount() != 0;
    }

    public int getItemCount() {
        if (this.popupMenu == null) {
            return 0;
        }
        return this.popupMenu.getComponentCount();
    }

    public Component addSeparator() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(new JPopupMenu.Separator());
    }

    public void insertSeparator(int n) {
        if (n <= 0) {
            return;
        }
        if (this.getItemCount() == n) {
            return;
        }
        this.popupMenu.add((Component)new JPopupMenu.Separator(), n);
    }

    public JMenuItem addItem(JMenuItem jMenuItem) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        return this.popupMenu.add(jMenuItem);
    }

    public JMenuItem addItemNew(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
        JMenuItem jMenuItem;
        if (element instanceof ConfigSchema.TypedElement) {
            int[] nArray = ((ConfigSchema.TypedElement)element).getTypes();
            if (nArray == null) {
                jMenuItem = new JMenuItem("New " + element.getTitle());
                jMenuItem.addActionListener(new CreatePanelListener(wConfigPanel, element));
            } else {
                jMenuItem = new JMenu("New " + element.getTitle());
                JMenu jMenu = jMenuItem;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] < 0) continue;
                    String string = ParsecTools.getServiceTypeText(nArray[i]);
                    String string2 = String.format("%s (serviceType 0x%02X)", string, nArray[i]);
                    JMenuItem jMenuItem2 = jMenu.add(new JMenuItem(string2));
                    jMenuItem2.addActionListener(new CreatePanelListener(wConfigPanel, element, string));
                }
            }
        } else if (element instanceof ConfigSchema.FilterDriver) {
            ConfigSchema.FilterDriver filterDriver = (ConfigSchema.FilterDriver)element;
            FilterSpec[] filterSpecArray = filterDriver.getFilterSpecs();
            if (filterSpecArray == null || filterSpecArray.length == 0) {
                return null;
            }
            jMenuItem = new JMenu("New " + element.getTitle());
            JMenu jMenu = jMenuItem;
            for (int i = 0; i < filterSpecArray.length; ++i) {
                FilterSpec filterSpec = filterSpecArray[i];
                String string = filterSpec.getStyle();
                JMenuItem jMenuItem3 = jMenu.add(new JMenuItem(string));
                jMenuItem3.addActionListener(new CreatePanelListener(wConfigPanel, element, string));
            }
        } else {
            jMenuItem = new JMenuItem("New " + element.getTitle());
            jMenuItem.addActionListener(new CreatePanelListener(wConfigPanel, element));
            if (element.isOnlyChild()) {
                if (this.onlyChildMenuItems == null) {
                    this.onlyChildMenuItems = new ArrayList();
                }
                this.onlyChildMenuItems.add(jMenuItem);
            }
        }
        return this.addItem(jMenuItem);
    }

    public static class CreatePanelListener
    implements ActionListener {
        private WConfigPanel parentPanel;
        private ConfigSchema.Element elementSchema;
        private String style;

        public CreatePanelListener(WConfigPanel wConfigPanel, ConfigSchema.Element element, String string) {
            this.parentPanel = wConfigPanel;
            this.elementSchema = element;
            this.style = string;
        }

        public CreatePanelListener(WConfigPanel wConfigPanel, ConfigSchema.Element element) {
            this(wConfigPanel, element, null);
        }

        public WConfigPanel getParentPanel() {
            return this.parentPanel;
        }

        public WConfigPanel createChildPanel() {
            WConfigPanel wConfigPanel;
            try {
                wConfigPanel = WConfigPanel.createPanel(this.parentPanel.getSetupProvider(), this.elementSchema);
                if (this.style != null) {
                    wConfigPanel.putAttrib("style", this.style);
                }
            }
            catch (Throwable throwable) {
                String string = "Panel creation error";
                ParsecTools.showExceptionDialog(this.parentPanel, string, throwable);
                wConfigPanel = null;
            }
            return wConfigPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WConfigPanel wConfigPanel = this.createChildPanel();
            if (wConfigPanel != null) {
                this.parentPanel.addChildPanel(wConfigPanel);
            }
        }
    }
}

