/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.remote.ObjectRemotable;
import dexlogic.parsec.remote.WFilterDialog;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class UFilterButton
extends JButton {
    private ObjectRemotable remotable;
    private WFilterDialog filterDialog;
    private FilterSpec filterSpec;

    private void hideDialog() {
        if (this.filterDialog != null && this.filterDialog.isVisible()) {
            this.filterDialog.setVisible(false);
        }
    }

    private void discardDialog() {
        if (this.filterDialog != null) {
            this.filterDialog.dispose();
            this.filterDialog = null;
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.filterDialog != null && !this.isShowing()) {
            this.hideDialog();
        }
        super.processHierarchyEvent(hierarchyEvent);
    }

    public UFilterButton(String string, final ObjectRemotable objectRemotable) {
        super(string);
        this.remotable = objectRemotable;
        this.setOpaque(false);
        this.setMargin(new Insets(0, 2, 0, 2));
        this.setIcon(WConfigPanel.getSettingsIcon());
        this.enableEvents(32768L);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UFilterButton.this.filterDialog != null) {
                    UFilterButton.this.filterDialog.setVisible(true);
                    UFilterButton.this.filterDialog.requestFocus();
                } else {
                    if (UFilterButton.this.filterSpec == null) {
                        return;
                    }
                    Class<?> clazz = UFilterButton.this.filterSpec.getDialogClass();
                    if (clazz == null) {
                        return;
                    }
                    try {
                        Constructor<?> constructor = clazz.getConstructor(Window.class, String.class, ObjectRemotable.class);
                        Window window = SwingUtilities.getWindowAncestor(UFilterButton.this);
                        Object obj = constructor.newInstance(window, UFilterButton.this.getText(), objectRemotable);
                        if (!(obj instanceof WFilterDialog)) {
                            return;
                        }
                        UFilterButton.this.filterDialog = (WFilterDialog)obj;
                        UFilterButton.this.filterDialog.pack();
                        UFilterButton.this.filterDialog.setVisible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void setFilterSpec(FilterSpec filterSpec) {
        if (this.filterSpec == filterSpec) {
            return;
        }
        this.discardDialog();
        this.filterSpec = filterSpec;
    }

    public void discardNotify() {
        this.discardDialog();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.hideDialog();
        }
    }
}

