/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.DLNDrainSet;
import dexlogic.io.dln.packets.DLNDrainRouteReqPacket;
import dexlogic.io.dln.packets.DLNDrainRouteRspPacket;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.SetupArgIO;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.ConfigXMLWriter;
import dexlogic.parsec.config.DefaultPortSocketAddress;
import dexlogic.parsec.config.PluginStyle;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WFeedPanel;
import dexlogic.parsec.config.WJackPanel;
import dexlogic.parsec.config.WModulePanel;
import dexlogic.parsec.config.WSinkDSPPanel;
import dexlogic.parsec.config.WSinkServicePanel;
import dexlogic.parsec.config.WSourceDSPPanel;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.config.WTrunkPanel;
import dexlogic.parsec.routes.FlowLogger;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.FlowProxyEditor;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.ProxyStateHandler;
import java.awt.Component;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SystemProxyBuilder
implements FlowProxyBuilder {
    private WSystemPanel systemPanel;

    public SystemProxyBuilder(WSystemPanel wSystemPanel) {
        this.systemPanel = wSystemPanel;
    }

    @Override
    public void buildFlowProxy(FlowProxyEditor flowProxyEditor) throws ParsecException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        XMLWriter xMLWriter = new XMLWriter(flowProxyEditor);
        Component[] componentArray = this.systemPanel.getStemPanels();
        int n2 = n = componentArray == null ? 0 : componentArray.length;
        for (int i = 0; i < n; ++i) {
            xMLWriter.writePanel("  ", stringBuilder, (WConfigPanel)componentArray[i]);
        }
        stringBuilder.append((CharSequence)xMLWriter.sbFlt);
        stringBuilder.insert(0, "<dxcSetup>\n");
        stringBuilder.append("</dxcSetup>");
        if (xMLWriter.feedHandler != null) {
            flowProxyEditor.addStateHandler(xMLWriter.feedHandler);
        }
        flowProxyEditor.setXML(stringBuilder.toString());
    }

    private static class XMLWriter
    extends ConfigXMLWriter {
        private FlowProxyEditor flowProxyEditor;
        private byte[] serviceAlloc = null;
        private FeedHandler feedHandler;
        public StringBuilder sbFlt = new StringBuilder();

        private void buildPlugin(String string, int n, ConfigXMLWriter.ElementBody elementBody) {
            if (elementBody.branchPanels != null || elementBody.stemPanels != null) {
                throw new IllegalArgumentException("Flattened plugin has child panels");
            }
            String string2 = elementBody.attributes.remove("patch");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  <filterDriver");
            for (Map.Entry<String, String> entry : elementBody.attributes.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                if (string3.equals("style")) {
                    PluginStyle pluginStyle = new PluginStyle(string4);
                    String string5 = pluginStyle.getDriverID();
                    if (string5 != null) {
                        stringBuilder.append(" driverID='").append(string5).append("'");
                    }
                    string4 = pluginStyle.getStyle();
                }
                if (string4 == null) continue;
                stringBuilder.append(" ");
                stringBuilder.append(string3);
                stringBuilder.append("='");
                stringBuilder.append(string4);
                stringBuilder.append("'");
            }
            stringBuilder.append(">\n");
            stringBuilder.append("    <service");
            stringBuilder.append(" name='").append(string).append("'");
            stringBuilder.append(" style='").append(ParsecTools.getServiceTypeText(n)).append("'");
            if (string2 != null) {
                stringBuilder.append(" patch='").append(string2).append("'");
            }
            stringBuilder.append(" />\n");
            stringBuilder.append("  </filterDriver>\n");
            this.sbFlt.append((CharSequence)stringBuilder);
        }

        private void writeListeners(String string, StringBuilder stringBuilder, String string2, InetSocketAddress inetSocketAddress, Component[] componentArray, int n) {
            int n2;
            int n3 = 1;
            int n4 = n2 = componentArray == null ? 0 : componentArray.length;
            while (n < n2) {
                Object object;
                WConfigPanel wConfigPanel = (WConfigPanel)componentArray[n];
                if (wConfigPanel.getAttrib("enabled") == null && (object = wConfigPanel.getSetupValue("remoteAddress")) instanceof DefaultPortSocketAddress) {
                    int n5;
                    InetSocketAddress inetSocketAddress2 = ((DefaultPortSocketAddress)object).getInetSocketAddress();
                    DrainRequest drainRequest = new DrainRequest(inetSocketAddress2, inetSocketAddress);
                    Component[] componentArray2 = wConfigPanel.getStemPanels();
                    int n6 = n5 = componentArray2 == null ? 0 : componentArray2.length;
                    for (int i = 0; i < n5; ++i) {
                        WConfigPanel wConfigPanel2;
                        if (!(componentArray2[i] instanceof WConfigPanel) || !(wConfigPanel2 = (WConfigPanel)componentArray2[i]).getElementSchema().getName().equals("capture") || wConfigPanel2.getAttrib("enabled") != null) continue;
                        Object object2 = wConfigPanel2.getSetupValue("captureID");
                        int n7 = 0;
                        if (object2 instanceof Integer) {
                            n7 = (Integer)object2;
                        } else if (object2 != null) continue;
                        if (n7 < 0 || n7 > 255) continue;
                        ConfigXMLWriter.ElementBody elementBody = new ConfigXMLWriter.ElementBody(wConfigPanel2);
                        this.getAttributes(wConfigPanel2, elementBody);
                        String string3 = elementBody.attributes.get("patch");
                        if (string3 == null || string3.isEmpty()) continue;
                        drainRequest.addCapture(n7, n3);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        SetupArgIO.writeParam(stringBuilder2, "serviceID", n3);
                        elementBody.attributes.put("setup", stringBuilder2.toString());
                        ++n3;
                        elementBody.elementName = "jack";
                        this.writeElement(string, stringBuilder, elementBody);
                    }
                    if (drainRequest.hasCaptureRoutes()) {
                        if (this.feedHandler == null) {
                            this.feedHandler = new FeedHandler();
                        }
                        this.feedHandler.addDrainRequest(drainRequest);
                    }
                }
                componentArray[n] = null;
                ++n;
                while (!(n >= n2 || componentArray[n] instanceof WConfigPanel && (wConfigPanel = (WConfigPanel)componentArray[n]).getElementSchema().getName().equals("listener") && ParsecTools.compareString(string2, (String)(object = ((WConfigPanel)componentArray[n]).getAttrib("style"))))) {
                    ++n;
                }
            }
        }

        @Override
        protected String buildSourcePlugin(WSourceDSPPanel wSourceDSPPanel) {
            String string = wSourceDSPPanel.getAttrib("enabled");
            if (string != null) {
                return "";
            }
            ConfigXMLWriter.ElementBody elementBody = new ConfigXMLWriter.ElementBody(wSourceDSPPanel);
            this.getAttributes(wSourceDSPPanel, elementBody);
            String string2 = wSourceDSPPanel.getPluginName();
            this.buildPlugin(string2, wSourceDSPPanel.getInputType(), elementBody);
            return string2;
        }

        @Override
        protected String buildSinkPlugin(String string, WSinkDSPPanel wSinkDSPPanel) {
            String string2;
            ConfigXMLWriter.ElementBody elementBody = new ConfigXMLWriter.ElementBody(wSinkDSPPanel);
            this.getAttributes(wSinkDSPPanel, elementBody);
            Component[] componentArray = elementBody.stemPanels;
            elementBody.stemPanels = null;
            String string3 = elementBody.attributes.get("style");
            if (string3 == null || string3.equals("transparent")) {
                string2 = string;
            } else {
                string2 = wSinkDSPPanel.getPluginName();
                elementBody.attributes.put("patch", string2);
                this.buildPlugin(string, wSinkDSPPanel.getInputType(), elementBody);
            }
            if (componentArray != null) {
                if (componentArray.length == 1 && componentArray[0] instanceof WSinkDSPPanel) {
                    string2 = this.buildSinkPlugin(string2, (WSinkDSPPanel)componentArray[0]);
                } else {
                    throw new IllegalArgumentException("Invalid panel structure");
                }
            }
            return string2;
        }

        @Override
        protected String resolveAutoPatch(WConfigPanel wConfigPanel) {
            return super.resolveAutoPatch(wConfigPanel);
        }

        @Override
        protected void getAttributes(WConfigPanel wConfigPanel, final ConfigXMLWriter.ElementBody elementBody) {
            int n;
            String string = null;
            LocalObjectAgent localObjectAgent = wConfigPanel.getObjectAgent();
            int n2 = n = localObjectAgent == null ? 0 : this.flowProxyEditor.getNextObjectNum();
            if (n > 0) {
                elementBody.attributes.put("objID", Integer.toString(n));
                string = this.flowProxyEditor.addObjectAgent(n, localObjectAgent);
            }
            super.getAttributes(wConfigPanel, elementBody);
            string = ParsecTools.stripString(string);
            if (string != null) {
                SetupArgIO.readArg(string, new SetupArgIO(){

                    @Override
                    public void processParam(String string, String string2) {
                        elementBody.parameters.put(string, string2);
                    }
                });
            }
            if (wConfigPanel instanceof WModulePanel) {
                elementBody.parameters.remove("unitID");
                elementBody.parameters.remove("unitName");
            }
            if (wConfigPanel instanceof WSinkServicePanel) {
                elementBody.parameters.remove("serviceName");
            }
            if (wConfigPanel instanceof WSinkServicePanel && this.serviceAlloc != null || wConfigPanel instanceof WJackPanel && this.serviceAlloc != null) {
                int n3 = 0;
                String string2 = elementBody.parameters.get("serviceID");
                if (string2 != null) {
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n3 < 1 || n3 > 255) {
                    for (int i = 1; i < this.serviceAlloc.length; ++i) {
                        if (this.serviceAlloc[i] != 0) continue;
                        elementBody.parameters.put("serviceID", Integer.toUnsignedString(i));
                        this.serviceAlloc[i] = 1;
                        break;
                    }
                }
            }
        }

        @Override
        protected void writeElement(String string, StringBuilder stringBuilder, ConfigXMLWriter.ElementBody elementBody) {
            if (elementBody.elementName.equals("collector")) {
                int n;
                stringBuilder.append(string);
                stringBuilder.append("<sourceDriver driverID='IDNServer'>\n");
                InetSocketAddress inetSocketAddress = new InetSocketAddress(7251);
                Component[] componentArray = elementBody.stemPanels;
                int n2 = n = componentArray == null ? 0 : componentArray.length;
                for (int i = 0; i < n; ++i) {
                    WConfigPanel wConfigPanel;
                    if (!(componentArray[i] instanceof WConfigPanel) || !(wConfigPanel = (WConfigPanel)componentArray[i]).getElementSchema().getName().equals("listener")) continue;
                    String string2 = wConfigPanel.getAttrib("style");
                    stringBuilder.append(string).append("  ");
                    stringBuilder.append("<feed");
                    if (string2 != null) {
                        stringBuilder.append(" style='").append(string2).append("'");
                    }
                    stringBuilder.append(" setup='");
                    stringBuilder.append("localAddress:\"");
                    stringBuilder.append(inetSocketAddress.getAddress().getHostAddress());
                    stringBuilder.append(":").append(inetSocketAddress.getPort());
                    stringBuilder.append("\";");
                    stringBuilder.append("'");
                    stringBuilder.append(">\n");
                    stringBuilder.append(string).append("    ");
                    stringBuilder.append("<trunk>\n");
                    this.writeListeners(string + "      ", stringBuilder, string2, inetSocketAddress, componentArray, i);
                    stringBuilder.append(string).append("    ");
                    stringBuilder.append("</trunk>\n");
                    stringBuilder.append(string).append("  ");
                    stringBuilder.append("</feed>\n");
                }
                stringBuilder.append(string);
                stringBuilder.append("</sourceDriver>\n");
            } else {
                if (elementBody.elementSchema instanceof ConfigSchema.Module && (elementBody.elementSchema.getModFlags() & 2) != 0 || elementBody.elementSchema.getName().equals("trunk") && (elementBody.elementSchema.getModFlags() & 1) != 0) {
                    int n;
                    this.serviceAlloc = new byte[256];
                    Component[] componentArray = elementBody.stemPanels;
                    int n3 = n = componentArray == null ? 0 : componentArray.length;
                    for (int i = 0; i < n; ++i) {
                        int n4;
                        WConfigPanel wConfigPanel = (WConfigPanel)componentArray[i];
                        Object object = wConfigPanel.getSetupValue("serviceID");
                        if (!(object instanceof Integer) || (n4 = ((Integer)object).intValue()) < 1 || n4 > 255) continue;
                        this.serviceAlloc[n4] = 1;
                    }
                }
                super.writeElement(string, stringBuilder, elementBody);
                if (elementBody.elementSchema instanceof ConfigSchema.Module || elementBody.elementSchema.getName().equals("trunk")) {
                    this.serviceAlloc = null;
                }
            }
        }

        public XMLWriter(FlowProxyEditor flowProxyEditor) {
            this.flowProxyEditor = flowProxyEditor;
        }

        @Override
        public void writePanel(String string, StringBuilder stringBuilder, WConfigPanel wConfigPanel) {
            String string2;
            if ((wConfigPanel instanceof WFeedPanel || wConfigPanel instanceof WTrunkPanel || wConfigPanel instanceof WJackPanel) && (string2 = wConfigPanel.getAttrib("enabled")) != null) {
                return;
            }
            super.writePanel(string, stringBuilder, wConfigPanel);
        }
    }

    private static class FeedHandler
    extends ProxyStateHandler {
        ArrayList<DrainRequest> drainRequests = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDrainRequests(FlowLogger flowLogger, int n) {
            DatagramSocket datagramSocket = null;
            HashMap<InetSocketAddress, DrainRequest> hashMap = new HashMap<InetSocketAddress, DrainRequest>();
            String string = "??";
            if (n == 129) {
                string = "Start";
            } else if (n == 130) {
                string = "Stop";
            }
            try {
                datagramSocket = new DatagramSocket();
                ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
                int n2 = (int)(Math.random() * 65536.0) & 0xFFFF;
                for (DrainRequest object : this.drainRequests) {
                    for (DLNDrainSet.RouteEntry routeEntry : object.drainSet.getRouteCollection()) {
                        routeEntry.cmd = n;
                        flowLogger.logInfo("DrainRoute " + object.remoteAddr + ": " + string + " captureID " + routeEntry.captureID + " -> serviceID " + routeEntry.serviceID);
                    }
                    if (object.sendRouteRequest(n2, byteBuffer, datagramSocket)) {
                        hashMap.put(object.remoteAddr, object);
                    }
                    n2 = n2 + 1 & 0xFFFF;
                }
                datagramSocket.setSoTimeout(200);
                while (hashMap.size() != 0) {
                    byteBuffer.clear();
                    Object object3 = byteBuffer.array();
                    DatagramPacket datagramPacket = new DatagramPacket((byte[])object3, ((Object)object3).length);
                    datagramSocket.receive(datagramPacket);
                    byteBuffer.limit(datagramPacket.getLength());
                    DrainRequest drainRequest = (DrainRequest)hashMap.remove(datagramPacket.getSocketAddress());
                    if (drainRequest == null) continue;
                    DLNDrainRouteRspPacket dLNDrainRouteRspPacket = new DLNDrainRouteRspPacket();
                    try {
                        dLNDrainRouteRspPacket.readFrom(byteBuffer);
                    }
                    catch (DLNDataException dLNDataException) {
                        continue;
                    }
                    if (dLNDrainRouteRspPacket.getSequence() != drainRequest.sequence) continue;
                    flowLogger.logInfo("DrainRoute " + drainRequest.remoteAddr + ": result=0x" + String.format("%02X", dLNDrainRouteRspPacket.getResult()));
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                for (DrainRequest drainRequest : hashMap.values()) {
                    flowLogger.logInfo("DrainRoute " + drainRequest.remoteAddr + ": No response");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (datagramSocket != null) {
                    datagramSocket.close();
                }
            }
        }

        public void addDrainRequest(DrainRequest drainRequest) {
            this.drainRequests.add(drainRequest);
        }

        @Override
        public void processStarted(FlowLogger flowLogger) {
            this.sendDrainRequests(flowLogger, 129);
        }

        @Override
        public void processStopping(FlowLogger flowLogger) {
            this.sendDrainRequests(flowLogger, 130);
        }
    }

    private static class DrainRequest {
        InetSocketAddress remoteAddr;
        InetSocketAddress localAddr;
        DLNDrainSet drainSet = new DLNDrainSet();
        int sequence;

        private boolean sendRouteRequest(int n, ByteBuffer byteBuffer, DatagramSocket datagramSocket) {
            this.sequence = n;
            boolean bl = false;
            try {
                byteBuffer.rewind();
                DLNDrainRouteReqPacket dLNDrainRouteReqPacket = new DLNDrainRouteReqPacket();
                dLNDrainRouteReqPacket.setSequence(n);
                dLNDrainRouteReqPacket.setDrainSet(this.drainSet);
                dLNDrainRouteReqPacket.writeTo(byteBuffer);
                byte[] byArray = byteBuffer.array();
                int n2 = byteBuffer.position();
                datagramSocket.send(new DatagramPacket(byArray, n2, this.remoteAddr));
                bl = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (DLNDataException dLNDataException) {
                dLNDataException.printStackTrace();
            }
            return bl;
        }

        public DrainRequest(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) {
            this.remoteAddr = inetSocketAddress;
            this.localAddr = inetSocketAddress2;
        }

        public void addCapture(int n, int n2) {
            DLNDrainSet.RouteEntry routeEntry = new DLNDrainSet.RouteEntry();
            if (n == 0) {
                routeEntry.flags |= 2;
            } else {
                routeEntry.captureID = n;
            }
            if (n2 < 0) {
                routeEntry.flags |= 1;
            } else {
                routeEntry.serviceID = n2;
            }
            routeEntry.bridgeType = 33;
            routeEntry.port = this.localAddr.getPort();
            this.drainSet.addRouteEntry(routeEntry);
        }

        public boolean hasCaptureRoutes() {
            return this.drainSet.getRouteCount() != 0;
        }
    }
}

