/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.WDriverPanel;
import dexlogic.parsec.config.WFeedPanel;
import dexlogic.parsec.config.WGraphPanel;
import dexlogic.parsec.config.WJackPanel;
import dexlogic.parsec.config.WModulePanel;
import dexlogic.parsec.config.WPluginServicePanel;
import dexlogic.parsec.config.WSinkDSPPanel;
import dexlogic.parsec.config.WSinkServicePanel;
import dexlogic.parsec.config.WSourceDSPPanel;
import dexlogic.parsec.config.WTrunkPanel;

public class SetupSchema {
    public static Param clientGroupParam_client = new Param("clientGroup", 0, 1);
    public static Param portParam_pushClient = new Param("port", 7123, 1);
    public static Param clientGroupParam_server = new Param("clientGroup", "*", 1);
    public static Param portParam_rtServer = new Param("port", 7255, 1);
    public static Param anchorNumParam_reader = new Param("anchorNum", null, 0);
    public static Param serviceIDParam_reader = new Param("serviceID", null, 0);
    public static Param pathParam = new Param("path", null, 258);
    public static Param addressParam = new Param("address", null, 258);
    public static Param deviceParam = new Param("device", "default", 257);
    public static Param profileParam = new Param("profile", null, 0);
    public static Param mappingParam = new Param("mapping", null, 0);
    public static Param serviceIDParam = new Param("serviceID", 0, 257);
    public static Param serviceTypeParam = new Param("serviceType", null, 0);
    public static Param delayParam = new Param("delay", 0, 1);
    public static Param titleParam = new Param("title", "default", 1);
    public static Param overdubParam = new Param("overdub", false, 1);
    public static Attrib refNameAttrib = new Attrib("name");
    public static Attrib schemeAttrib = new Attrib("scheme");
    public static Attrib patchAttrib = new Attrib("patch");
    public static Attrib setupAttrib = new Attrib("setup");
    public static Attrib rpcAttrib = new Attrib("rpc");
    public static Attrib[] sinkServiceAttribs = new Attrib[]{schemeAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] moduleAttribs = new Attrib[]{schemeAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] pluginServiceAttribs = new Attrib[]{schemeAttrib, refNameAttrib, patchAttrib, setupAttrib, rpcAttrib};
    public static Attrib[] jackAttribs = new Attrib[]{refNameAttrib, patchAttrib, setupAttrib};
    public static Attrib[] trunkAttribs = new Attrib[]{refNameAttrib, setupAttrib};
    public static Attrib[] feedAttribs = new Attrib[]{schemeAttrib, refNameAttrib, setupAttrib};
    public static Attrib driverIDAttrib = new Attrib("driverID");
    public static Attrib[] sourceDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] pluginDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] sinkDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, setupAttrib};
    public static Element idnClientService = new Element("service", "Service", 256, WSinkServicePanel.class, 0, new Param[]{delayParam, serviceIDParam}, sinkServiceAttribs, new Element[]{SetupSchema.buildSinkPluginElement()});
    public static Element brtClientModule = new Module("IDN-BRT", "IDN-BRT Client", 0, WModulePanel.class, 0, new Param[]{addressParam, delayParam}, moduleAttribs, new Element[]{idnClientService});
    public static Element rtClientModule = new Module("IDN-RT", "IDN-RT Client", 0, WModulePanel.class, 0, new Param[]{addressParam, delayParam}, moduleAttribs, new Element[]{idnClientService});
    public static Element pushClientModule = new Module("push", "Push Client", 0, WModulePanel.class, 0, new Param[]{portParam_pushClient, delayParam}, moduleAttribs, new Element[]{idnClientService});
    public static Driver idnClientDriver = new Driver("sinkDriver", "IDNClient", "IDN Client Driver", 0, WDriverPanel.class, 0, new Param[]{clientGroupParam_client, delayParam}, sinkDriverAttribs, new Element[]{rtClientModule, brtClientModule, pushClientModule});
    public static Element writerService = new Element("service", "Track", 256, WSinkServicePanel.class, 0, new Param[]{delayParam, serviceIDParam}, sinkServiceAttribs, new Element[]{SetupSchema.buildSinkPluginElement()});
    public static Element writerModule = new Module("IDN", "IDN Writer", 32, WModulePanel.class, 16, new Param[]{pathParam, titleParam, overdubParam}, moduleAttribs, new Element[]{writerService});
    public static Driver fileWriterDriver = new Driver("sinkDriver", "FileWriter", "File Writer Driver", 0, WDriverPanel.class, 0, null, sinkDriverAttribs, new Element[]{writerModule});
    public static Element outletService = new Element("service", "Service", 0, WSinkServicePanel.class, 0, new Param[]{delayParam}, sinkServiceAttribs, new Element[]{SetupSchema.buildSinkPluginElement()});
    public static Element outletModule = new Module("", "Sink Module", 0, WModulePanel.class, 0, new Param[]{deviceParam}, moduleAttribs, new Element[]{outletService});
    public static Driver sysOutletDriver = new Driver("sinkDriver", "SysOutlet", "Local Output Driver", 0, WDriverPanel.class, 0, null, sinkDriverAttribs, new Element[]{outletModule});
    public static Element laproFilterService = new Element("service", "Service", 0, WPluginServicePanel.class, 0, null, pluginServiceAttribs, new Element[]{SetupSchema.buildSourcePluginElement()});
    public static Driver laproFilterDriver = new Driver("pluginDriver", "LaproFilter", "Laser Projector Filter", 0, WDriverPanel.class, 0, null, pluginDriverAttribs, new Element[]{laproFilterService});
    public static Element idnRTJack = new Element("jack", "Jack", 256, WJackPanel.class, 1, new Param[]{serviceIDParam, serviceTypeParam}, jackAttribs, new Element[]{SetupSchema.buildSourcePluginElement()});
    public static Element idnRTTrunk = new Element("trunk", "Trunk", 0, WTrunkPanel.class, 0, new Param[]{clientGroupParam_server}, trunkAttribs, new Element[]{idnRTJack});
    public static Feed idnRTServerFeed = new Feed("IDN-RT", "IDN-RT Server", 0, WFeedPanel.class, 0, new Param[]{portParam_rtServer}, feedAttribs, new Element[]{idnRTTrunk});
    public static Feed idnPullServerFeed = new Feed("pull", "IDN Pull Server", 32, WFeedPanel.class, 0, new Param[]{addressParam}, feedAttribs, null);
    public static Driver idnServerDriver = new Driver("sourceDriver", "IDNServer", "IDN Server Driver", 0, WDriverPanel.class, 0, null, sourceDriverAttribs, new Element[]{idnRTServerFeed, idnPullServerFeed});
    public static Element idnReaderJack = new Element("jack", "Jack", 16, WJackPanel.class, 16, new Param[]{serviceIDParam_reader}, jackAttribs, new Element[]{SetupSchema.buildSourcePluginElement()});
    public static Element idnReaderTrunk = new Element("trunk", "Trunk", 16, WTrunkPanel.class, 1, new Param[]{anchorNumParam_reader}, trunkAttribs, new Element[]{idnReaderJack});
    public static Feed idnReaderFeed = new Feed("IDN", "IDN Reader", 32, WFeedPanel.class, 0, new Param[]{pathParam}, feedAttribs, new Element[]{idnReaderTrunk});
    public static Element wavReaderJack = new Element("jack", "Jack", 16, WJackPanel.class, 32, new Param[]{mappingParam}, jackAttribs, new Element[]{SetupSchema.buildSourcePluginElement()});
    public static Element wavReaderTrunk = new Element("trunk", "Trunk", 16, WTrunkPanel.class, 2, new Param[]{profileParam}, new Attrib[]{refNameAttrib, new Attrib("layout"), setupAttrib}, new Element[]{wavReaderJack});
    public static Feed wavReaderFeed = new Feed("WAV", "WAV Reader", 32, WFeedPanel.class, 0, new Param[]{pathParam}, feedAttribs, new Element[]{wavReaderTrunk});
    public static Driver fileReaderDriver = new Driver("sourceDriver", "FileReader", "File Reader Driver", 0, WDriverPanel.class, 0, null, sourceDriverAttribs, new Element[]{idnReaderFeed, wavReaderFeed});
    public static Element inletJack = new Element("jack", "Jack", 0, WJackPanel.class, 0, null, jackAttribs, new Element[]{SetupSchema.buildSourcePluginElement()});
    public static Element inletTrunk = new Element("trunk", "Trunk", 0, WTrunkPanel.class, 0, null, trunkAttribs, new Element[]{inletJack});
    public static Feed pcmInletFeed = new Feed("PCM", "PCM Feed", 0, WFeedPanel.class, 0, new Param[]{deviceParam}, feedAttribs, new Element[]{inletTrunk});
    public static Driver sysInletDriver = new Driver("sourceDriver", "SysInlet", "Local Input Driver", 0, WDriverPanel.class, 0, null, sourceDriverAttribs, new Element[]{pcmInletFeed});
    public static Element sourceSystemElement = new Element("sourceSystem", "Source System", 0, WGraphPanel.class, 0, null, null, new Element[]{idnServerDriver, fileReaderDriver, sysInletDriver});
    public static Element baseSystemElement = new Element("baseSystem", "Base System", 0, WGraphPanel.class, 0, null, null, new Element[]{idnClientDriver, fileWriterDriver, sysOutletDriver, null, laproFilterDriver, null, idnServerDriver, fileReaderDriver, sysInletDriver});
    public static Element pdcxRootElement = new Element(null, null, 0, null, 0, null, null, new Element[]{sourceSystemElement, baseSystemElement});

    private static Element buildSinkPluginElement() {
        Element element = new Element("plugin", "DSP", 1, WSinkDSPPanel.class, 0, null, null, null);
        element.childSchemas = new Element[]{element};
        return element;
    }

    private static Element buildSourcePluginElement() {
        Element element = new Element("plugin", "DSP", 0, WSourceDSPPanel.class, 0, null, null, null);
        element.childSchemas = new Element[]{element};
        return element;
    }

    public static class Driver
    extends Element {
        private String driverID;

        public Driver(String string, String string2, String string3, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super(string, string3, n, clazz, n2, paramArray, attribArray, elementArray);
            this.driverID = string2;
        }

        public String getDriverID() {
            return this.driverID;
        }
    }

    public static class Feed
    extends Element {
        private String scheme;

        public Feed(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("feed", string2, n, clazz, n2, paramArray, attribArray, elementArray);
            this.scheme = string;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static class Module
    extends Element {
        private String scheme;

        public Module(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("module", string2, n, clazz, n2, paramArray, attribArray, elementArray);
            this.scheme = string;
        }

        public String getScheme() {
            return this.scheme;
        }
    }

    public static class Element {
        private String name;
        private String title;
        private int flags;
        private Class<?> panelClass;
        private int modFlags;
        private Param[] params;
        private Attrib[] attribs;
        Element[] childSchemas;
        private static final int SERVICETYPE_FLAG = 256;
        private static final int CONCEALED_FLAG = 32;
        private static final int DESIGNATED_FLAG = 16;
        private static final int ONLY_CHILD_FLAG = 1;

        public Element(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            this.name = string;
            this.title = string2;
            this.flags = n;
            this.panelClass = clazz;
            this.modFlags = n2;
            this.params = paramArray;
            this.attribs = attribArray;
            this.childSchemas = elementArray;
        }

        public String getName() {
            return this.name;
        }

        public boolean isServiceType() {
            return (this.flags & 0x100) != 0;
        }

        public boolean isConcealed() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isDesignated() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isOnlyChild() {
            return (this.flags & 1) != 0;
        }

        public Class<?> getPanelClass() {
            return this.panelClass;
        }

        public int getModFlags() {
            return this.modFlags;
        }

        public Param[] getParams() {
            return this.params;
        }

        public Attrib[] getAttribs() {
            return this.attribs;
        }

        public Element[] getChildSchemas() {
            return this.childSchemas;
        }

        public String toString() {
            return this.title;
        }
    }

    public static class Attrib {
        private String name;

        public Attrib(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Param {
        private String name;
        private Object defaultValue;
        int flags;
        private static final int OUTLINE_FLAG = 256;
        private static final int CONCEALED_FLAG = 2;
        private static final int MUTABLE_FLAG = 1;

        public Param(String string, Object object, int n) {
            this.name = string;
            this.defaultValue = object;
            this.flags = n;
        }

        public String getName() {
            return this.name;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isOutline() {
            return (this.flags & 0x100) != 0;
        }

        public boolean isConcealed() {
            return (this.flags & 2) != 0;
        }

        public boolean isMutable() {
            return (this.flags & 1) != 0;
        }
    }
}

