/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.ServiceList;
import java.util.HashMap;

public class ServiceManager {
    private HashMap<String, ServiceInfo[]> serviceMap = new HashMap();
    private HashMap<ServiceInfo, ServiceList> listMap = new HashMap();
    private HashMap<Integer, ServiceList> typeMap = new HashMap();
    private ServiceList unifiedList = new ServiceList();

    private ServiceList getServiceList(int n) {
        if (n < 0) {
            return null;
        }
        ServiceList serviceList = this.typeMap.get(n);
        if (serviceList == null) {
            serviceList = new ServiceList();
            this.typeMap.put(n, serviceList);
        }
        return serviceList;
    }

    private void listUpdate(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
        ServiceList serviceList = null;
        if (serviceInfo != null) {
            serviceList = this.listMap.get(serviceInfo);
        }
        ServiceList serviceList2 = null;
        if (serviceInfo2 != null) {
            serviceList2 = this.getServiceList(serviceInfo2.getServiceType());
        }
        if (serviceInfo != null) {
            this.listMap.remove(serviceInfo);
        }
        if (serviceInfo2 != null) {
            this.listMap.put(serviceInfo2, serviceList2);
        }
        if (serviceList != null && serviceList == serviceList2) {
            serviceList.serviceChanged(serviceInfo, serviceInfo2);
        } else {
            if (serviceList != null) {
                serviceList.serviceChanged(serviceInfo, null);
            }
            if (serviceList2 != null) {
                serviceList2.serviceChanged(null, serviceInfo2);
            }
        }
        if (serviceInfo2 != null) {
            serviceInfo2.setActive(true);
        }
        this.unifiedList.serviceChanged(serviceInfo, serviceInfo2);
    }

    public void serviceUpdate(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
        boolean bl;
        ServiceInfo[] serviceInfoArray;
        String string;
        int n;
        String string2;
        ServiceInfo serviceInfo3 = null;
        if (serviceInfo != null) {
            string2 = serviceInfo.getServiceName();
            n = serviceInfo.getServiceType();
            if (string2 == null || string2.length() == 0 || n < 0) {
                throw new RuntimeException("Invalid old service info");
            }
            string = string2.toLowerCase();
            serviceInfoArray = this.serviceMap.get(string);
            bl = serviceInfoArray != null && serviceInfo == serviceInfoArray[0];
            if ((serviceInfoArray = ParsecTools.arrayRemove(serviceInfoArray, serviceInfo)) == null) {
                this.serviceMap.remove(string);
            } else {
                this.serviceMap.put(string, serviceInfoArray);
            }
            if (bl) {
                if (serviceInfoArray != null) {
                    if (serviceInfo.equals(serviceInfoArray[0])) {
                        this.listUpdate(serviceInfo, serviceInfoArray[0]);
                        serviceInfo = null;
                    } else {
                        serviceInfo3 = serviceInfoArray[0];
                    }
                }
            } else {
                serviceInfo = null;
            }
        }
        if (serviceInfo2 != null) {
            string2 = serviceInfo2.getServiceName();
            n = serviceInfo2.getServiceType();
            if (string2 == null || string2.length() == 0 || n < 0) {
                throw new RuntimeException("Invalid new service info");
            }
            string = string2.toLowerCase();
            serviceInfoArray = this.serviceMap.get(string);
            boolean bl2 = bl = serviceInfoArray != null;
            if (!string2.equals("void")) {
                serviceInfoArray = ParsecTools.arrayAdd(ServiceInfo.class, serviceInfoArray, serviceInfo2);
                this.serviceMap.put(string, serviceInfoArray);
            }
            if (bl) {
                serviceInfo2.setActive(false);
                serviceInfo2 = null;
            }
        }
        if (serviceInfo != null || serviceInfo2 != null) {
            this.listUpdate(serviceInfo, serviceInfo2);
        }
        if (serviceInfo3 != null) {
            this.listUpdate(null, serviceInfo3);
        }
    }

    public ServiceList[] getServiceLists(int n) {
        if (n > 0) {
            ServiceList serviceList = this.getServiceList(n);
            ServiceList serviceList2 = this.getServiceList(0);
            return new ServiceList[]{serviceList, serviceList2};
        }
        if (n == 0) {
            return new ServiceList[]{this.unifiedList};
        }
        return null;
    }
}

