/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.netscan.NetScanServer;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.DefaultPortSocketAddress;
import dexlogic.parsec.config.ScanPanelMerger;
import dexlogic.parsec.config.WConfigPanel;
import java.net.InetSocketAddress;

public class ScanServerMerger
extends ScanPanelMerger {
    protected int getDefaultPort(Object object) {
        return -1;
    }

    @Override
    protected boolean amendPanel(WConfigPanel wConfigPanel, Object object) throws ParsecException {
        int n;
        DefaultPortSocketAddress defaultPortSocketAddress;
        String string;
        InetSocketAddress inetSocketAddress;
        if (!(object instanceof NetScanServer)) {
            return false;
        }
        NetScanServer netScanServer = (NetScanServer)object;
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = netScanServer == null ? null : netScanServer.getDefaultAddress();
        if (inetSocketAddress == null) {
            return false;
        }
        Object object2 = netScanServer.getHostID();
        if (!object2.equals(wConfigPanel.getSetupValue("unitID"))) {
            wConfigPanel.putSetupValue("unitID", object2);
        }
        if (!ParsecTools.compareString(string = netScanServer.getHostName(), (String)wConfigPanel.getSetupValue("unitName"))) {
            wConfigPanel.putSetupValue("unitName", string);
        }
        if (!(defaultPortSocketAddress = new DefaultPortSocketAddress(inetSocketAddress, n = this.getDefaultPort(object))).equals(wConfigPanel.getSetupValue("remoteAddress"))) {
            wConfigPanel.putSetupValue("remoteAddress", defaultPortSocketAddress);
        }
        return true;
    }

    @Override
    protected Object createPanelContext(WConfigPanel wConfigPanel) {
        PanelContext panelContext = new PanelContext();
        Object object = wConfigPanel.getSetupValue("remoteAddress");
        if (object instanceof DefaultPortSocketAddress) {
            panelContext.remoteSockAddress = ((DefaultPortSocketAddress)object).getInetSocketAddress();
        }
        panelContext.remotePort = panelContext.remoteSockAddress == null ? -1 : panelContext.remoteSockAddress.getPort();
        panelContext.unitID = wConfigPanel.getSetupValue("unitID");
        panelContext.unitName = wConfigPanel.getSetupValue("unitName");
        if (panelContext.unitName != null) {
            panelContext.unitName = panelContext.unitName.toString();
        }
        if (panelContext.unitName != null && ((String)panelContext.unitName).isEmpty()) {
            panelContext.unitName = null;
        }
        return panelContext;
    }

    @Override
    protected int determinePanelMatch(Object object, Object object2) {
        if (!(object instanceof PanelContext)) {
            return 0;
        }
        PanelContext panelContext = (PanelContext)object;
        if (!(object2 instanceof NetScanServer)) {
            return 0;
        }
        NetScanServer netScanServer = (NetScanServer)object2;
        InetSocketAddress inetSocketAddress = netScanServer.getDefaultAddress();
        int n = inetSocketAddress == null ? -1 : inetSocketAddress.getPort();
        boolean bl = panelContext.remoteSockAddress != null && panelContext.remoteSockAddress.equals(inetSocketAddress);
        boolean bl2 = panelContext.remotePort > 0 && panelContext.remotePort == n;
        boolean bl3 = panelContext.unitName != null && panelContext.unitName.equals(netScanServer.getHostName());
        int n2 = 0;
        if (panelContext.unitID != null && panelContext.unitID.equals(netScanServer.getHostID())) {
            n2 = bl3 && bl ? 10 : (bl3 && bl2 ? 9 : (bl3 ? 8 : 7));
        } else if (panelContext.unitID == null) {
            if (bl3 && bl) {
                n2 = 5;
            } else if (bl3 && bl2) {
                n2 = 4;
            } else if (bl3) {
                n2 = 3;
            } else if (bl) {
                n2 = 2;
            }
        }
        return n2;
    }

    public ScanServerMerger(ScanPanelMerger scanPanelMerger) {
        super(scanPanelMerger);
    }

    private static class PanelContext {
        InetSocketAddress remoteSockAddress;
        int remotePort;
        Object unitID;
        Object unitName;

        private PanelContext() {
        }
    }
}

