/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.idn.IDNServiceMap;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.ScanPanelMerger;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WSinkServicePanel;

class IDNServiceMerger
extends ScanPanelMerger {
    @Override
    protected void setChecked(WConfigPanel wConfigPanel, boolean bl, boolean bl2) {
        if (wConfigPanel instanceof WSinkServicePanel) {
            ((WSinkServicePanel)wConfigPanel).setChecked(bl, bl2);
        }
    }

    @Override
    protected boolean amendPanel(WConfigPanel wConfigPanel, Object object) throws ParsecException {
        Object object2;
        if (!(object instanceof IDNServiceMap.ServiceEntry)) {
            return false;
        }
        IDNServiceMap.ServiceEntry serviceEntry = (IDNServiceMap.ServiceEntry)object;
        if (serviceEntry.serviceID > 0 && serviceEntry.serviceID <= 255) {
            object2 = wConfigPanel.getSetupValue("serviceID");
            Integer n = serviceEntry.serviceID;
            if (!((Object)n).equals(object2)) {
                if ((serviceEntry.flags & 1) == 0) {
                    wConfigPanel.putSetupValue("serviceID", n);
                } else if (object2 != null) {
                    if (!(object2 instanceof Integer) || (Integer)object2 != 0) {
                        wConfigPanel.putSetupValue("serviceID", n);
                    } else {
                        wConfigPanel.putSetupValue("serviceID", null);
                    }
                }
            }
        }
        if (!ParsecTools.compareString((String)(object2 = serviceEntry.serviceName), (String)wConfigPanel.getSetupValue("serviceName"))) {
            wConfigPanel.putSetupValue("serviceName", object2);
        }
        return true;
    }

    @Override
    protected Object createPanelContext(WConfigPanel wConfigPanel) {
        PanelContext panelContext = new PanelContext();
        panelContext.serviceType = ParsecTools.getServiceTypeInt(wConfigPanel.getAttrib("style"));
        if (panelContext.serviceType < 0 || panelContext.serviceType > 255) {
            return null;
        }
        Object object = wConfigPanel.getSetupValue("serviceID");
        if (object instanceof Integer) {
            panelContext.serviceID = (Integer)object;
        } else if (object == null) {
            panelContext.serviceID = 0;
        } else {
            return null;
        }
        if (panelContext.serviceID < 0 || panelContext.serviceID > 255) {
            return null;
        }
        panelContext.serviceName = (String)wConfigPanel.getSetupValue("serviceName");
        return panelContext;
    }

    @Override
    protected int determinePanelMatch(Object object, Object object2) {
        if (!(object instanceof PanelContext)) {
            return 0;
        }
        PanelContext panelContext = (PanelContext)object;
        if (!(object2 instanceof IDNServiceMap.ServiceEntry)) {
            return 0;
        }
        IDNServiceMap.ServiceEntry serviceEntry = (IDNServiceMap.ServiceEntry)object2;
        if (serviceEntry.serviceType != panelContext.serviceType) {
            return 0;
        }
        if (serviceEntry.serviceID <= 0 || serviceEntry.serviceID > 255) {
            return 0;
        }
        boolean bl = (serviceEntry.flags & 1) != 0;
        boolean bl2 = panelContext.serviceID == serviceEntry.serviceID;
        boolean bl3 = panelContext.serviceName != null && !panelContext.serviceName.isEmpty() && panelContext.serviceName.equals(serviceEntry.serviceName);
        int n = 0;
        if (bl3 && (bl2 |= bl && panelContext.serviceID == 0)) {
            n = 3;
        } else if (bl3 && panelContext.serviceID != 0) {
            n = 2;
        } else if (bl2) {
            n = 1;
        }
        return n;
    }

    @Override
    protected int checkGeneric(WConfigPanel wConfigPanel) {
        int n = -1;
        Object object = wConfigPanel.getSetupValue("serviceID");
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object == null) {
            n = 0;
        } else {
            return 0;
        }
        return n == 0 ? GENTYPE_DEFAULT : 0;
    }

    @Override
    protected ConfigSchema.Element findElementSchema(WConfigPanel wConfigPanel, Object object) {
        if (object instanceof IDNServiceMap.ServiceEntry) {
            int n;
            ConfigSchema.Element[] elementArray = wConfigPanel.getElementSchema().getChildSchemas();
            int n2 = n = elementArray == null ? 0 : elementArray.length;
            for (int i = 0; i < n; ++i) {
                ConfigSchema.Element element = elementArray[i];
                if (!(element instanceof ConfigSchema.Service)) continue;
                return (ConfigSchema.Service)element;
            }
        }
        return null;
    }

    @Override
    protected WConfigPanel addConfigPanel(WConfigPanel wConfigPanel, Object object, boolean bl) throws ParsecException {
        String string;
        if (!(object instanceof IDNServiceMap.ServiceEntry)) {
            return null;
        }
        IDNServiceMap.ServiceEntry serviceEntry = (IDNServiceMap.ServiceEntry)object;
        if (serviceEntry.serviceType < 0 || serviceEntry.serviceType > 255) {
            return null;
        }
        if (serviceEntry.serviceID < 0 || serviceEntry.serviceID > 255) {
            return null;
        }
        if (serviceEntry.serviceID == 0 && !bl) {
            return null;
        }
        WConfigPanel wConfigPanel2 = super.addConfigPanel(wConfigPanel, object, bl);
        if (wConfigPanel2 == null) {
            return null;
        }
        wConfigPanel2.putAttrib("style", ParsecTools.getServiceTypeText(serviceEntry.serviceType));
        if (serviceEntry.serviceName != null && !serviceEntry.serviceName.isEmpty()) {
            wConfigPanel2.putAttrib("name", serviceEntry.serviceName);
        } else if (bl && (string = (String)wConfigPanel.getSetupValue("unitName")) != null && !string.isEmpty()) {
            wConfigPanel2.putAttrib("name", string);
        }
        if (serviceEntry.serviceID != 0) {
            wConfigPanel2.putSetupValue("serviceID", serviceEntry.serviceID);
        }
        return wConfigPanel2;
    }

    public IDNServiceMerger() {
        super(null);
    }

    private static class PanelContext {
        int serviceType;
        int serviceID;
        String serviceName;

        private PanelContext() {
        }
    }
}

